/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.activitymodel.defaultimplementation;

import de.aristaflow.adept2.model.activitymodel.InheritedActivityConfiguration;
import de.aristaflow.adept2.model.activitymodel.InheritedConfiguration;
import de.aristaflow.adept2.model.activitymodel.defaultimplementation.DefaultInheritedConfiguration;
import de.aristaflow.adept2.util.ArgChecks;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DefaultInheritedActivityConfiguration
extends DefaultInheritedConfiguration
implements InheritedActivityConfiguration {
    private static final long serialVersionUID = 3056283316890171363L;
    protected HashMap<String, String> fromParameters;
    protected HashMap<String, String> fromConfigurations;

    public DefaultInheritedActivityConfiguration() {
        this((InheritedConfiguration)null, (String)null, (InheritedActivityConfiguration)null);
    }

    public DefaultInheritedActivityConfiguration(InheritedConfiguration parent, Map<String, String> values, Map<String, String> fromParameters, Map<String, String> fromConfigurations, Set<String> fixedForChildren) {
        this.parent = parent;
        HashSet<String> entryNames = new HashSet<String>();
        if (values != null) {
            entryNames.addAll(values.keySet());
        }
        if (fromParameters != null) {
            entryNames.addAll(fromParameters.keySet());
        }
        if (fromConfigurations != null) {
            entryNames.addAll(fromConfigurations.keySet());
        }
        this.setValues(null);
        this.setFromInputParameters(null);
        this.setFromProcessConfiguration(null);
        this.setFixedForChildren(fixedForChildren);
        for (String entryName : entryNames) {
            String value = values == null ? null : values.get(entryName);
            String fromParameter = fromParameters == null ? null : fromParameters.get(entryName);
            String fromConfiguration = fromConfigurations == null ? null : fromConfigurations.get(entryName);
            int count = 0;
            if (value != null) {
                ++count;
            }
            if (fromParameter != null) {
                ++count;
            }
            if (fromConfiguration != null) {
                ++count;
            }
            switch (count) {
                case 0: {
                    this.removeInheritedValue(entryName);
                    break;
                }
                case 1: {
                    if (value != null) {
                        this.setString(entryName, value);
                        break;
                    }
                    if (fromParameter != null) {
                        this.setFromInputParameter(entryName, fromParameter);
                        break;
                    }
                    this.setFromProcessConfiguration(entryName, fromConfiguration);
                    break;
                }
                default: {
                    String msg = "only one of value, fromInputParameter and fromProcessConfiguration may be specified for " + entryName;
                    throw new IllegalArgumentException(msg);
                }
            }
        }
    }

    public DefaultInheritedActivityConfiguration(InheritedConfiguration parent, String originID, InheritedActivityConfiguration template) {
        this.parent = parent;
        this.originID = originID;
        HashMap<String, String> values = null;
        HashMap<String, String> fromParameters = null;
        HashMap<String, String> fromConfigurations = null;
        HashSet<String> fixedForChildren = null;
        if (template != null) {
            values = new HashMap<String, String>();
            fromParameters = new HashMap<String, String>();
            fromConfigurations = new HashMap<String, String>();
            fixedForChildren = new HashSet<String>();
            for (String entryName : template.getAllEntries()) {
                if (!template.isInherited(entryName)) {
                    String value = template.getString(entryName);
                    String fromParameter = template.fromInputParameter(entryName);
                    String fromConfiguration = template.fromProcessConfiguration(entryName);
                    if (fromConfiguration != null) {
                        fromConfigurations.put(entryName, fromConfiguration);
                    } else if (fromParameter != null) {
                        fromParameters.put(entryName, fromParameter);
                    } else if (value != null) {
                        values.put(entryName, value);
                    } else if (parent != null) {
                        if (parent.getString(entryName) != null) {
                            values.put(entryName, null);
                        } else if (parent instanceof InheritedActivityConfiguration) {
                            InheritedActivityConfiguration parentAc = (InheritedActivityConfiguration)parent;
                            if (parentAc.fromInputParameter(entryName) != null) {
                                fromParameters.put(entryName, null);
                            } else if (parentAc.fromProcessConfiguration(entryName) != null) {
                                fromConfigurations.put(entryName, null);
                            }
                        }
                    }
                }
                if (template.isFixedForChildrenInherited(entryName) || !template.isFixedForChildren(entryName)) continue;
                fixedForChildren.add(entryName);
            }
        }
        this.setValues(values);
        this.setFromInputParameters(fromParameters);
        this.setFromProcessConfiguration(fromConfigurations);
        this.setFixedForChildren(fixedForChildren);
    }

    public DefaultInheritedActivityConfiguration(InheritedConfiguration parent, String originID, InheritedConfiguration template) {
        super(parent, originID, template);
        this.setFromInputParameters(null);
        this.setFromProcessConfiguration(null);
    }

    @Override
    public Set<String> getAllEntries() {
        HashSet<Object> entryNames = this.parent != null ? new HashSet<String>(this.parent.getAllEntries()) : new HashSet();
        entryNames.addAll(this.values.keySet());
        entryNames.addAll(this.fromParameters.keySet());
        entryNames.addAll(this.fromConfigurations.keySet());
        return entryNames;
    }

    @Override
    public void setString(String entryName, String value) {
        super.setString(entryName, value);
        this.fromParameters.remove(entryName);
        this.fromConfigurations.remove(entryName);
    }

    @Override
    public String fromInputParameter(String entryName) {
        ArgChecks.checkForNull(entryName, "entryName");
        String paramName = null;
        if (this.fromParameters.containsKey(entryName)) {
            paramName = this.fromParameters.get(entryName);
        } else if (this.isParentActConf()) {
            paramName = this.getParent().fromInputParameter(entryName);
        }
        return paramName;
    }

    @Override
    public void setFromInputParameter(String entryName, String inputParameterName) {
        ArgChecks.checkForNull(entryName, "entryName");
        ArgChecks.checkForEmpty(inputParameterName, "inputParameterName");
        if (this.isFixed(entryName)) {
            String msg = "The configuration entry '%s' is fixed!";
            msg = String.format(msg, entryName);
            throw new IllegalStateException(msg);
        }
        this.fromParameters.put(entryName, inputParameterName);
        this.values.remove(entryName);
        this.fromConfigurations.remove(entryName);
    }

    private void setFromInputParameters(Map<String, String> fromParameters) {
        this.fromParameters = fromParameters == null ? new HashMap() : new HashMap<String, String>(fromParameters);
    }

    @Override
    public String fromProcessConfiguration(String entryName) {
        ArgChecks.checkForNull(entryName, "entryName");
        String confName = null;
        if (this.fromConfigurations.containsKey(entryName)) {
            confName = this.fromConfigurations.get(entryName);
        } else if (this.isParentActConf()) {
            confName = this.getParent().fromProcessConfiguration(entryName);
        }
        return confName;
    }

    @Override
    public void setFromProcessConfiguration(String entryName, String configurationEntry) {
        ArgChecks.checkForNull(entryName, "entryName");
        ArgChecks.checkForEmpty(configurationEntry, "configurationEntry");
        if (this.isFixed(entryName)) {
            String msg = "The configuration entry '%s' is fixed!";
            msg = String.format(msg, entryName);
            throw new IllegalStateException(msg);
        }
        this.fromConfigurations.put(entryName, configurationEntry);
        this.values.remove(entryName);
        this.fromParameters.remove(entryName);
    }

    private void setFromProcessConfiguration(Map<String, String> fromConfigurations) {
        this.fromConfigurations = fromConfigurations == null ? new HashMap() : new HashMap<String, String>(fromConfigurations);
    }

    @Override
    public void remove(String entryName) {
        super.remove(entryName);
        this.fromParameters.remove(entryName);
        this.fromConfigurations.remove(entryName);
    }

    @Override
    public boolean isInherited(String entryName) {
        ArgChecks.checkForNull(entryName, "entryName");
        return !this.values.containsKey(entryName) && !this.fromParameters.containsKey(entryName) && !this.fromConfigurations.containsKey(entryName);
    }

    @Override
    public boolean isOverriding(String entryName) {
        ArgChecks.checkForNull(entryName, "entryName");
        if (this.parent == null) {
            return false;
        }
        if (this.isInherited(entryName)) {
            return false;
        }
        if (this.isParentActConf()) {
            return this.parent.getString(entryName) != null || this.getParent().fromInputParameter(entryName) != null || this.getParent().fromProcessConfiguration(entryName) != null;
        }
        return this.parent.getString(entryName) != null;
    }

    @Override
    public void removeInheritedValue(String entryName) {
        ArgChecks.checkForNull(entryName, "entryName");
        if (this.parent == null) {
            return;
        }
        if (this.isFixed(entryName)) {
            String msg = "The configuration entry '%s' is fixed!";
            msg = String.format(msg, entryName);
            throw new IllegalStateException(msg);
        }
        if (this.parent.getString(entryName) != null) {
            this.values.put(entryName, null);
            this.fromParameters.remove(entryName);
            this.fromConfigurations.remove(entryName);
        } else if (this.isParentActConf()) {
            if (this.getParent().fromInputParameter(entryName) != null) {
                this.fromParameters.put(entryName, null);
                this.fromConfigurations.remove(entryName);
            } else if (this.getParent().fromProcessConfiguration(entryName) != null) {
                this.fromConfigurations.put(entryName, null);
            }
        }
    }

    private boolean isParentActConf() {
        return this.parent instanceof InheritedActivityConfiguration;
    }

    private InheritedActivityConfiguration getParent() {
        return (InheritedActivityConfiguration)this.parent;
    }
}

