/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.activitymodel.defaultimplementation;

import de.aristaflow.adept2.model.activitymodel.InheritedCollection;
import de.aristaflow.adept2.util.ArgChecks;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

abstract class DefaultInheritedCollection<K, V>
implements InheritedCollection<K, V>,
Serializable {
    protected InheritedCollection<K, V> parent;
    protected String originID;
    protected Map<K, V> elements;

    DefaultInheritedCollection(InheritedCollection<K, V> parent, Map<K, V> elements) {
        this.parent = parent;
        this.elements = elements == null ? new HashMap() : new HashMap<K, V>(elements);
    }

    DefaultInheritedCollection(InheritedCollection<K, V> parent, String originID, InheritedCollection<K, V> template) {
        this.parent = parent;
        this.originID = originID;
        this.elements = template == null ? new HashMap() : template.getAllOwn();
    }

    @Override
    public Map<K, V> getAll() {
        if (this.parent != null) {
            Map<K, V> result = this.parent.getAll();
            result.putAll(this.getAllOwn());
            return result;
        }
        return this.getAllOwn();
    }

    @Override
    public Map<K, V> getAllOwn() {
        HashMap<K, Object> result = new HashMap<K, Object>(this.elements.size());
        for (K key : this.elements.keySet()) {
            V parent = this.parent == null ? null : (V)this.parent.get(key);
            V element = this.elements.get(key);
            if (element == null) {
                result.put(key, null);
                continue;
            }
            result.put(key, this.cloneValue(parent, element));
        }
        return result;
    }

    @Override
    public V get(K key) {
        V value;
        Object parent;
        ArgChecks.checkForNull(key, "key");
        Object v0 = parent = this.parent == null ? null : this.parent.get(key);
        Object result = this.elements.containsKey(key) ? ((value = this.elements.get(key)) == null ? null : this.cloneValue(parent, value)) : (this.parent != null ? parent : null);
        return result;
    }

    @Override
    public void set(K key, V element) {
        ArgChecks.checkForNull(key, "key");
        ArgChecks.checkForNull(element, "element");
        this.elements.put(key, this.cloneValue(null, element));
    }

    @Override
    public boolean isInherited(K key) {
        ArgChecks.checkForNull(key, "key");
        return !this.elements.containsKey(key);
    }

    @Override
    public void removeOwnValue(K key) {
        ArgChecks.checkForNull(key, "key");
        this.elements.remove(key);
    }

    abstract V cloneValue(V var1, V var2);
}

