/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.activitymodel.defaultimplementation;

import de.aristaflow.adept2.model.activitymodel.InheritedConfiguration;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.ConfigurationTools;
import java.io.Serializable;
import java.net.URI;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DefaultInheritedConfiguration
implements InheritedConfiguration,
Serializable {
    private static final long serialVersionUID = 1067848403820006530L;
    protected InheritedConfiguration parent;
    protected String originID;
    protected HashMap<String, String> values;
    protected HashSet<String> fixedForChildren;

    public DefaultInheritedConfiguration() {
    }

    public DefaultInheritedConfiguration(InheritedConfiguration parent, Map<String, String> values, Set<String> fixedForChildren) {
        if (parent == null) {
            ArgChecks.checkForNulls(values, "values");
        } else {
            this.parent = parent;
        }
        if (fixedForChildren != null) {
            ArgChecks.checkForNulls(fixedForChildren, "fixedForChildren");
        }
        this.setValues(values);
        this.setFixedForChildren(fixedForChildren);
    }

    public DefaultInheritedConfiguration(InheritedConfiguration parent, String originID, InheritedConfiguration template) {
        this.parent = parent;
        this.originID = originID;
        HashMap<String, String> values = null;
        HashSet<String> fixed = null;
        if (template != null) {
            values = new HashMap<String, String>();
            fixed = new HashSet<String>();
            for (String entryName : template.getAllEntries()) {
                if (!template.isInherited(entryName)) {
                    values.put(entryName, template.getString(entryName));
                }
                if (!template.isFixedForChildren(entryName) || template.isFixedForChildrenInherited(entryName)) continue;
                fixed.add(entryName);
            }
        }
        this.setValues(values);
        this.setFixedForChildren(fixed);
    }

    @Override
    public String getConfigurationID(String entryName) {
        ArgChecks.checkForNull(entryName, "entryName");
        if (this.isInherited(entryName) && this.parent != null) {
            return this.parent.getConfigurationID(entryName);
        }
        return this.originID;
    }

    @Override
    public Boolean getBoolean(String entryName) {
        ArgChecks.checkForNull(entryName, "entryName");
        Boolean value = null;
        if (this.values.containsKey(entryName)) {
            String valueString = this.values.get(entryName);
            value = ConfigurationTools.parseBoolean(valueString);
        } else if (this.parent != null) {
            value = this.parent.getBoolean(entryName);
        }
        return value;
    }

    @Override
    public void setBoolean(String entryName, boolean value) {
        ArgChecks.checkForNull(entryName, "entryName");
        this.setString(entryName, ConfigurationTools.toString(value));
    }

    @Override
    public Long getInteger(String entryName) {
        ArgChecks.checkForNull(entryName, "entryName");
        Long value = null;
        if (this.values.containsKey(entryName)) {
            String valueString = this.values.get(entryName);
            value = ConfigurationTools.parseInteger(valueString);
        } else if (this.parent != null) {
            value = this.parent.getInteger(entryName);
        }
        return value;
    }

    @Override
    public void setInteger(String entryName, long value) {
        ArgChecks.checkForNull(entryName, "entryName");
        this.setString(entryName, ConfigurationTools.toString(value));
    }

    @Override
    public Double getFloat(String entryName) {
        ArgChecks.checkForNull(entryName, "entryName");
        Double value = null;
        if (this.values.containsKey(entryName)) {
            String valueString = this.values.get(entryName);
            value = ConfigurationTools.parseFloat(valueString);
        } else if (this.parent != null) {
            value = this.parent.getFloat(entryName);
        }
        return value;
    }

    @Override
    public void setFloat(String entryName, double value) {
        ArgChecks.checkForNull(entryName, "entryName");
        this.setString(entryName, ConfigurationTools.toString(value));
    }

    @Override
    public String getString(String entryName) {
        ArgChecks.checkForNull(entryName, "entryName");
        String value = null;
        if (this.values.containsKey(entryName)) {
            value = this.values.get(entryName);
        } else if (this.parent != null) {
            value = this.parent.getString(entryName);
        }
        return value;
    }

    @Override
    public void setString(String entryName, String value) {
        ArgChecks.checkForNull(entryName, "entryName");
        ArgChecks.checkForNull(value, "value");
        this.values.put(entryName, value);
    }

    @Override
    public URI getURI(String entryName) {
        ArgChecks.checkForNull(entryName, "entryName");
        URI value = null;
        if (this.values.containsKey(entryName)) {
            String valueString = this.values.get(entryName);
            value = ConfigurationTools.parseURI(valueString);
        } else if (this.parent != null) {
            value = this.parent.getURI(entryName);
        }
        return value;
    }

    @Override
    public void setURI(String entryName, URI value) {
        ArgChecks.checkForNull(entryName, "entryName");
        ArgChecks.checkForNull(value, "value");
        this.setString(entryName, ConfigurationTools.toString(value));
    }

    @Override
    public Date getDate(String entryName) {
        ArgChecks.checkForNull(entryName, "entryName");
        Date value = null;
        if (this.values.containsKey(entryName)) {
            String valueString = this.values.get(entryName);
            value = ConfigurationTools.parseDate(valueString);
        } else if (this.parent != null) {
            value = this.parent.getDate(entryName);
        }
        return value;
    }

    @Override
    public void setDate(String entryName, Date value) {
        ArgChecks.checkForNull(entryName, "entryName");
        ArgChecks.checkForNull(value, "value");
        this.setString(entryName, ConfigurationTools.toString(value));
    }

    @Override
    public byte[] getUDT(String entryName) {
        ArgChecks.checkForNull(entryName, "entryName");
        byte[] value = null;
        if (this.values.containsKey(entryName)) {
            String valueString = this.values.get(entryName);
            value = ConfigurationTools.parseUDT(valueString);
        } else if (this.parent != null) {
            value = this.parent.getUDT(entryName);
        }
        return value;
    }

    @Override
    public void setUDT(String entryName, byte[] value) {
        ArgChecks.checkForNull(entryName, "entryName");
        ArgChecks.checkForNull(value, "value");
        this.setString(entryName, ConfigurationTools.toString(value));
    }

    @Override
    public void remove(String entryName) {
        ArgChecks.checkForNull(entryName, "entryName");
        this.values.remove(entryName);
    }

    @Override
    public Set<String> getAllEntries() {
        if (this.parent != null) {
            HashSet<String> entryNames = new HashSet<String>(this.parent.getAllEntries());
            entryNames.addAll(this.values.keySet());
            return entryNames;
        }
        return new HashSet<String>(this.values.keySet());
    }

    @Override
    public boolean isInherited(String entryName) {
        ArgChecks.checkForNull(entryName, "entryName");
        return !this.values.containsKey(entryName);
    }

    @Override
    public boolean isOverriding(String entryName) {
        ArgChecks.checkForNull(entryName, "entryName");
        return this.parent != null && !this.isInherited(entryName) && this.parent.getString(entryName) != null;
    }

    @Override
    public void removeInheritedValue(String entryName) {
        ArgChecks.checkForNull(entryName, "entryName");
        if (this.parent == null || this.parent.getString(entryName) == null) {
            return;
        }
        if (this.isFixed(entryName)) {
            String msg = "The configuration entry '%s' is fixed!";
            msg = String.format(msg, entryName);
            throw new IllegalStateException(msg);
        }
        this.values.put(entryName, null);
    }

    @Override
    public boolean isFixed(String entryName) {
        ArgChecks.checkForNull(entryName, "entryName");
        if (this.parent == null) {
            return false;
        }
        return this.parent.isFixedForChildren(entryName);
    }

    @Override
    public boolean isFixedForChildren(String entryName) {
        ArgChecks.checkForNull(entryName, "entryName");
        return this.isFixed(entryName) || this.fixedForChildren.contains(entryName);
    }

    @Override
    public boolean isFixedForChildrenInherited(String entryName) {
        ArgChecks.checkForNull(entryName, "entryName");
        if (this.isFixed(entryName)) {
            return true;
        }
        return !this.fixedForChildren.contains(entryName);
    }

    @Override
    public void setFixedForChildren(String entryName) {
        ArgChecks.checkForNull(entryName, "entryName");
        if (this.parent != null && this.parent.isFixedForChildren(entryName)) {
            return;
        }
        this.fixedForChildren.add(entryName);
    }

    @Override
    public void removeFixedForChildren(String entryName) {
        ArgChecks.checkForNull(entryName, "entryName");
        this.fixedForChildren.remove(entryName);
    }

    protected void setValues(Map<String, String> values) {
        if (values == null) {
            this.values = new HashMap();
        } else {
            ArgChecks.checkForNullKey(values, "values");
            this.values = new HashMap<String, String>(values);
        }
    }

    protected void setFixedForChildren(Set<String> fixed) {
        if (fixed == null) {
            this.fixedForChildren = new HashSet();
        } else {
            ArgChecks.checkForNulls(fixed, "fixed");
            this.fixedForChildren = new HashSet<String>(fixed);
        }
    }
}

