/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.activitymodel.defaultimplementation;

import de.aristaflow.adept2.model.activitymodel.InheritedConfigurationDescription;
import de.aristaflow.adept2.model.common.ConfigurationDescription;
import de.aristaflow.adept2.model.common.defaultimplementation.DefaultChangeableConfigurationDescription;
import de.aristaflow.adept2.util.ArgChecks;
import java.util.HashMap;
import java.util.Map;

public class DefaultInheritedConfigurationDescription
extends DefaultChangeableConfigurationDescription
implements InheritedConfigurationDescription {
    private static final long serialVersionUID = -2287848569316281085L;
    protected final InheritedConfigurationDescription parent;

    public DefaultInheritedConfigurationDescription() {
        this.parent = null;
    }

    public DefaultInheritedConfigurationDescription(InheritedConfigurationDescription parent, Map<String, ConfigurationDescription.ConfigurationEntry> entries) {
        super(entries);
        this.parent = parent;
    }

    public DefaultInheritedConfigurationDescription(InheritedConfigurationDescription parent, InheritedConfigurationDescription template) {
        this.parent = parent;
        HashMap<String, ConfigurationDescription.ConfigurationEntry> entries = null;
        if (template != null) {
            entries = new HashMap<String, ConfigurationDescription.ConfigurationEntry>();
            for (String entryName : template.getEntries().keySet()) {
                if (template.isEntryInherited(entryName)) continue;
                entries.put(entryName, template.getEntry(entryName));
            }
        }
        this.setEntries(entries);
    }

    public DefaultInheritedConfigurationDescription(InheritedConfigurationDescription parent, ConfigurationDescription template) {
        super(template);
        this.parent = parent;
    }

    @Override
    public ConfigurationDescription.ConfigurationEntry getEntry(String entryName) {
        if (this.parent != null && this.isEntryInherited(entryName)) {
            return this.parent.getEntry(entryName);
        }
        return super.getEntry(entryName);
    }

    @Override
    public void setEntry(ConfigurationDescription.ConfigurationEntry entry) {
        ArgChecks.checkForNull(entry, "entry");
        if (this.parent != null && this.parent.getEntry(entry.getName()) != null) {
            this.overrideEntry(entry);
        } else {
            super.setEntry(entry);
        }
    }

    @Override
    public Map<String, ConfigurationDescription.ConfigurationEntry> getEntries() {
        if (this.parent != null) {
            HashMap<String, ConfigurationDescription.ConfigurationEntry> entries = new HashMap<String, ConfigurationDescription.ConfigurationEntry>(this.parent.getEntries());
            entries.putAll(this.entries);
            return entries;
        }
        return new HashMap<String, ConfigurationDescription.ConfigurationEntry>(this.entries);
    }

    @Override
    public boolean isEntryInherited(String entryName) {
        ArgChecks.checkForEmpty(entryName, "entryName");
        return !this.entries.containsKey(entryName);
    }

    @Override
    public boolean isOverridingEntry(String entryName) {
        ArgChecks.checkForNull(entryName, "entryName");
        return this.parent != null && !this.isEntryInherited(entryName) && this.parent.getEntry(entryName) != null;
    }

    @Override
    public void overrideEntry(ConfigurationDescription.ConfigurationEntry entry) {
        ArgChecks.checkForNull(entry, "entry");
        ConfigurationDescription.ConfigurationEntry oldEntry = null;
        if (this.parent != null) {
            oldEntry = this.parent.getEntry(entry.getName());
        }
        if (oldEntry == null) {
            String msg = "can't override entries that don't exist: " + entry.getName();
            throw new IllegalArgumentException(msg);
        }
        if (entry.getDataType() != oldEntry.getDataType()) {
            String msg = "the data type cannot be overridden!";
            throw new IllegalArgumentException(msg);
        }
        if (!oldEntry.isOptional() && entry.isOptional()) {
            String msg = "mandatory entries cannot be made optional when overriding!";
            throw new IllegalArgumentException(msg);
        }
        this.entries.put(entry.getName(), entry);
    }

    @Override
    public void removeInheritedEntry(String entryName) {
        ArgChecks.checkForNull(entryName, "entryName");
        this.entries.put(entryName, null);
    }
}

