/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.activitymodel.defaultimplementation;

import de.aristaflow.adept2.model.activitymodel.ActivityModelParameter;
import de.aristaflow.adept2.model.activitymodel.ExecutableComponentDescription;
import de.aristaflow.adept2.model.activitymodel.InheritedActivityConfiguration;
import de.aristaflow.adept2.model.activitymodel.InheritedCollection;
import de.aristaflow.adept2.model.activitymodel.InheritedConfiguration;
import de.aristaflow.adept2.model.activitymodel.InheritedConfigurationDescription;
import de.aristaflow.adept2.model.activitymodel.Operation;
import de.aristaflow.adept2.model.activitymodel.ParameterTemplate;
import de.aristaflow.adept2.model.activitymodel.StorageOperation;
import de.aristaflow.adept2.model.activitymodel.defaultimplementation.ActivityModelImpl;
import de.aristaflow.adept2.model.activitymodel.defaultimplementation.DefaultInheritedActivityConfiguration;
import de.aristaflow.adept2.model.activitymodel.defaultimplementation.DefaultInheritedConfigurationDescription;
import de.aristaflow.adept2.model.activitymodel.defaultimplementation.DefaultStorageOperation;
import de.aristaflow.adept2.model.activitymodel.defaultimplementation.InheritedParameterCollection;
import de.aristaflow.adept2.model.activitymodel.defaultimplementation.InheritedParameterTemplateCollection;
import de.aristaflow.adept2.model.common.ExecutionControlProperties;
import de.aristaflow.adept2.model.common.ParameterChangePolicy;
import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.model.common.State;
import de.aristaflow.adept2.model.common.defaultimplementation.SerialisablePluginDataContainer;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.util.ArgChecks;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class DefaultOperation
extends SerialisablePluginDataContainer
implements Operation {
    private static final long serialVersionUID = 2966594216653647872L;
    protected ExecutableComponentDescription executableComponentDescription;
    protected String name;
    protected String description;
    protected String developerDescription;
    protected long revision;
    protected State state;
    protected String implementationClass;
    protected ArrayList<String> classPath;
    protected Boolean isSingleton;
    protected byte[] systemComponentSignature = new byte[0];
    protected String guiContextID;
    protected ExecutionControlProperties executionControlProperties;
    protected boolean supportsViewOnly;
    protected boolean supportsTestExecution;
    protected UUID iconID;
    protected String licenceInformation;
    protected InheritedConfigurationDescription configurationDescription;
    protected InheritedActivityConfiguration configuration;
    protected InheritedActivityConfiguration testConfiguration;
    protected ParameterChangePolicy parameterChangePolicy;
    protected HashMap<ActivityConstants.AccessType, InheritedCollection<String, ActivityModelParameter>> parameters;
    protected InheritedCollection<String, ParameterTemplate> parameterTemplates;
    protected String staffAssignmentRule;

    public DefaultOperation(ExecutableComponentDescription executableComponentDescription, String name, String description, String developerDescription, long revision, State state, String implementationClass, List<String> classPath, Boolean isSingleton, byte[] systemComponentSignature, String guiContextID, ExecutionControlProperties executionControlProperties, boolean supportViewOnly, boolean supportsTestExecution, UUID iconID, String licenceInformation, InheritedConfigurationDescription configurationDescription, InheritedActivityConfiguration configuration, InheritedActivityConfiguration testConfiguration, ParameterChangePolicy parameterChangePolicy, Collection<ActivityModelParameter> inputParameters, Collection<ActivityModelParameter> outputParameters, Collection<ParameterTemplate> parameterTemplates, String staffAssignmentRule, PluginDataContainer pluginData, Map<String, String> userAttributes) {
        super(pluginData, userAttributes);
        ArgChecks.checkForNull(executableComponentDescription, "executableComponentDescription");
        ArgChecks.checkForNegative(revision, "revision");
        ArgChecks.checkForNull((Object)state, "state");
        this.executableComponentDescription = executableComponentDescription;
        this.setName(name);
        this.setDescription(description);
        if (developerDescription == null) {
            this.removeOwnDeveloperDescription();
        } else {
            this.setDeveloperDescription(developerDescription);
        }
        this.revision = revision;
        this.state = state;
        if (implementationClass == null) {
            this.removeOwnImplementationClass();
        } else {
            this.setImplementationClass(implementationClass);
        }
        this.setClassPath(classPath);
        if (isSingleton == null) {
            this.removeOwnSingleton();
        } else {
            this.setSingleton(isSingleton);
        }
        if (systemComponentSignature == null) {
            this.removeOwnSystemComponent();
        } else if (systemComponentSignature.length == 0) {
            this.setSystemComponent(null);
        } else {
            this.setSystemComponent(systemComponentSignature);
        }
        if (guiContextID == null) {
            this.removeOwnGUIContextID();
        } else {
            this.setGUIContextID(guiContextID);
        }
        if (executionControlProperties == null) {
            this.removeOwnExecutionControlProperties();
        } else {
            this.setExecutionControlProperties(executionControlProperties);
        }
        this.setSupportsViewOnly(supportViewOnly);
        this.setSupportsTestExecutionOnly(supportsTestExecution);
        if (iconID == null) {
            this.removeOwnIconID();
        } else {
            this.setIconID(iconID);
        }
        if (licenceInformation == null) {
            this.removeOwnLicenceInformation();
        } else {
            this.setLicenceInformation(licenceInformation);
        }
        this.setConfigurationDescription(configurationDescription);
        this.setConfiguration(configuration);
        this.setTestConfiguration(testConfiguration);
        this.setParameterChangePolicy(parameterChangePolicy);
        this.parameters = new HashMap(2);
        this.parameters.put(ActivityConstants.AccessType.READ, new InheritedParameterCollection(null, null, inputParameters));
        this.parameters.put(ActivityConstants.AccessType.WRITE, new InheritedParameterCollection(null, null, outputParameters));
        this.parameterTemplates = new InheritedParameterTemplateCollection(null, null, parameterTemplates);
        this.setStaffAssignmentRule(staffAssignmentRule);
    }

    @Override
    public ExecutableComponentDescription getExecutableComponentDescription() {
        return this.executableComponentDescription;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        ArgChecks.checkForEmpty(name, "name");
        ActivityModelImpl.checkName(name);
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        ArgChecks.checkForNull(description, "description");
        this.description = description;
    }

    @Override
    public String getDeveloperDescription() {
        if (this.isDeveloperDescriptionInherited()) {
            return this.executableComponentDescription.getDeveloperDescription();
        }
        return this.developerDescription;
    }

    @Override
    public void setDeveloperDescription(String developerDescription) {
        ArgChecks.checkForNull(developerDescription, "developerDescription");
        this.developerDescription = developerDescription;
    }

    @Override
    public boolean isDeveloperDescriptionInherited() {
        return this.developerDescription == null;
    }

    @Override
    public void removeOwnDeveloperDescription() {
        this.developerDescription = null;
    }

    @Override
    public long getRevision() {
        return this.revision;
    }

    @Override
    public State getState() {
        return this.state;
    }

    @Override
    public String getImplementationClass() {
        if (this.isImplementationClassInherited()) {
            return this.executableComponentDescription.getImplementationClass();
        }
        return this.implementationClass;
    }

    @Override
    public void setImplementationClass(String implementationClass) {
        ArgChecks.checkForNull(implementationClass, implementationClass);
        this.implementationClass = implementationClass;
    }

    @Override
    public boolean isImplementationClassInherited() {
        return this.implementationClass == null;
    }

    @Override
    public void removeOwnImplementationClass() {
        this.implementationClass = null;
    }

    @Override
    public List<String> getClassPath() {
        List<String> result = this.executableComponentDescription.getClassPath();
        result.addAll(0, this.classPath);
        return result;
    }

    @Override
    public List<String> getOwnClassPath() {
        return new ArrayList<String>(this.classPath);
    }

    @Override
    public void setClassPath(List<String> classPath) {
        if (classPath == null) {
            this.classPath = new ArrayList();
        } else {
            ArgChecks.checkForNulls(classPath, "classPath");
            List<String> parentClassPath = this.executableComponentDescription.getClassPath();
            int expectedIndex = classPath.size() - parentClassPath.size();
            int index = Collections.lastIndexOfSubList(classPath, parentClassPath);
            this.classPath = parentClassPath.size() == 0 || expectedIndex < 0 || index != expectedIndex ? new ArrayList<String>(classPath) : new ArrayList<String>(classPath.subList(index, classPath.size()));
        }
    }

    @Override
    public boolean isSingleton() {
        if (this.isSingletonInherited()) {
            return this.executableComponentDescription.isSingleton();
        }
        return this.isSingleton == null ? false : this.isSingleton;
    }

    @Override
    public void setSingleton(boolean singleton) {
        this.isSingleton = singleton;
    }

    @Override
    public boolean isSingletonInherited() {
        return this.isSingleton == null;
    }

    @Override
    public void removeOwnSingleton() {
        this.isSingleton = null;
    }

    @Override
    public byte[] getSystemComponent() {
        if (this.isSystemComponentInherited()) {
            return this.executableComponentDescription.getSystemComponent();
        }
        if (this.systemComponentSignature.length == 0) {
            return null;
        }
        return (byte[])this.systemComponentSignature.clone();
    }

    @Override
    public void setSystemComponent(byte[] signature) {
        if (signature == null) {
            this.systemComponentSignature = new byte[0];
        } else {
            ArgChecks.checkForEmpty(signature, "signature");
            this.systemComponentSignature = (byte[])signature.clone();
        }
    }

    @Override
    public boolean isSystemComponentInherited() {
        return this.systemComponentSignature == null;
    }

    @Override
    public void removeOwnSystemComponent() {
        this.systemComponentSignature = null;
    }

    @Override
    public String getGUIContextID() {
        if (this.isGUIContextIDInherited()) {
            return this.executableComponentDescription.getGUIContextID();
        }
        return this.guiContextID;
    }

    @Override
    public void setGUIContextID(String guiContextID) {
        ArgChecks.checkForEmpty(guiContextID, "guiContextID");
        this.guiContextID = guiContextID;
    }

    @Override
    public boolean isGUIContextIDInherited() {
        return this.guiContextID == null;
    }

    @Override
    public void removeOwnGUIContextID() {
        this.guiContextID = null;
    }

    @Override
    public ExecutionControlProperties getExecutionControlProperties() {
        if (this.areExecutionControlPropertiesInterhited()) {
            return this.executableComponentDescription.getExecutionControlProperties();
        }
        return this.executionControlProperties;
    }

    @Override
    public void setExecutionControlProperties(ExecutionControlProperties executionControlProperties) {
        ArgChecks.checkForNull(executionControlProperties, "ecp");
        this.executionControlProperties = executionControlProperties;
    }

    @Override
    public boolean areExecutionControlPropertiesInterhited() {
        return this.executionControlProperties == null;
    }

    @Override
    public void removeOwnExecutionControlProperties() {
        this.executionControlProperties = null;
    }

    @Override
    public boolean supportsViewOnly() {
        return this.supportsViewOnly;
    }

    @Override
    public void setSupportsViewOnly(boolean supportsViewOnly) {
        this.supportsViewOnly = supportsViewOnly;
    }

    @Override
    public boolean supportsTestExecution() {
        return this.supportsTestExecution;
    }

    @Override
    public void setSupportsTestExecutionOnly(boolean supportsTestExecution) {
        this.supportsTestExecution = supportsTestExecution;
    }

    @Override
    public UUID getIconID() {
        if (this.isIconIDInherited()) {
            return this.executableComponentDescription.getIconID();
        }
        return this.iconID;
    }

    @Override
    public void setIconID(UUID iconID) {
        ArgChecks.checkForNull(iconID, "iconID");
        this.iconID = iconID;
    }

    @Override
    public boolean isIconIDInherited() {
        return this.iconID == null;
    }

    @Override
    public void removeOwnIconID() {
        this.iconID = null;
    }

    @Override
    public String getLicenceInformation() {
        if (this.isLicenceInformationInherited()) {
            return this.executableComponentDescription.getLicenceInformation();
        }
        return this.licenceInformation;
    }

    @Override
    public void setLicenceInformation(String licenceInformation) {
        ArgChecks.checkForNull(licenceInformation, "licenceInformation");
        this.licenceInformation = licenceInformation;
    }

    @Override
    public boolean isLicenceInformationInherited() {
        return this.licenceInformation == null;
    }

    @Override
    public void removeOwnLicenceInformation() {
        this.licenceInformation = null;
    }

    @Override
    public InheritedConfigurationDescription getConfigurationDescription() {
        return new DefaultInheritedConfigurationDescription(this.executableComponentDescription.getConfigurationDescription(), this.configurationDescription);
    }

    @Override
    public void setConfigurationDescription(InheritedConfigurationDescription description) {
        this.configurationDescription = new DefaultInheritedConfigurationDescription(null, description);
    }

    @Override
    public InheritedActivityConfiguration getConfiguration() {
        return new DefaultInheritedActivityConfiguration(null, "Operation", this.configuration);
    }

    @Override
    public void setConfiguration(InheritedActivityConfiguration configuration) {
        this.configuration = new DefaultInheritedActivityConfiguration(null, null, configuration);
    }

    @Override
    public InheritedActivityConfiguration getTestConfiguration() {
        return new DefaultInheritedActivityConfiguration((InheritedConfiguration)this.getConfiguration(), "Test of Operation", this.testConfiguration);
    }

    @Override
    public void setTestConfiguration(InheritedActivityConfiguration testConfiguration) {
        this.testConfiguration = new DefaultInheritedActivityConfiguration(null, null, testConfiguration);
    }

    @Override
    public ParameterChangePolicy getParameterChangePolicy() {
        return this.parameterChangePolicy;
    }

    @Override
    public void setParameterChangePolicy(ParameterChangePolicy pcp) {
        ArgChecks.checkForNull((Object)pcp, "pcp");
        this.parameterChangePolicy = pcp;
    }

    @Override
    public InheritedCollection<String, ActivityModelParameter> getParameters(ActivityConstants.AccessType accessType) {
        ArgChecks.checkEnum((Object)accessType, "accessType", new Object[]{ActivityConstants.AccessType.READ, ActivityConstants.AccessType.WRITE});
        return new InheritedParameterCollection(null, "Parameter of Operation", this.parameters.get((Object)accessType));
    }

    @Override
    public void setParameters(ActivityConstants.AccessType accessType, InheritedCollection<String, ActivityModelParameter> parameters) {
        ArgChecks.checkEnum((Object)accessType, "accessType", new Object[]{ActivityConstants.AccessType.READ, ActivityConstants.AccessType.WRITE});
        this.parameters.put(accessType, new InheritedParameterCollection(null, null, parameters));
    }

    @Override
    public InheritedCollection<String, ParameterTemplate> getParameterTemplates() {
        InheritedCollection<String, ParameterTemplate> parent = this.executableComponentDescription.getParameterTemplates();
        return new InheritedParameterTemplateCollection(parent, "ParameterTemplate of Operation", this.parameterTemplates);
    }

    @Override
    public void setParameterTemplates(InheritedCollection<String, ParameterTemplate> parameterTemplates) {
        this.parameterTemplates = new InheritedParameterTemplateCollection(null, null, parameterTemplates);
    }

    @Override
    public String getStaffAssignmentRule() {
        return this.staffAssignmentRule;
    }

    @Override
    public void setStaffAssignmentRule(String staffAssignmentRule) {
        ArgChecks.checkForNull(staffAssignmentRule, "staffAssignmentRule");
        this.staffAssignmentRule = staffAssignmentRule;
    }

    @Override
    public StorageOperation getStorageOperation() {
        String ecName = this.getExecutableComponentDescription().getName();
        return new DefaultStorageOperation(ecName, this.name, this.description, this.developerDescription, this.revision, this.state, this.implementationClass, this.classPath, this.isSingleton, this.systemComponentSignature, this.guiContextID, this.executionControlProperties, this.supportsViewOnly, this.supportsTestExecution, this.iconID, this.licenceInformation, ActivityModelImpl.convert(this.configurationDescription), ActivityModelImpl.convert(this.configuration), ActivityModelImpl.convert(this.testConfiguration), this.parameterChangePolicy, ActivityModelImpl.convertParameters(this.parameters.get((Object)ActivityConstants.AccessType.READ).getAllOwn()).values(), ActivityModelImpl.convertParameters(this.parameters.get((Object)ActivityConstants.AccessType.WRITE).getAllOwn()).values(), ActivityModelImpl.convertParameterTemplates(this.parameterTemplates.getAllOwn()), this.staffAssignmentRule, this, this.getUserAttributes());
    }
}

