/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.activitymodel.defaultimplementation;

import de.aristaflow.adept2.model.activitymodel.OperationReference;
import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.model.common.State;
import de.aristaflow.adept2.model.common.defaultimplementation.SerialisablePluginDataContainer;
import de.aristaflow.adept2.util.ArgChecks;
import java.util.Map;
import java.util.UUID;

public class DefaultOperationReference
extends SerialisablePluginDataContainer
implements OperationReference {
    private static final long serialVersionUID = 3781056131317413962L;
    protected String executableComponentName;
    protected String name;
    protected String description;
    protected String developerDescription;
    protected long revision;
    protected State state;
    protected UUID iconID;

    public DefaultOperationReference(String executableComponentName, String name, String description, String developerDescription, long revision, State state, UUID iconID, PluginDataContainer pluginData, Map<String, String> userAttributes) {
        super(pluginData, userAttributes);
        ArgChecks.checkForNull(executableComponentName, "executableComponentName");
        ArgChecks.checkForNull(name, "name");
        ArgChecks.checkForNull(description, "description");
        ArgChecks.checkForNull(developerDescription, "developerDescription");
        ArgChecks.checkForNegative(revision, "revision");
        ArgChecks.checkForNull((Object)state, "state");
        this.executableComponentName = executableComponentName;
        this.name = name;
        this.description = description;
        this.developerDescription = developerDescription;
        this.revision = revision;
        this.state = state;
        this.iconID = iconID;
    }

    @Override
    public String getExecutableComponentName() {
        return this.executableComponentName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getDeveloperDescription() {
        return this.developerDescription;
    }

    @Override
    public long getRevision() {
        return this.revision;
    }

    @Override
    public State getState() {
        return this.state;
    }

    @Override
    public UUID getIconID() {
        return this.iconID;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof OperationReference)) {
            return false;
        }
        OperationReference otherOperationRef = (OperationReference)obj;
        return this.getExecutableComponentName().equals(otherOperationRef.getExecutableComponentName()) && this.getName().equals(otherOperationRef.getName());
    }

    public int hashCode() {
        return this.getExecutableComponentName().hashCode() * 31 + this.getName().hashCode();
    }
}

