/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.activitymodel.defaultimplementation;

import de.aristaflow.adept2.model.activitymodel.InheritedConfiguration;
import de.aristaflow.adept2.model.activitymodel.InheritedConfigurationDescription;
import de.aristaflow.adept2.model.activitymodel.ParameterTemplate;
import de.aristaflow.adept2.model.activitymodel.defaultimplementation.AbstractParameterTemplate;
import de.aristaflow.adept2.model.activitymodel.defaultimplementation.DefaultInheritedConfiguration;
import de.aristaflow.adept2.model.activitymodel.defaultimplementation.DefaultInheritedConfigurationDescription;
import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.util.ArgChecks;
import java.util.Map;
import java.util.UUID;

public class DefaultParameterTemplate
extends AbstractParameterTemplate
implements ParameterTemplate {
    private static final long serialVersionUID = -3079414081026266100L;
    protected ParameterTemplate parent;
    protected String originID;
    protected InheritedConfigurationDescription configurationDescription;
    protected InheritedConfiguration configuration;

    public DefaultParameterTemplate(ParameterTemplate parent, String templateName, String templateDescription, ActivityConstants.AccessType accessType, String name, String description, ProcessConstants.AdeptDataType dataType, String udtName, UUID identifierID, Boolean isOptional, Boolean isVirtual, Boolean isFailure, String defaultValue, InheritedConfigurationDescription configurationDescription, InheritedConfiguration configuration, PluginDataContainer pluginData, Map<String, String> userAttributes) {
        super(pluginData, userAttributes);
        this.parent = parent;
        this.setTemplateName(templateName);
        if (templateDescription != null) {
            this.setTemplateDescription(templateDescription);
        }
        if (accessType != null) {
            this.setAccessType(accessType);
        }
        if (name != null) {
            this.setName(name);
        }
        if (description != null) {
            this.setDescription(description);
        }
        if (dataType != null) {
            this.setDataType(dataType, udtName);
        }
        if (identifierID != null) {
            this.setIdentifierID(identifierID);
        }
        if (isOptional != null) {
            this.setOptional(isOptional);
        }
        if (isVirtual != null) {
            this.setVirtual(isVirtual);
        }
        if (isFailure != null) {
            this.setFailure(isFailure);
        }
        if (defaultValue != null) {
            this.setDefaultValue(defaultValue);
        }
        this.setConfigurationDescription(configurationDescription);
        this.setConfiguration(configuration);
    }

    public DefaultParameterTemplate(ParameterTemplate parent, ParameterTemplate template) {
        super(template, template.getUserAttributes());
        this.parent = parent;
        this.setTemplateName(template.getTemplateName());
        if (!template.isTemplateDescriptionInherited()) {
            this.setTemplateDescription(template.getTemplateDescription());
        }
        if (!template.isAccessTypeInherited()) {
            this.setAccessType(template.getAccessType());
        }
        if (!template.isNameInherited()) {
            this.setName(template.getName());
        }
        if (!template.isDescriptionInherited()) {
            this.setDescription(template.getDescription());
        }
        if (!template.isDataTypeInherited()) {
            this.setDataType(template.getDataType(), template.getUDTName());
        }
        if (!template.isIdentifierIDInherited()) {
            this.setIdentifierID(template.getIdentifierID());
        }
        if (!template.isOptionalInherited()) {
            this.setOptional(template.isOptional());
        }
        if (!template.isVirtualInherited()) {
            this.setVirtual(template.isVirtual());
        }
        if (!template.isFailureInherited()) {
            this.setFailure(template.isFailure());
        }
        if (!template.isDefaultValueInherited()) {
            this.setDefaultValue(template.getDefaultValue());
        }
        this.setConfigurationDescription(template.getConfigurationDescription());
        this.setConfiguration(template.getConfiguration());
    }

    public DefaultParameterTemplate(ParameterTemplate parent, String originID, ParameterTemplate template) {
        this(parent, template);
        this.originID = originID;
    }

    @Override
    public void setTemplateName(String templateName) {
        ArgChecks.checkForEmpty(templateName, "templateName");
        if (this.parent != null && !this.parent.getTemplateName().equals(templateName)) {
            String msg = "This template's name must be the same as its parent's!";
            throw new IllegalArgumentException(msg);
        }
        super.setTemplateName(templateName);
    }

    @Override
    public String getTemplateDescription() {
        if (this.parent != null && this.isTemplateDescriptionInherited()) {
            return this.parent.getTemplateDescription();
        }
        return this.templateDescription;
    }

    @Override
    public void setTemplateDescription(String templateDescription) {
        this.templateDescription = templateDescription;
    }

    @Override
    public ActivityConstants.AccessType getAccessType() {
        if (this.parent != null && this.isAccessTypeInherited()) {
            return this.parent.getAccessType();
        }
        return this.accessType;
    }

    @Override
    public void setAccessType(ActivityConstants.AccessType accessType) {
        this.accessType = accessType;
    }

    @Override
    public String getName() {
        if (this.parent != null && this.isNameInherited()) {
            return this.parent.getName();
        }
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        if (this.parent != null && this.isDescriptionInherited()) {
            return this.parent.getDescription();
        }
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public ProcessConstants.AdeptDataType getDataType() {
        if (this.parent != null && this.isDataTypeInherited()) {
            return this.parent.getDataType();
        }
        return this.dataType;
    }

    @Override
    public String getUDTName() {
        if (this.parent != null && this.isDataTypeInherited()) {
            return this.parent.getUDTName();
        }
        return this.udtName;
    }

    @Override
    public void setDataType(ProcessConstants.AdeptDataType dataType, String udtName) {
        if ("".equals(udtName)) {
            udtName = null;
        }
        if (dataType == ProcessConstants.AdeptDataType.USERDEFINED) {
            this.dataType = dataType;
            this.udtName = udtName;
        } else if (dataType != null) {
            if (udtName != null) {
                throw new IllegalArgumentException("UDT name must be null for anything else than USERDEFINED");
            }
            this.dataType = dataType;
            this.udtName = null;
        } else {
            this.dataType = null;
            this.udtName = null;
        }
    }

    @Override
    public UUID getIdentifierID() {
        if (this.parent != null && this.isIdentifierIDInherited()) {
            return this.parent.getIdentifierID();
        }
        return this.identifierID;
    }

    @Override
    public void setIdentifierID(UUID identifierID) {
        this.identifierID = identifierID;
    }

    @Override
    public Boolean isOptional() {
        if (this.parent != null && this.isOptionalInherited()) {
            return this.parent.isOptional();
        }
        return this.isOptional;
    }

    @Override
    public void setOptional(boolean isOptional) {
        this.isOptional = isOptional;
    }

    @Override
    public Boolean isVirtual() {
        if (this.parent != null && this.isVirtualInherited()) {
            return this.parent.isVirtual();
        }
        return this.isVirtual;
    }

    @Override
    public void setVirtual(boolean isVirtual) {
        this.isVirtual = isVirtual;
    }

    @Override
    public Boolean isFailure() {
        if (this.parent != null && this.isFailureInherited()) {
            return this.parent.isFailure();
        }
        return this.isFailure;
    }

    @Override
    public void setFailure(boolean isFailure) {
        this.isFailure = isFailure;
    }

    @Override
    public String getDefaultValue() {
        if (this.parent != null && this.isDefaultValueInherited()) {
            return this.parent.getDefaultValue();
        }
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public InheritedConfigurationDescription getConfigurationDescription() {
        InheritedConfigurationDescription parentDesc = null;
        if (this.parent != null) {
            parentDesc = this.parent.getConfigurationDescription();
        }
        return new DefaultInheritedConfigurationDescription(parentDesc, this.configurationDescription);
    }

    @Override
    public void setConfigurationDescription(InheritedConfigurationDescription configurationDescription) {
        this.configurationDescription = new DefaultInheritedConfigurationDescription(null, configurationDescription);
    }

    @Override
    public InheritedConfiguration getConfiguration() {
        InheritedConfiguration parentConf = null;
        if (this.parent != null) {
            parentConf = this.parent.getConfiguration();
        }
        return new DefaultInheritedConfiguration(parentConf, this.originID, this.configuration);
    }

    @Override
    public void setConfiguration(InheritedConfiguration configuration) {
        this.configuration = new DefaultInheritedConfiguration(null, null, configuration);
    }
}

