/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.activitymodel.defaultimplementation;

import de.aristaflow.adept2.model.activitymodel.StorageActivityConfiguration;
import de.aristaflow.adept2.model.activitymodel.StorageActivityModelParameter;
import de.aristaflow.adept2.model.activitymodel.StorageActivityTemplateDefinition;
import de.aristaflow.adept2.model.activitymodel.StorageConfigurationDescription;
import de.aristaflow.adept2.model.activitymodel.StorageParameterTemplate;
import de.aristaflow.adept2.model.activitymodel.defaultimplementation.ActivityModelImpl;
import de.aristaflow.adept2.model.activitymodel.defaultimplementation.DefaultStorageActivityConfiguration;
import de.aristaflow.adept2.model.activitymodel.defaultimplementation.DefaultStorageConfigurationDescription;
import de.aristaflow.adept2.model.common.ExecutionControlProperties;
import de.aristaflow.adept2.model.common.ParameterChangePolicy;
import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.model.common.State;
import de.aristaflow.adept2.model.common.defaultimplementation.SerialisablePluginDataContainer;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.util.ArgChecks;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class DefaultStorageActivityTemplateDefinition
extends SerialisablePluginDataContainer
implements StorageActivityTemplateDefinition {
    private static final long serialVersionUID = 3693211303127874377L;
    protected String executableComponentName;
    protected String operationName;
    protected String configurationSetName;
    protected UUID id;
    protected String name;
    protected String description;
    protected String developerDescription;
    protected long revision;
    protected State state;
    protected String implementationClass;
    protected ArrayList<String> classPath;
    protected Boolean isSingleton;
    protected byte[] systemComponentSignature;
    protected String guiContextID;
    protected ExecutionControlProperties executionControlProperties;
    protected Boolean supportsViewOnly;
    protected Boolean supportsTestExecution;
    protected UUID iconID;
    protected String licenceInformation;
    protected StorageConfigurationDescription configurationDescription;
    protected StorageActivityConfiguration configuration;
    protected StorageActivityConfiguration testConfiguration;
    protected ParameterChangePolicy parameterChangePolicy;
    protected HashMap<ActivityConstants.AccessType, Map<String, StorageActivityModelParameter>> parameters;
    protected HashMap<String, StorageParameterTemplate> parameterTemplates;
    protected String staffAssignmentRule;

    public DefaultStorageActivityTemplateDefinition(String executableComponentName, String operationName, String configurationSetName, UUID id, String name, String description, String developerDescription, long revision, State state, String implementationClass, List<String> classPath, Boolean isSingleton, byte[] systemComponentSignature, String guiContextID, ExecutionControlProperties executionControlProperties, Boolean supportsViewOnly, Boolean supportsTestExecution, UUID iconID, String licenceInformation, StorageConfigurationDescription configurationDescription, StorageActivityConfiguration configuration, StorageActivityConfiguration testConfiguration, ParameterChangePolicy parameterChangePolicy, Map<String, StorageActivityModelParameter> inputParameters, Map<String, StorageActivityModelParameter> outputParameters, Map<String, StorageParameterTemplate> parameterTemplates, String staffAssignmentRule, PluginDataContainer pluginData, Map<String, String> userAttributes) {
        super(pluginData, userAttributes);
        ArgChecks.checkForNegative(revision, "revision");
        ArgChecks.checkForNull((Object)state, "state");
        this.setExecutableComponentName(executableComponentName);
        this.setOperationName(operationName);
        this.setConfigurationSetName(configurationSetName);
        this.setID(id);
        this.setName(name);
        if (description == null) {
            this.removeOwnDescription();
        } else {
            this.setDescription(description);
        }
        if (developerDescription == null) {
            this.removeOwnDeveloperDescription();
        } else {
            this.setDeveloperDescription(developerDescription);
        }
        this.revision = revision;
        this.state = state;
        if (implementationClass == null) {
            this.removeOwnImplementationClass();
        } else {
            this.setImplementationClass(implementationClass);
        }
        this.setClassPath(classPath);
        if (isSingleton == null) {
            this.removeOwnSingleton();
        } else {
            this.setSingleton(isSingleton);
        }
        if (systemComponentSignature == null) {
            this.removeOwnSystemComponent();
        } else if (systemComponentSignature.length == 0) {
            this.setSystemComponent(null);
        } else {
            this.setSystemComponent(systemComponentSignature);
        }
        if (guiContextID == null) {
            this.removeOwnGUIContextID();
        } else {
            this.setGUIContextID(guiContextID);
        }
        if (executionControlProperties == null) {
            this.removeOwnExecutionControlProperties();
        } else {
            this.setExecutionControlProperties(executionControlProperties);
        }
        if (supportsViewOnly == null) {
            this.removeOwnSupportsViewOnly();
        } else {
            this.setSupportsViewOnly(supportsViewOnly);
        }
        if (supportsTestExecution == null) {
            this.removeOwnSupportsTestExecution();
        } else {
            this.setSupportsTestExecution(supportsTestExecution);
        }
        if (iconID == null) {
            this.removeOwnIconID();
        } else {
            this.setIconID(iconID);
        }
        if (licenceInformation == null) {
            this.removeOwnLicenceInformation();
        } else {
            this.setLicenceInformation(licenceInformation);
        }
        this.setConfigurationDescription(configurationDescription);
        this.setConfiguration(configuration);
        this.setTestConfiguration(testConfiguration);
        if (parameterChangePolicy == null) {
            this.removeOwnParameterChangePolicy();
        } else {
            this.setParameterChangePolicy(parameterChangePolicy);
        }
        this.parameters = new HashMap();
        this.setParameters(ActivityConstants.AccessType.READ, inputParameters);
        this.setParameters(ActivityConstants.AccessType.WRITE, outputParameters);
        this.setParameterTemplates(parameterTemplates);
        if (staffAssignmentRule == null) {
            this.removeOwnStaffAssignmentRule();
        } else {
            this.setStaffAssignmentRule(staffAssignmentRule);
        }
    }

    @Override
    public UUID getID() {
        return this.id;
    }

    @Override
    public void setID(UUID id) {
        ArgChecks.checkForNull(id, "id");
        this.id = id;
    }

    @Override
    public String getExecutableComponentName() {
        return this.executableComponentName;
    }

    protected void setExecutableComponentName(String executableComponentName) {
        ArgChecks.checkForNull(executableComponentName, "executableComponentName");
        this.executableComponentName = executableComponentName;
    }

    @Override
    public String getOperationName() {
        return this.operationName;
    }

    protected void setOperationName(String operationName) {
        ArgChecks.checkForNull(operationName, "operationName");
        this.operationName = operationName;
    }

    @Override
    public String getConfigurationSetName() {
        return this.configurationSetName;
    }

    protected void setConfigurationSetName(String configurationSetName) {
        if (configurationSetName != null) {
            ArgChecks.checkForEmpty(configurationSetName, "configurationSetName");
        }
        this.configurationSetName = configurationSetName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        ArgChecks.checkForEmpty(name, "name");
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        ArgChecks.checkForNull(description, "description");
        this.description = description;
    }

    @Override
    public boolean isDescriptionInherited() {
        return this.description == null;
    }

    @Override
    public void removeOwnDescription() {
        this.description = null;
    }

    @Override
    public String getDeveloperDescription() {
        return this.developerDescription;
    }

    @Override
    public void setDeveloperDescription(String developerDescription) {
        ArgChecks.checkForNull(developerDescription, "developerDescription");
        this.developerDescription = developerDescription;
    }

    @Override
    public boolean isDeveloperDescriptionInherited() {
        return this.developerDescription == null;
    }

    @Override
    public void removeOwnDeveloperDescription() {
        this.developerDescription = null;
    }

    @Override
    public long getRevision() {
        return this.revision;
    }

    @Override
    public State getState() {
        return this.state;
    }

    @Override
    public String getImplementationClass() {
        return this.implementationClass;
    }

    @Override
    public void setImplementationClass(String implementationClass) {
        ArgChecks.checkForNull(implementationClass, implementationClass);
        this.implementationClass = implementationClass;
    }

    @Override
    public boolean isImplementationClassInherited() {
        return this.implementationClass == null;
    }

    @Override
    public void removeOwnImplementationClass() {
        this.implementationClass = null;
    }

    @Override
    public List<String> getClassPath() {
        return new ArrayList<String>(this.classPath);
    }

    @Override
    public void setClassPath(List<String> classPath) {
        if (classPath == null) {
            this.classPath = new ArrayList();
        } else {
            ArgChecks.checkForNulls(classPath, "classPath");
            this.classPath = new ArrayList<String>(classPath);
        }
    }

    @Override
    public boolean isSingleton() {
        return this.isSingleton == null ? false : this.isSingleton;
    }

    @Override
    public void setSingleton(boolean isSingleton) {
        this.isSingleton = isSingleton;
    }

    @Override
    public boolean isSingletonInherited() {
        return this.isSingleton == null;
    }

    @Override
    public void removeOwnSingleton() {
        this.isSingleton = null;
    }

    @Override
    public byte[] getSystemComponent() {
        if (this.isSystemComponentInherited()) {
            return null;
        }
        if (this.systemComponentSignature.length == 0) {
            return null;
        }
        return (byte[])this.systemComponentSignature.clone();
    }

    @Override
    public void setSystemComponent(byte[] signature) {
        if (signature == null) {
            this.systemComponentSignature = new byte[0];
        } else {
            ArgChecks.checkForEmpty(signature, "signature");
            this.systemComponentSignature = (byte[])signature.clone();
        }
    }

    @Override
    public boolean isSystemComponentInherited() {
        return this.systemComponentSignature == null;
    }

    @Override
    public void removeOwnSystemComponent() {
        this.systemComponentSignature = null;
    }

    @Override
    public String getGUIContextID() {
        return this.guiContextID;
    }

    @Override
    public void setGUIContextID(String guiContextID) {
        ArgChecks.checkForEmpty(guiContextID, "guiContextID");
        this.guiContextID = guiContextID;
    }

    @Override
    public boolean isGUIContextIDInherited() {
        return this.guiContextID == null;
    }

    @Override
    public void removeOwnGUIContextID() {
        this.guiContextID = null;
    }

    @Override
    public ExecutionControlProperties getExecutionControlProperties() {
        return this.executionControlProperties;
    }

    @Override
    public void setExecutionControlProperties(ExecutionControlProperties executionControlProperties) {
        ArgChecks.checkForNull(executionControlProperties, "executionControlProperties");
        this.executionControlProperties = executionControlProperties;
    }

    @Override
    public boolean areExecutionControlPropertiesInterited() {
        return this.executionControlProperties == null;
    }

    @Override
    public void removeOwnExecutionControlProperties() {
        this.executionControlProperties = null;
    }

    @Override
    public boolean supportsViewOnly() {
        return this.supportsViewOnly == null ? false : this.supportsViewOnly;
    }

    @Override
    public void setSupportsViewOnly(boolean supportsViewOnly) {
        this.supportsViewOnly = supportsViewOnly;
    }

    @Override
    public boolean isSupportsViewOnlyInherited() {
        return this.supportsViewOnly == null;
    }

    @Override
    public void removeOwnSupportsViewOnly() {
        this.supportsViewOnly = null;
    }

    @Override
    public boolean supportsTestExecution() {
        return this.supportsTestExecution == null ? false : this.supportsTestExecution;
    }

    @Override
    public void setSupportsTestExecution(boolean supportsTestExecution) {
        this.supportsTestExecution = supportsTestExecution;
    }

    @Override
    public boolean isSupportsTestExecutionInherited() {
        return this.supportsTestExecution == null;
    }

    @Override
    public void removeOwnSupportsTestExecution() {
        this.supportsTestExecution = null;
    }

    @Override
    public UUID getIconID() {
        return this.iconID;
    }

    @Override
    public void setIconID(UUID iconID) {
        this.iconID = iconID;
    }

    @Override
    public boolean isIconIDInherited() {
        return this.iconID == null;
    }

    @Override
    public void removeOwnIconID() {
        this.iconID = null;
    }

    @Override
    public String getLicenceInformation() {
        return this.licenceInformation;
    }

    @Override
    public void setLicenceInformation(String licenceInformation) {
        ArgChecks.checkForNull(licenceInformation, "licenceInformation");
        this.licenceInformation = licenceInformation;
    }

    @Override
    public boolean isLicenceInformationInherited() {
        return this.licenceInformation == null;
    }

    @Override
    public void removeOwnLicenceInformation() {
        this.licenceInformation = null;
    }

    @Override
    public StorageConfigurationDescription getConfigurationDescription() {
        return new DefaultStorageConfigurationDescription(this.configurationDescription);
    }

    @Override
    public void setConfigurationDescription(StorageConfigurationDescription configurationDescription) {
        this.configurationDescription = new DefaultStorageConfigurationDescription(configurationDescription);
    }

    @Override
    public StorageActivityConfiguration getConfiguration() {
        return new DefaultStorageActivityConfiguration(this.configuration);
    }

    @Override
    public void setConfiguration(StorageActivityConfiguration configuration) {
        this.configuration = new DefaultStorageActivityConfiguration(configuration);
    }

    @Override
    public StorageActivityConfiguration getTestConfiguration() {
        return new DefaultStorageActivityConfiguration(this.testConfiguration);
    }

    @Override
    public void setTestConfiguration(StorageActivityConfiguration testConfiguration) {
        this.testConfiguration = new DefaultStorageActivityConfiguration(testConfiguration);
    }

    @Override
    public ParameterChangePolicy getParameterChangePolicy() {
        return this.parameterChangePolicy;
    }

    @Override
    public void setParameterChangePolicy(ParameterChangePolicy parameterChangePolicy) {
        ArgChecks.checkForNull((Object)parameterChangePolicy, "parameterChangePolicy");
        this.parameterChangePolicy = parameterChangePolicy;
    }

    @Override
    public boolean isParameterChangePolicyInherited() {
        return this.parameterChangePolicy == null;
    }

    @Override
    public void removeOwnParameterChangePolicy() {
        this.parameterChangePolicy = null;
    }

    @Override
    public Map<String, StorageActivityModelParameter> getParameters(ActivityConstants.AccessType accessType) {
        ArgChecks.checkEnum((Object)accessType, "accessType", new Object[]{ActivityConstants.AccessType.READ, ActivityConstants.AccessType.WRITE});
        return ActivityModelImpl.cloneStorageParameters(this.parameters.get((Object)accessType));
    }

    @Override
    public void setParameters(ActivityConstants.AccessType accessType, Map<String, StorageActivityModelParameter> parameters) {
        ArgChecks.checkEnum((Object)accessType, "accessType", new Object[]{ActivityConstants.AccessType.READ, ActivityConstants.AccessType.WRITE});
        ActivityModelImpl.setClonedParameters(this.parameters, accessType, parameters);
    }

    @Override
    public Map<String, StorageParameterTemplate> getParameterTemplates() {
        return ActivityModelImpl.cloneStorageParameterTemplates(this.parameterTemplates);
    }

    @Override
    public void setParameterTemplates(Map<String, StorageParameterTemplate> parameterTemplates) {
        this.parameterTemplates = ActivityModelImpl.setParameterTemplates(parameterTemplates);
    }

    @Override
    public String getStaffAssignmentRule() {
        return this.staffAssignmentRule;
    }

    @Override
    public void setStaffAssignmentRule(String staffAssignmentRule) {
        ArgChecks.checkForNull(staffAssignmentRule, "staffAssignmentRule");
        this.staffAssignmentRule = staffAssignmentRule;
    }

    @Override
    public boolean isStaffAssignmentRuleInherited() {
        return this.staffAssignmentRule == null;
    }

    @Override
    public void removeOwnStaffAssignmentRule() {
        this.staffAssignmentRule = null;
    }
}

