/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.activitymodel.defaultimplementation;

import de.aristaflow.adept2.model.activitymodel.StorageActivityConfiguration;
import de.aristaflow.adept2.model.activitymodel.StorageConfiguration;
import de.aristaflow.adept2.model.activitymodel.StorageConfigurationDescription;
import de.aristaflow.adept2.model.activitymodel.StorageConfigurationSet;
import de.aristaflow.adept2.model.activitymodel.StorageParameterTemplate;
import de.aristaflow.adept2.model.activitymodel.defaultimplementation.ActivityModelImpl;
import de.aristaflow.adept2.model.activitymodel.defaultimplementation.DefaultStorageActivityConfiguration;
import de.aristaflow.adept2.model.activitymodel.defaultimplementation.DefaultStorageConfiguration;
import de.aristaflow.adept2.model.activitymodel.defaultimplementation.DefaultStorageConfigurationDescription;
import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.model.common.State;
import de.aristaflow.adept2.model.common.defaultimplementation.SerialisablePluginDataContainer;
import de.aristaflow.adept2.util.ArgChecks;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class DefaultStorageConfigurationSet
extends SerialisablePluginDataContainer
implements StorageConfigurationSet {
    private static final long serialVersionUID = -8700518148584952271L;
    protected String name;
    protected String developerDescription;
    protected long revision;
    protected State state;
    protected Entry entryGlobal = new Entry();
    protected HashMap<String, Entry> entriesEcd = new HashMap();
    protected HashMap<String, Map<String, Entry>> entriesOp = new HashMap();

    public DefaultStorageConfigurationSet(String name, String developerDescription, long revision, State state, PluginDataContainer pluginData, Map<String, String> userAttributes) {
        super(pluginData, userAttributes);
        ArgChecks.checkForNegative(revision, "revision");
        ArgChecks.checkForNull((Object)state, "state");
        this.setName(name);
        this.setDeveloperDescription(developerDescription);
        this.revision = revision;
        this.state = state;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        ArgChecks.checkForNull(name, "name");
        this.name = name;
    }

    @Override
    public String getDeveloperDescription() {
        return this.developerDescription;
    }

    @Override
    public void setDeveloperDescription(String developerDescription) {
        ArgChecks.checkForNull(developerDescription, "developerDescription");
        this.developerDescription = developerDescription;
    }

    @Override
    public long getRevision() {
        return this.revision;
    }

    @Override
    public State getState() {
        return this.state;
    }

    @Override
    public Map<String, Collection<String>> getOperationNames() {
        HashMap<String, Collection<String>> operationNames = new HashMap<String, Collection<String>>(this.entriesOp.size());
        for (String ecName : this.entriesOp.keySet()) {
            operationNames.put(ecName, new ArrayList<String>(this.entriesOp.get(ecName).keySet()));
        }
        return operationNames;
    }

    @Override
    public void addOperation(String ecName, String operationName) {
        ArgChecks.checkForEmpty(ecName, "ecName");
        ArgChecks.checkForEmpty(operationName, "operationName");
        Map<String, Entry> ops = this.entriesOp.get(ecName);
        if (ops == null) {
            ops = new HashMap<String, Entry>();
            this.entriesOp.put(ecName, ops);
            this.entriesEcd.put(ecName, new Entry());
        }
        if (!ops.containsKey(operationName)) {
            ops.put(operationName, new Entry());
        }
    }

    @Override
    public void removeOperation(String ecName, String operationName) {
        ArgChecks.checkForEmpty(ecName, "ecName");
        ArgChecks.checkForEmpty(operationName, "operationName");
        Map<String, Entry> ops = this.entriesOp.get(ecName);
        if (ops != null) {
            ops.remove(operationName);
            if (ops.isEmpty()) {
                this.entriesOp.remove(ecName);
                this.entriesEcd.remove(ecName);
            }
        }
    }

    @Override
    public StorageConfigurationDescription getConfigurationDescription() {
        return this.getEntryGlobal().getConfigurationDescription();
    }

    @Override
    public void setConfigurationDescription(StorageConfigurationDescription description) {
        this.getEntryGlobal().setConfigurationDescription(description);
    }

    @Override
    public StorageConfigurationDescription getConfigurationDescription(String ecName) {
        return this.getEntry(ecName).getConfigurationDescription();
    }

    @Override
    public void setConfigurationDescription(StorageConfigurationDescription description, String ecName) {
        this.getEntry(ecName).setConfigurationDescription(description);
    }

    @Override
    public StorageConfigurationDescription getConfigurationDescription(String ecName, String operationName) {
        return this.getEntry(ecName, operationName).getConfigurationDescription();
    }

    @Override
    public void setConfigurationDescription(StorageConfigurationDescription description, String ecName, String operationName) {
        this.getEntry(ecName, operationName).setConfigurationDescription(description);
    }

    @Override
    public StorageConfiguration getConfiguration() {
        return this.getEntryGlobal().getConfiguration();
    }

    @Override
    public void setConfiguration(StorageConfiguration configuration) {
        this.getEntryGlobal().setConfiguration(configuration);
    }

    @Override
    public StorageConfiguration getConfiguration(String ecName) {
        return this.getEntry(ecName).getConfiguration();
    }

    @Override
    public void setConfiguration(StorageConfiguration configuration, String ecName) {
        this.getEntry(ecName).setConfiguration(configuration);
    }

    @Override
    public StorageActivityConfiguration getConfiguration(String ecName, String operationName) {
        return this.getEntry(ecName, operationName).getActivityConfiguration();
    }

    @Override
    public void setConfiguration(StorageActivityConfiguration configuration, String ecName, String operationName) {
        this.getEntry(ecName, operationName).setConfiguration(configuration);
    }

    @Override
    public StorageConfiguration getTestConfiguration() {
        return this.getEntryGlobal().getTestConfiguration();
    }

    @Override
    public void setTestConfiguration(StorageConfiguration testConfiguration) {
        this.getEntryGlobal().setTestConfiguration(testConfiguration);
    }

    @Override
    public StorageConfiguration getTestConfiguration(String ecName) {
        return this.getEntry(ecName).getTestConfiguration();
    }

    @Override
    public void setTestConfiguration(StorageConfiguration testConfiguration, String ecName) {
        this.getEntry(ecName).setTestConfiguration(testConfiguration);
    }

    @Override
    public StorageActivityConfiguration getTestConfiguration(String ecName, String operationName) {
        return this.getEntry(ecName, operationName).getTestActivityConfiguration();
    }

    @Override
    public void setTestConfiguration(StorageActivityConfiguration testConfiguration, String ecName, String operationName) {
        this.getEntry(ecName, operationName).setTestConfiguration(testConfiguration);
    }

    @Override
    public Map<String, StorageParameterTemplate> getParameterTemplates() {
        return this.getEntryGlobal().getParameterTemplates();
    }

    @Override
    public void setParameterTemplates(Map<String, StorageParameterTemplate> parameterTemplates) {
        this.getEntryGlobal().setParameterTemplates(parameterTemplates);
    }

    @Override
    public Map<String, StorageParameterTemplate> getParameterTemplates(String ecName) {
        return this.getEntry(ecName).getParameterTemplates();
    }

    @Override
    public void setParameterTemplates(Map<String, StorageParameterTemplate> parameterTemplates, String ecName) {
        this.getEntry(ecName).setParameterTemplates(parameterTemplates);
    }

    @Override
    public Map<String, StorageParameterTemplate> getParameterTemplates(String ecName, String operationName) {
        return this.getEntry(ecName, operationName).getParameterTemplates();
    }

    @Override
    public void setParameterTemplates(Map<String, StorageParameterTemplate> parameterTemplates, String ecName, String operationName) {
        this.getEntry(ecName, operationName).setParameterTemplates(parameterTemplates);
    }

    @Override
    public String getStaffAssignmentRule() {
        return this.getEntryGlobal().getStaffAssignmentRule();
    }

    @Override
    public void setStaffAssignmentRule(String staffAssignmentRule) {
        this.getEntryGlobal().setStaffAssignmentRule(staffAssignmentRule);
    }

    @Override
    public String getStaffAssignmentRule(String ecName, String operationName) {
        return this.getEntry(ecName, operationName).getStaffAssignmentRule();
    }

    @Override
    public void setStaffAssignmentRule(String staffAssignmentRule, String ecName, String operationName) {
        this.getEntry(ecName, operationName).setStaffAssignmentRule(staffAssignmentRule);
    }

    private Entry getEntryGlobal() {
        return this.entryGlobal;
    }

    private Entry getEntry(String ecName) {
        ArgChecks.checkForNull(ecName, "ecName");
        Entry entry = this.entriesEcd.get(ecName);
        if (entry == null) {
            entry = new Entry();
        }
        return entry;
    }

    private Entry getEntry(String ecName, String operationName) {
        ArgChecks.checkForNull(ecName, "ecName");
        ArgChecks.checkForNull(operationName, "operationName");
        Entry entry = null;
        Map<String, Entry> ops = this.entriesOp.get(ecName);
        if (ops != null) {
            entry = ops.get(operationName);
        }
        if (entry == null) {
            entry = new Entry();
        }
        return entry;
    }

    private static class Entry
    implements Serializable {
        private static final long serialVersionUID = -8328753248655834384L;
        private StorageConfigurationDescription configurationDescription = new DefaultStorageConfigurationDescription();
        private StorageActivityConfiguration configuration = new DefaultStorageActivityConfiguration();
        private StorageActivityConfiguration testConfiguration = new DefaultStorageActivityConfiguration();
        private HashMap<String, StorageParameterTemplate> parameterTemplates = new HashMap();
        private String staffAssignmentRule;

        Entry() {
        }

        StorageConfigurationDescription getConfigurationDescription() {
            return new DefaultStorageConfigurationDescription(this.configurationDescription);
        }

        void setConfigurationDescription(StorageConfigurationDescription description) {
            this.configurationDescription = new DefaultStorageConfigurationDescription(description);
        }

        StorageConfiguration getConfiguration() {
            return new DefaultStorageConfiguration(this.configuration);
        }

        StorageActivityConfiguration getActivityConfiguration() {
            return new DefaultStorageActivityConfiguration(this.configuration);
        }

        void setConfiguration(StorageConfiguration configuration) {
            this.configuration = new DefaultStorageActivityConfiguration(configuration);
        }

        void setConfiguration(StorageActivityConfiguration configuration) {
            this.configuration = new DefaultStorageActivityConfiguration(configuration);
        }

        StorageConfiguration getTestConfiguration() {
            return new DefaultStorageConfiguration(this.testConfiguration);
        }

        StorageActivityConfiguration getTestActivityConfiguration() {
            return new DefaultStorageActivityConfiguration(this.testConfiguration);
        }

        void setTestConfiguration(StorageConfiguration testConfiguration) {
            this.testConfiguration = new DefaultStorageActivityConfiguration(testConfiguration);
        }

        void setTestConfiguration(StorageActivityConfiguration testConfiguration) {
            this.testConfiguration = new DefaultStorageActivityConfiguration(testConfiguration);
        }

        Map<String, StorageParameterTemplate> getParameterTemplates() {
            return new HashMap<String, StorageParameterTemplate>(this.parameterTemplates);
        }

        void setParameterTemplates(Map<String, StorageParameterTemplate> parameterTemplates) {
            this.parameterTemplates = ActivityModelImpl.setParameterTemplates(parameterTemplates);
        }

        String getStaffAssignmentRule() {
            return this.staffAssignmentRule;
        }

        void setStaffAssignmentRule(String staffAssignmentRule) {
            this.staffAssignmentRule = staffAssignmentRule;
        }
    }
}

