/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.activitymodel.defaultimplementation;

import de.aristaflow.adept2.model.activitymodel.ActivityModelParameter;
import de.aristaflow.adept2.model.activitymodel.InheritedCollection;
import de.aristaflow.adept2.model.activitymodel.defaultimplementation.ActivityModelImpl;
import de.aristaflow.adept2.model.activitymodel.defaultimplementation.DefaultActivityModelParameter;
import de.aristaflow.adept2.model.activitymodel.defaultimplementation.DefaultInheritedCollection;
import de.aristaflow.adept2.util.ArgChecks;
import java.util.Collection;

public class InheritedParameterCollection
extends DefaultInheritedCollection<String, ActivityModelParameter> {
    private static final long serialVersionUID = 4542298096454000022L;

    public InheritedParameterCollection() {
        this((InheritedCollection<String, ActivityModelParameter>)null, (String)null, (InheritedCollection<String, ActivityModelParameter>)null);
    }

    public InheritedParameterCollection(InheritedCollection<String, ActivityModelParameter> parent, String originID, Collection<ActivityModelParameter> parameters) {
        super(parent, originID, null);
        if (parameters != null) {
            ActivityModelImpl.checkParameterCollection(parameters);
            for (ActivityModelParameter param : parameters) {
                this.set(param.getName(), param);
            }
        }
    }

    public InheritedParameterCollection(InheritedCollection<String, ActivityModelParameter> parent, String originID, InheritedCollection<String, ActivityModelParameter> template) {
        super(parent, originID, template);
    }

    @Override
    public void set(String key, ActivityModelParameter element) {
        ArgChecks.checkForNull(key, "key");
        ArgChecks.checkForNull(element, "element");
        if (!element.getName().equals(key)) {
            String msg = "key ('%s') does not fit to the element ('%s')";
            msg = String.format(msg, key, element.getName());
            throw new IllegalArgumentException(msg);
        }
        super.set(key, element);
    }

    @Override
    ActivityModelParameter cloneValue(ActivityModelParameter parent, ActivityModelParameter element) {
        return new DefaultActivityModelParameter(parent, this.originID, element);
    }
}

