/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.activitymodel.defaultimplementation;

import de.aristaflow.adept2.model.activitymodel.InheritedCollection;
import de.aristaflow.adept2.model.activitymodel.ParameterTemplate;
import de.aristaflow.adept2.model.activitymodel.defaultimplementation.ActivityModelImpl;
import de.aristaflow.adept2.model.activitymodel.defaultimplementation.DefaultInheritedCollection;
import de.aristaflow.adept2.model.activitymodel.defaultimplementation.DefaultParameterTemplate;
import de.aristaflow.adept2.util.ArgChecks;
import java.util.Collection;
import java.util.Map;

public class InheritedParameterTemplateCollection
extends DefaultInheritedCollection<String, ParameterTemplate> {
    private static final long serialVersionUID = 4542298096454000022L;

    public InheritedParameterTemplateCollection() {
        this((InheritedCollection<String, ParameterTemplate>)null, (Map<String, ParameterTemplate>)null);
    }

    public InheritedParameterTemplateCollection(InheritedCollection<String, ParameterTemplate> parent, String originID, Collection<ParameterTemplate> parameterTemplates) {
        super(parent, originID, null);
        if (parameterTemplates != null) {
            for (ParameterTemplate template : parameterTemplates) {
                this.set(template.getTemplateName(), template);
            }
        }
    }

    public InheritedParameterTemplateCollection(InheritedCollection<String, ParameterTemplate> parent, Map<String, ParameterTemplate> parameterTemplates) {
        super(parent, parameterTemplates);
        if (parameterTemplates != null) {
            ActivityModelImpl.checkParameterTemplateMap(parameterTemplates);
        }
    }

    public InheritedParameterTemplateCollection(InheritedCollection<String, ParameterTemplate> parent, String originID, InheritedCollection<String, ParameterTemplate> template) {
        super(parent, originID, template);
    }

    @Override
    public void set(String key, ParameterTemplate element) {
        ArgChecks.checkForNull(key, "key");
        ArgChecks.checkForNull(element, "element");
        if (!element.getTemplateName().equals(key)) {
            String msg = "key ('%s') does not fit to the element ('%s')";
            msg = String.format(msg, key, element.getTemplateName());
            throw new IllegalArgumentException(msg);
        }
        super.set(key, element);
    }

    @Override
    ParameterTemplate cloneValue(ParameterTemplate parent, ParameterTemplate element) {
        return new DefaultParameterTemplate(parent, this.originID, element);
    }
}

