/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.activitymodel.xml;

import de.aristaflow.adept2.model.activitymodel.ActivityTemplate;
import de.aristaflow.adept2.model.activitymodel.Identifier;
import de.aristaflow.adept2.model.activitymodel.StorageActivityConfiguration;
import de.aristaflow.adept2.model.activitymodel.StorageActivityTemplateDefinition;
import de.aristaflow.adept2.model.activitymodel.StorageConfiguration;
import de.aristaflow.adept2.model.activitymodel.StorageConfigurationDescription;
import de.aristaflow.adept2.model.activitymodel.StorageConfigurationSet;
import de.aristaflow.adept2.model.activitymodel.StorageExecutableComponentDescription;
import de.aristaflow.adept2.model.activitymodel.StorageOperation;
import de.aristaflow.adept2.model.activitymodel.xml.ActivityModelXMLExportTools;
import de.aristaflow.adept2.model.common.IconDescriptor;
import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.model.common.ResourceDescriptor;
import de.aristaflow.adept2.model.common.XMLExportTools;
import de.aristaflow.adept2.util.xml.XMLHelperTools;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ActivityModelXMLExport {
    public void executableComponentDescriptionToStream(StorageExecutableComponentDescription ecd, OutputStream out) throws IOException {
        Document doc = XMLHelperTools.createDocument();
        doc.appendChild(ActivityModelXMLExportTools.createExecutableComponentDescriptionElement(doc, ecd));
        XMLHelperTools.writeDocumentToStream(doc, out);
    }

    public void operationToStream(StorageOperation op, OutputStream out) throws IOException {
        Document doc = XMLHelperTools.createDocument();
        doc.appendChild(ActivityModelXMLExportTools.createOperationElement(doc, op));
        XMLHelperTools.writeDocumentToStream(doc, out);
    }

    public void configurationSetToStream(StorageConfigurationSet cs, OutputStream out) throws IOException {
        Document doc = XMLHelperTools.createDocument();
        doc.appendChild(ActivityModelXMLExportTools.createConfigurationSetElement(doc, cs));
        XMLHelperTools.writeDocumentToStream(doc, out);
    }

    public void activityTemplateDefinitionToStream(StorageActivityTemplateDefinition atd, OutputStream out) throws IOException {
        Document doc = XMLHelperTools.createDocument();
        doc.appendChild(ActivityModelXMLExportTools.createActivityTemplateDefinitionElement(doc, atd));
        XMLHelperTools.writeDocumentToStream(doc, out);
    }

    public void identifierToStream(Identifier identifier, OutputStream out) throws IOException {
        Document doc = XMLHelperTools.createDocument();
        doc.appendChild(ActivityModelXMLExportTools.createIdentifierElement(doc, identifier));
        XMLHelperTools.writeDocumentToStream(doc, out);
    }

    public void resourceDescriptorToStream(ResourceDescriptor resourceDescriptor, OutputStream out) throws IOException {
        Document doc = XMLHelperTools.createDocument();
        doc.appendChild(ActivityModelXMLExportTools.createResourceDescriptorElement(doc, resourceDescriptor));
        XMLHelperTools.writeDocumentToStream(doc, out);
    }

    public void iconDescriptorToStream(IconDescriptor iconDescriptor, OutputStream out) throws IOException {
        Document doc = XMLHelperTools.createDocument();
        doc.appendChild(ActivityModelXMLExportTools.createIconDescriptorElement(doc, iconDescriptor));
        XMLHelperTools.writeDocumentToStream(doc, out);
    }

    public String activityTemplateToString(ActivityTemplate activityTemplate) {
        try {
            Document document = XMLHelperTools.createDocument();
            Element element = ActivityModelXMLExportTools.createActivityTemplateElement(document, activityTemplate);
            document.appendChild(element);
            return XMLHelperTools.getXMLStringForDocument(document);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public byte[] configurationDescriptionToBytes(StorageConfigurationDescription cd) throws IOException {
        Document document = XMLHelperTools.createDocument();
        Element element = ActivityModelXMLExportTools.createStorageConfigurationDescriptionElement(document, "http://www.aristaflow.de/adept2/activitymodel", cd, null, null);
        document.appendChild(element);
        return XMLHelperTools.getByteArrayForDocument(document);
    }

    public byte[] configurationToBytes(StorageConfiguration conf) throws IOException {
        Document document = XMLHelperTools.createDocument();
        Element element = ActivityModelXMLExportTools.createStorageConfigurationElement(document, "http://www.aristaflow.de/adept2/activitymodel", conf, "configuration", null, null);
        document.appendChild(element);
        return XMLHelperTools.getByteArrayForDocument(document);
    }

    public byte[] activityConfigurationToBytes(StorageActivityConfiguration conf) throws IOException {
        Document document = XMLHelperTools.createDocument();
        Element element = ActivityModelXMLExportTools.createStorageConfigurationElement(document, "http://www.aristaflow.de/adept2/activitymodel", conf, "configuration", null, null);
        document.appendChild(element);
        return XMLHelperTools.getByteArrayForDocument(document);
    }

    public byte[] pluginDataToBytes(PluginDataContainer pluginData) throws IOException {
        Document document = XMLHelperTools.createDocument();
        Element element = XMLExportTools.createPluginDataContainerElement(document, "http://www.aristaflow.de/adept2/activitymodel", pluginData);
        document.appendChild(element);
        return XMLHelperTools.getByteArrayForDocument(document);
    }

    public byte[] userAttributesToBytes(Map<String, String> userAttributes) throws IOException {
        Document document = XMLHelperTools.createDocument();
        Element element = XMLExportTools.createUserAttributesElement(document, "http://www.aristaflow.de/adept2/activitymodel", userAttributes);
        document.appendChild(element);
        return XMLHelperTools.getByteArrayForDocument(document);
    }
}

