/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.activitymodel.xml;

import de.aristaflow.adept2.model.activitymodel.ATDReference;
import de.aristaflow.adept2.model.activitymodel.ATParameter;
import de.aristaflow.adept2.model.activitymodel.ATParameterTemplate;
import de.aristaflow.adept2.model.activitymodel.ActivityTemplate;
import de.aristaflow.adept2.model.activitymodel.CSReference;
import de.aristaflow.adept2.model.activitymodel.ECDReference;
import de.aristaflow.adept2.model.activitymodel.Identifier;
import de.aristaflow.adept2.model.activitymodel.InheritedConfigurationDescription;
import de.aristaflow.adept2.model.activitymodel.OperationReference;
import de.aristaflow.adept2.model.activitymodel.StorageActivityConfiguration;
import de.aristaflow.adept2.model.activitymodel.StorageActivityModelParameter;
import de.aristaflow.adept2.model.activitymodel.StorageActivityTemplateDefinition;
import de.aristaflow.adept2.model.activitymodel.StorageConfiguration;
import de.aristaflow.adept2.model.activitymodel.StorageConfigurationDescription;
import de.aristaflow.adept2.model.activitymodel.StorageConfigurationSet;
import de.aristaflow.adept2.model.activitymodel.StorageExecutableComponentDescription;
import de.aristaflow.adept2.model.activitymodel.StorageOperation;
import de.aristaflow.adept2.model.activitymodel.StorageParameterTemplate;
import de.aristaflow.adept2.model.common.ConfigurationDescription;
import de.aristaflow.adept2.model.common.IconDescriptor;
import de.aristaflow.adept2.model.common.ResourceDescriptor;
import de.aristaflow.adept2.model.common.XMLExportTools;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.util.Base64;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ActivityModelXMLExportTools
extends XMLExportTools {
    private static final String NS = "http://www.aristaflow.de/adept2/activitymodel";

    static Element createActivityTemplateElement(Document doc, ActivityTemplate activityTemplate) {
        Element atElement = doc.createElementNS(NS, "activityTemplate");
        atElement.setAttributeNS(null, "id", activityTemplate.getID().toString());
        ActivityModelXMLExportTools.addElement(doc, atElement, "executableComponentDescriptionName", activityTemplate.getExecutableComponentName());
        ActivityModelXMLExportTools.addElement(doc, atElement, "operationName", activityTemplate.getOperationName());
        if (activityTemplate.getConfigurationName() != null) {
            ActivityModelXMLExportTools.addElement(doc, atElement, "configurationName", activityTemplate.getConfigurationName());
        }
        ActivityModelXMLExportTools.addElement(doc, atElement, "name", activityTemplate.getActivityName());
        ActivityModelXMLExportTools.addElement(doc, atElement, "description", activityTemplate.getDescription(), activityTemplate.getAttributeOrigins().get((Object)ActivityConstants.LocallyOverrideableActivityAttribute.DESCRIPTION));
        ActivityModelXMLExportTools.addElement(doc, atElement, "developerDescription", activityTemplate.getDeveloperDescription());
        ActivityModelXMLExportTools.addElement(doc, atElement, "state", activityTemplate.getState().name());
        ActivityModelXMLExportTools.addElement(doc, atElement, "implementationClass", activityTemplate.getImplementationClass(), activityTemplate.getAttributeOrigins().get((Object)ActivityConstants.LocallyOverrideableActivityAttribute.IMPLEMENTATION_CLASS));
        if (activityTemplate.getClassPath().size() > 0) {
            atElement.appendChild(ActivityModelXMLExportTools.createSeparatedClassPathElement(doc, NS, "classPaths", activityTemplate.getSeparatedClassPaths()));
        }
        ActivityModelXMLExportTools.addElement(doc, atElement, "isSingleton", Boolean.toString(activityTemplate.isSingleton()), activityTemplate.getAttributeOrigins().get((Object)ActivityConstants.LocallyOverrideableActivityAttribute.IS_SINGLETON));
        if (activityTemplate.getSystemComponent() != null) {
            ActivityModelXMLExportTools.addElement(doc, atElement, "systemComponent", Base64.encodeBytes(activityTemplate.getSystemComponent()), activityTemplate.getAttributeOrigins().get((Object)ActivityConstants.LocallyOverrideableActivityAttribute.SYSTEM_COMPONENT));
        }
        ActivityModelXMLExportTools.addElement(doc, atElement, "guiContextID", activityTemplate.getGUIContextID(), activityTemplate.getAttributeOrigins().get((Object)ActivityConstants.LocallyOverrideableActivityAttribute.GUI_CONTEXT_ID));
        atElement.appendChild(ActivityModelXMLExportTools.createECPElement(doc, NS, activityTemplate.getExecutionControlProperties(), activityTemplate.getAttributeOrigins().get((Object)ActivityConstants.LocallyOverrideableActivityAttribute.EXECUTION_CONTROL_PROPERTIES)));
        ActivityModelXMLExportTools.addElement(doc, atElement, "supportsViewOnly", Boolean.toString(activityTemplate.supportsViewOnly()), activityTemplate.getAttributeOrigins().get((Object)ActivityConstants.LocallyOverrideableActivityAttribute.SUPPORTS_VIEW_ONLY));
        ActivityModelXMLExportTools.addElement(doc, atElement, "supportsTestExecution", Boolean.toString(activityTemplate.supportsTestExecution()), activityTemplate.getAttributeOrigins().get((Object)ActivityConstants.LocallyOverrideableActivityAttribute.SUPPORTS_TEST_EXECUTION));
        if (activityTemplate.getIconID() != null) {
            ActivityModelXMLExportTools.addElement(doc, atElement, "iconID", activityTemplate.getIconID().toString(), activityTemplate.getAttributeOrigins().get((Object)ActivityConstants.LocallyOverrideableActivityAttribute.ICON_ID));
        }
        ActivityModelXMLExportTools.addElement(doc, atElement, "licenceInformation", activityTemplate.getLicenceInformation());
        if (activityTemplate.getConfigurationDescription().getEntries().size() > 0) {
            atElement.appendChild(ActivityModelXMLExportTools.createConfigurationDescriptionElement(doc, NS, activityTemplate.getConfigurationDescription(), null, null));
        }
        if (activityTemplate.getConfiguration().getAllEntries().size() > 0) {
            atElement.appendChild(ActivityModelXMLExportTools.createConfigurationElement(doc, NS, activityTemplate.getConfiguration(), "configuration", null, null));
        }
        if (activityTemplate.getTestConfiguration().getAllEntries().size() > 0) {
            atElement.appendChild(ActivityModelXMLExportTools.createConfigurationElement(doc, NS, activityTemplate.getTestConfiguration(), "testConfiguration", null, null));
        }
        ActivityModelXMLExportTools.addElement(doc, atElement, "parameterChangePolicy", activityTemplate.getParameterChangePolicy().name());
        if (activityTemplate.getParameters(ActivityConstants.AccessType.READ).size() > 0) {
            atElement.appendChild(ActivityModelXMLExportTools.createInputParametersElement(doc, activityTemplate.getParameters(ActivityConstants.AccessType.READ)));
        }
        if (activityTemplate.getParameters(ActivityConstants.AccessType.WRITE).size() > 0) {
            atElement.appendChild(ActivityModelXMLExportTools.createOutputParametersElement(doc, activityTemplate.getParameters(ActivityConstants.AccessType.WRITE)));
        }
        if (activityTemplate.getParameterTemplates().size() > 0) {
            Element paramTemplatesElement = doc.createElementNS(NS, "parameterTemplates");
            for (ATParameterTemplate template : activityTemplate.getParameterTemplates().values()) {
                paramTemplatesElement.appendChild(ActivityModelXMLExportTools.createATParameterTemplateElement(doc, template));
            }
            atElement.appendChild(paramTemplatesElement);
        }
        ActivityModelXMLExportTools.addElement(doc, atElement, "staffAssignmentRule", activityTemplate.getStaffAssignmentRule());
        if (activityTemplate.getIdentifiers().size() > 0) {
            Element identifiersElement = doc.createElementNS(NS, "identifiers");
            for (Identifier identifier : activityTemplate.getIdentifiers().values()) {
                identifiersElement.appendChild(ActivityModelXMLExportTools.createIdentifierElement(doc, identifier));
            }
            atElement.appendChild(identifiersElement);
        }
        if (activityTemplate.getSystemComponent() == null) {
            ActivityModelXMLExportTools.addOrigin(doc, atElement, ActivityConstants.LocallyOverrideableActivityAttribute.SYSTEM_COMPONENT, activityTemplate.getAttributeOrigins().get((Object)ActivityConstants.LocallyOverrideableActivityAttribute.SYSTEM_COMPONENT));
        }
        if (activityTemplate.getIconID() == null) {
            ActivityModelXMLExportTools.addOrigin(doc, atElement, ActivityConstants.LocallyOverrideableActivityAttribute.ICON_ID, activityTemplate.getAttributeOrigins().get((Object)ActivityConstants.LocallyOverrideableActivityAttribute.ICON_ID));
        }
        if (activityTemplate.getSupportedPlugins().size() > 0) {
            atElement.appendChild(ActivityModelXMLExportTools.createPluginDataContainerElement(doc, NS, activityTemplate));
        }
        if (activityTemplate.getUserAttributes().size() > 0) {
            atElement.appendChild(ActivityModelXMLExportTools.createUserAttributesElement(doc, NS, activityTemplate.getUserAttributes()));
        }
        return atElement;
    }

    static Element createActivityTemplateDefinitionElement(Document doc, StorageActivityTemplateDefinition def) {
        Element defElement = doc.createElementNS(NS, "activityTemplateDefinition");
        defElement.setAttributeNS(null, "id", def.getID().toString());
        ActivityModelXMLExportTools.addElement(doc, defElement, "executableComponentDescriptionName", def.getExecutableComponentName());
        ActivityModelXMLExportTools.addElement(doc, defElement, "operationName", def.getOperationName());
        if (def.getConfigurationSetName() != null) {
            ActivityModelXMLExportTools.addElement(doc, defElement, "configurationName", def.getConfigurationSetName());
        }
        ActivityModelXMLExportTools.addElement(doc, defElement, "name", def.getName());
        if (!def.isDescriptionInherited()) {
            ActivityModelXMLExportTools.addElement(doc, defElement, "description", def.getDescription());
        }
        if (!def.isImplementationClassInherited()) {
            ActivityModelXMLExportTools.addElement(doc, defElement, "implementationClass", def.getImplementationClass());
        }
        if (!def.isSingletonInherited()) {
            ActivityModelXMLExportTools.addElement(doc, defElement, "isSingleton", Boolean.toString(def.isSingleton()));
        }
        if (!def.isSystemComponentInherited()) {
            if (def.getSystemComponent() != null) {
                ActivityModelXMLExportTools.addElement(doc, defElement, "systemComponent", Base64.encodeBytes(def.getSystemComponent()));
            } else {
                ActivityModelXMLExportTools.addElement(doc, NS, defElement, "systemComponent");
            }
        }
        if (!def.isGUIContextIDInherited()) {
            ActivityModelXMLExportTools.addElement(doc, defElement, "guiContextID", def.getGUIContextID());
        }
        if (!def.areExecutionControlPropertiesInterited()) {
            defElement.appendChild(ActivityModelXMLExportTools.createExecutionControlPropertiesElement(doc, NS, def.getExecutionControlProperties()));
        }
        if (!def.isSupportsViewOnlyInherited()) {
            ActivityModelXMLExportTools.addElement(doc, defElement, "supportsViewOnly", Boolean.toString(def.supportsViewOnly()));
        }
        if (!def.isIconIDInherited()) {
            ActivityModelXMLExportTools.addElement(doc, defElement, "iconID", def.getIconID().toString());
        }
        if (def.getConfiguration().getValues().size() > 0) {
            defElement.appendChild(ActivityModelXMLExportTools.createStorageConfigurationElement(doc, NS, def.getConfiguration(), "configuration", null, null));
        }
        if (!def.isSupportsTestExecutionInherited()) {
            ActivityModelXMLExportTools.addElement(doc, defElement, "supportsTestExecution", Boolean.toString(def.supportsTestExecution()));
        }
        if (def.getConfigurationDescription().getEntries().size() > 0) {
            defElement.appendChild(ActivityModelXMLExportTools.createStorageConfigurationDescriptionElement(doc, NS, def.getConfigurationDescription(), null, null));
        }
        if (def.getTestConfiguration().getValues().size() > 0) {
            defElement.appendChild(ActivityModelXMLExportTools.createStorageConfigurationElement(doc, NS, def.getTestConfiguration(), "testConfiguration", null, null));
        }
        if (!def.isDeveloperDescriptionInherited()) {
            ActivityModelXMLExportTools.addElement(doc, defElement, "developerDescription", def.getDeveloperDescription());
        }
        ActivityModelXMLExportTools.addElement(doc, defElement, "revision", Long.toString(def.getRevision()));
        ActivityModelXMLExportTools.addElement(doc, defElement, "state", def.getState().name());
        if (def.getClassPath().size() > 0) {
            defElement.appendChild(ActivityModelXMLExportTools.createClassPathElement(doc, NS, "ownClassPaths", def.getClassPath()));
        }
        if (!def.isLicenceInformationInherited()) {
            ActivityModelXMLExportTools.addElement(doc, defElement, "licenceInformation", def.getLicenceInformation());
        }
        if (!def.isParameterChangePolicyInherited()) {
            ActivityModelXMLExportTools.addElement(doc, defElement, "parameterChangePolicy", def.getParameterChangePolicy().name());
        }
        if (def.getParameters(ActivityConstants.AccessType.READ).size() > 0) {
            defElement.appendChild(ActivityModelXMLExportTools.createInputParametersElement(doc, def.getParameters(ActivityConstants.AccessType.READ)));
        }
        if (def.getParameters(ActivityConstants.AccessType.WRITE).size() > 0) {
            defElement.appendChild(ActivityModelXMLExportTools.createOutputParametersElement(doc, def.getParameters(ActivityConstants.AccessType.WRITE)));
        }
        if (def.getParameterTemplates().size() > 0) {
            defElement.appendChild(ActivityModelXMLExportTools.createParameterTemplatesElement(doc, def.getParameterTemplates(), null, null));
        }
        if (!def.isStaffAssignmentRuleInherited()) {
            ActivityModelXMLExportTools.addElement(doc, defElement, "staffAssignmentRule", def.getStaffAssignmentRule());
        }
        if (def.getSupportedPlugins().size() > 0) {
            defElement.appendChild(ActivityModelXMLExportTools.createPluginDataContainerElement(doc, NS, def));
        }
        if (def.getUserAttributes().size() > 0) {
            defElement.appendChild(ActivityModelXMLExportTools.createUserAttributesElement(doc, NS, def.getUserAttributes()));
        }
        return defElement;
    }

    static Element createATDReferenceElement(Document doc, ATDReference ref) {
        Element refElement = doc.createElementNS(NS, "atdReference");
        refElement.setAttributeNS(null, "id", ref.getID().toString());
        ActivityModelXMLExportTools.addElement(doc, refElement, "executableComponentDescriptionName", ref.getExecutableComponentName());
        ActivityModelXMLExportTools.addElement(doc, refElement, "operationName", ref.getOperationName());
        if (ref.getConfigurationSetName() != null) {
            ActivityModelXMLExportTools.addElement(doc, refElement, "configurationName", ref.getConfigurationSetName());
        }
        ActivityModelXMLExportTools.addElement(doc, refElement, "name", ref.getName());
        ActivityModelXMLExportTools.addElement(doc, refElement, "description", ref.getDescription());
        ActivityModelXMLExportTools.addElement(doc, refElement, "developerDescription", ref.getDeveloperDescription());
        ActivityModelXMLExportTools.addElement(doc, refElement, "revision", Long.toString(ref.getRevision()));
        if (ref.getBranch() >= 0L) {
            ActivityModelXMLExportTools.addElement(doc, refElement, "branch", Long.toString(ref.getBranch()));
        }
        ActivityModelXMLExportTools.addElement(doc, refElement, "state", ref.getState().name());
        if (ref.getIconID() != null) {
            ActivityModelXMLExportTools.addElement(doc, refElement, "iconID", ref.getIconID().toString());
        }
        if (ref.getSupportedPlugins().size() > 0) {
            refElement.appendChild(ActivityModelXMLExportTools.createPluginDataContainerElement(doc, NS, ref));
        }
        if (ref.getUserAttributes().size() > 0) {
            refElement.appendChild(ActivityModelXMLExportTools.createUserAttributesElement(doc, NS, ref.getUserAttributes()));
        }
        return refElement;
    }

    static Element createIconDescriptorElement(Document doc, IconDescriptor desc) {
        Element descElement = doc.createElementNS(NS, "changeableIconDescriptor");
        descElement.setAttributeNS(null, "id", desc.getID().toString());
        ActivityModelXMLExportTools.addElement(doc, descElement, "name", desc.getName());
        ActivityModelXMLExportTools.addElement(doc, descElement, "description", desc.getDescription());
        IconDescriptor.Dimension[] dimensionArray = desc.getDimensions();
        int n = dimensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IconDescriptor.Dimension dim = dimensionArray[n2];
            ActivityModelXMLExportTools.addDimension(doc, descElement, dim);
            ++n2;
        }
        ActivityModelXMLExportTools.addElement(doc, descElement, "revision", Long.toString(desc.getRevision()));
        ActivityModelXMLExportTools.addElement(doc, descElement, "state", desc.getState().name());
        if (desc.getSupportedPlugins().size() > 0) {
            descElement.appendChild(ActivityModelXMLExportTools.createPluginDataContainerElement(doc, NS, desc));
        }
        if (desc.getUserAttributes().size() > 0) {
            descElement.appendChild(ActivityModelXMLExportTools.createUserAttributesElement(doc, NS, desc.getUserAttributes()));
        }
        return descElement;
    }

    static Element createResourceDescriptorElement(Document doc, ResourceDescriptor desc) {
        Element descElement = doc.createElementNS(NS, "changeableResourceDescriptor");
        descElement.setAttributeNS(null, "id", desc.getID().toString());
        ActivityModelXMLExportTools.addElement(doc, descElement, "name", desc.getName());
        ActivityModelXMLExportTools.addElement(doc, descElement, "description", desc.getDescription());
        ActivityModelXMLExportTools.addElement(doc, descElement, "revision", Long.toString(desc.getRevision()));
        ActivityModelXMLExportTools.addElement(doc, descElement, "state", desc.getState().name());
        if (desc.getSupportedPlugins().size() > 0) {
            descElement.appendChild(ActivityModelXMLExportTools.createPluginDataContainerElement(doc, NS, desc));
        }
        if (desc.getUserAttributes().size() > 0) {
            descElement.appendChild(ActivityModelXMLExportTools.createUserAttributesElement(doc, NS, desc.getUserAttributes()));
        }
        return descElement;
    }

    static Element createConfigurationSetElement(Document doc, StorageConfigurationSet set) {
        Element csElement = doc.createElementNS(NS, "configurationSet");
        ActivityModelXMLExportTools.addElement(doc, csElement, "name", set.getName());
        ActivityModelXMLExportTools.addElement(doc, csElement, "developerDescription", set.getDeveloperDescription());
        ActivityModelXMLExportTools.addElement(doc, csElement, "revision", Long.toString(set.getRevision()));
        ActivityModelXMLExportTools.addElement(doc, csElement, "state", set.getState().name());
        ArrayList<Element> confDesc = new ArrayList<Element>();
        ArrayList<Element> conf = new ArrayList<Element>();
        ArrayList<Element> testConf = new ArrayList<Element>();
        ArrayList<Element> parTemp = new ArrayList<Element>();
        ArrayList<Element> sar = new ArrayList<Element>();
        if (set.getConfigurationDescription().getEntries().size() > 0) {
            confDesc.add(ActivityModelXMLExportTools.createStorageConfigurationDescriptionElement(doc, NS, set.getConfigurationDescription(), null, null));
        }
        if (set.getConfiguration().getValues().size() > 0) {
            conf.add(ActivityModelXMLExportTools.createStorageConfigurationElement(doc, NS, set.getConfiguration(), "configuration", null, null));
        }
        if (set.getTestConfiguration().getValues().size() > 0) {
            testConf.add(ActivityModelXMLExportTools.createStorageConfigurationElement(doc, NS, set.getTestConfiguration(), "testConfiguration", null, null));
        }
        if (set.getParameterTemplates().size() > 0) {
            parTemp.add(ActivityModelXMLExportTools.createParameterTemplatesElement(doc, set.getParameterTemplates(), null, null));
        }
        if (set.getStaffAssignmentRule() != null) {
            sar.add(ActivityModelXMLExportTools.createSARElement(doc, set.getStaffAssignmentRule(), null, null));
        }
        for (Map.Entry<String, Collection<String>> ecd : set.getOperationNames().entrySet()) {
            String ecName = ecd.getKey();
            Element namesElement = doc.createElementNS(NS, "operationNames");
            namesElement.setAttributeNS(null, "ecd", ecName);
            if (set.getConfigurationDescription(ecName).getEntries().size() > 0) {
                confDesc.add(ActivityModelXMLExportTools.createStorageConfigurationDescriptionElement(doc, NS, set.getConfigurationDescription(ecName), ecName, null));
            }
            if (set.getConfiguration(ecName).getValues().size() > 0) {
                conf.add(ActivityModelXMLExportTools.createStorageConfigurationElement(doc, NS, set.getConfiguration(ecName), "configuration", ecName, null));
            }
            if (set.getTestConfiguration(ecName).getValues().size() > 0) {
                testConf.add(ActivityModelXMLExportTools.createStorageConfigurationElement(doc, NS, set.getTestConfiguration(ecName), "testConfiguration", ecName, null));
            }
            if (set.getParameterTemplates(ecName).size() > 0) {
                parTemp.add(ActivityModelXMLExportTools.createParameterTemplatesElement(doc, set.getParameterTemplates(ecName), ecName, null));
            }
            for (String opName : ecd.getValue()) {
                ActivityModelXMLExportTools.addElement(doc, namesElement, "operationName", opName);
                if (set.getConfigurationDescription(ecName, opName).getEntries().size() > 0) {
                    confDesc.add(ActivityModelXMLExportTools.createStorageConfigurationDescriptionElement(doc, NS, set.getConfigurationDescription(ecName, opName), ecName, opName));
                }
                if (set.getConfiguration(ecName, opName).getValues().size() > 0) {
                    conf.add(ActivityModelXMLExportTools.createStorageConfigurationElement(doc, NS, set.getConfiguration(ecName, opName), "configuration", ecName, opName));
                }
                if (set.getTestConfiguration(ecName, opName).getValues().size() > 0) {
                    testConf.add(ActivityModelXMLExportTools.createStorageConfigurationElement(doc, NS, set.getTestConfiguration(ecName, opName), "testConfiguration", ecName, opName));
                }
                if (set.getParameterTemplates(ecName, opName).size() > 0) {
                    parTemp.add(ActivityModelXMLExportTools.createParameterTemplatesElement(doc, set.getParameterTemplates(ecName, opName), ecName, opName));
                }
                if (set.getStaffAssignmentRule(ecName, opName) != null) {
                    sar.add(ActivityModelXMLExportTools.createSARElement(doc, set.getStaffAssignmentRule(ecName, opName), ecName, opName));
                }
                csElement.appendChild(namesElement);
            }
        }
        for (Element e : conf) {
            csElement.appendChild(e);
        }
        for (Element e : confDesc) {
            csElement.appendChild(e);
        }
        for (Element e : testConf) {
            csElement.appendChild(e);
        }
        for (Element e : parTemp) {
            csElement.appendChild(e);
        }
        for (Element e : sar) {
            csElement.appendChild(e);
        }
        if (set.getSupportedPlugins().size() > 0) {
            csElement.appendChild(ActivityModelXMLExportTools.createPluginDataContainerElement(doc, NS, set));
        }
        if (set.getUserAttributes().size() > 0) {
            csElement.appendChild(ActivityModelXMLExportTools.createUserAttributesElement(doc, NS, set.getUserAttributes()));
        }
        return csElement;
    }

    static Element createCSReferenceElement(Document doc, CSReference csRef) {
        Element csRefElement = doc.createElementNS(NS, "csReference");
        ActivityModelXMLExportTools.addElement(doc, csRefElement, "name", csRef.getName());
        ActivityModelXMLExportTools.addElement(doc, csRefElement, "developerDescription", csRef.getDeveloperDescription());
        ActivityModelXMLExportTools.addElement(doc, csRefElement, "revision", Long.toString(csRef.getRevision()));
        ActivityModelXMLExportTools.addElement(doc, csRefElement, "state", csRef.getState().name());
        if (csRef.getOperationNames().size() > 0) {
            for (Map.Entry<String, Collection<String>> entry : csRef.getOperationNames().entrySet()) {
                Element namesElement = doc.createElementNS(NS, "operationNames");
                namesElement.setAttributeNS(null, "ecd", entry.getKey());
                for (String opName : entry.getValue()) {
                    ActivityModelXMLExportTools.addElement(doc, namesElement, "operationName", opName);
                }
                csRefElement.appendChild(namesElement);
            }
        }
        if (csRef.getSupportedPlugins().size() > 0) {
            csRefElement.appendChild(ActivityModelXMLExportTools.createPluginDataContainerElement(doc, NS, csRef));
        }
        if (csRef.getUserAttributes().size() > 0) {
            csRefElement.appendChild(ActivityModelXMLExportTools.createUserAttributesElement(doc, NS, csRef.getUserAttributes()));
        }
        return csRefElement;
    }

    static Element createExecutableComponentDescriptionElement(Document doc, StorageExecutableComponentDescription ecd) {
        Element ecdElement = doc.createElementNS(NS, "executableComponentDescription");
        ActivityModelXMLExportTools.addElement(doc, ecdElement, "name", ecd.getName());
        ActivityModelXMLExportTools.addElement(doc, ecdElement, "developerDescription", ecd.getDeveloperDescription());
        ActivityModelXMLExportTools.addElement(doc, ecdElement, "revision", Long.toString(ecd.getRevision()));
        ActivityModelXMLExportTools.addElement(doc, ecdElement, "state", ecd.getState().name());
        ActivityModelXMLExportTools.addElement(doc, ecdElement, "implementationClass", ecd.getImplementationClass());
        if (ecd.getClassPath().size() > 0) {
            ecdElement.appendChild(ActivityModelXMLExportTools.createClassPathElement(doc, NS, "classPaths", ecd.getClassPath()));
        }
        ActivityModelXMLExportTools.addElement(doc, ecdElement, "isSingleton", Boolean.toString(ecd.isSingleton()));
        if (ecd.getSystemComponent() != null) {
            ActivityModelXMLExportTools.addElement(doc, ecdElement, "systemComponent", Base64.encodeBytes(ecd.getSystemComponent()));
        }
        ActivityModelXMLExportTools.addElement(doc, ecdElement, "guiContextID", ecd.getGUIContextID());
        ecdElement.appendChild(ActivityModelXMLExportTools.createExecutionControlPropertiesElement(doc, NS, ecd.getExecutionControlProperties()));
        if (ecd.getIconID() != null) {
            ActivityModelXMLExportTools.addElement(doc, ecdElement, "iconID", ecd.getIconID().toString());
        }
        ActivityModelXMLExportTools.addElement(doc, ecdElement, "licenceInformation", ecd.getLicenceInformation());
        if (ecd.getConfigurationDescription().getEntries().size() > 0) {
            ecdElement.appendChild(ActivityModelXMLExportTools.createStorageConfigurationDescriptionElement(doc, NS, ecd.getConfigurationDescription(), null, null));
        }
        if (ecd.getParameterTemplates().size() > 0) {
            ecdElement.appendChild(ActivityModelXMLExportTools.createParameterTemplatesElement(doc, ecd.getParameterTemplates(), null, null));
        }
        if (ecd.getSupportedPlugins().size() > 0) {
            ecdElement.appendChild(ActivityModelXMLExportTools.createPluginDataContainerElement(doc, NS, ecd));
        }
        if (ecd.getUserAttributes().size() > 0) {
            ecdElement.appendChild(ActivityModelXMLExportTools.createUserAttributesElement(doc, NS, ecd.getUserAttributes()));
        }
        return ecdElement;
    }

    static Element createECDReferenceElement(Document doc, ECDReference ecdRef) {
        Element ecdRefElement = doc.createElementNS(NS, "ecdReference");
        ActivityModelXMLExportTools.addElement(doc, ecdRefElement, "name", ecdRef.getName());
        ActivityModelXMLExportTools.addElement(doc, ecdRefElement, "developerDescription", ecdRef.getDeveloperDescription());
        ActivityModelXMLExportTools.addElement(doc, ecdRefElement, "revision", Long.toString(ecdRef.getRevision()));
        ActivityModelXMLExportTools.addElement(doc, ecdRefElement, "state", ecdRef.getState().name());
        if (ecdRef.getIconID() != null) {
            ActivityModelXMLExportTools.addElement(doc, ecdRefElement, "iconID", ecdRef.getIconID().toString());
        }
        if (ecdRef.getSupportedPlugins().size() > 0) {
            ecdRefElement.appendChild(ActivityModelXMLExportTools.createPluginDataContainerElement(doc, NS, ecdRef));
        }
        if (ecdRef.getUserAttributes().size() > 0) {
            ecdRefElement.appendChild(ActivityModelXMLExportTools.createUserAttributesElement(doc, NS, ecdRef.getUserAttributes()));
        }
        return ecdRefElement;
    }

    static Element createIdentifierElement(Document doc, Identifier identifier) {
        Element identifierElement = doc.createElementNS(NS, "identifier");
        identifierElement.setAttributeNS(null, "id", identifier.getID().toString());
        ActivityModelXMLExportTools.addElement(doc, identifierElement, "name", identifier.getName());
        ActivityModelXMLExportTools.addElement(doc, identifierElement, "description", identifier.getDescription());
        ActivityModelXMLExportTools.addElement(doc, identifierElement, "revision", Long.toString(identifier.getRevision()));
        ActivityModelXMLExportTools.addElement(doc, identifierElement, "state", identifier.getState().name());
        if (identifier.getSupportedPlugins().size() > 0) {
            identifierElement.appendChild(ActivityModelXMLExportTools.createPluginDataContainerElement(doc, NS, identifier));
        }
        if (identifier.getUserAttributes().size() > 0) {
            identifierElement.appendChild(ActivityModelXMLExportTools.createUserAttributesElement(doc, NS, identifier.getUserAttributes()));
        }
        return identifierElement;
    }

    static Element createOperationElement(Document doc, StorageOperation operation) {
        Element operationElement = doc.createElementNS(NS, "operation");
        ActivityModelXMLExportTools.addElement(doc, operationElement, "ecName", operation.getExecutableComponentName());
        ActivityModelXMLExportTools.addElement(doc, operationElement, "name", operation.getName());
        ActivityModelXMLExportTools.addElement(doc, operationElement, "description", operation.getDescription());
        if (!operation.isDeveloperDescriptionInherited()) {
            ActivityModelXMLExportTools.addElement(doc, operationElement, "developerDescription", operation.getDeveloperDescription());
        }
        ActivityModelXMLExportTools.addElement(doc, operationElement, "revision", Long.toString(operation.getRevision()));
        ActivityModelXMLExportTools.addElement(doc, operationElement, "state", operation.getState().name());
        if (!operation.isImplementationClassInherited()) {
            ActivityModelXMLExportTools.addElement(doc, operationElement, "implementationClass", operation.getImplementationClass());
        }
        operationElement.appendChild(ActivityModelXMLExportTools.createClassPathElement(doc, NS, "ownClassPaths", operation.getClassPath()));
        if (!operation.isSingletonInherited()) {
            ActivityModelXMLExportTools.addElement(doc, operationElement, "isSingleton", Boolean.toString(operation.isSingleton()));
        }
        if (!operation.isSystemComponentInherited()) {
            if (operation.getSystemComponent() != null) {
                ActivityModelXMLExportTools.addElement(doc, operationElement, "systemComponent", Base64.encodeBytes(operation.getSystemComponent()));
            } else {
                ActivityModelXMLExportTools.addElement(doc, NS, operationElement, "systemComponent");
            }
        }
        if (!operation.isGUIContextIDInherited()) {
            ActivityModelXMLExportTools.addElement(doc, operationElement, "guiContextID", operation.getGUIContextID());
        }
        if (!operation.areExecutionControlPropertiesInterhited()) {
            operationElement.appendChild(ActivityModelXMLExportTools.createExecutionControlPropertiesElement(doc, NS, operation.getExecutionControlProperties()));
        }
        ActivityModelXMLExportTools.addElement(doc, operationElement, "supportsViewOnly", Boolean.toString(operation.supportsViewOnly()));
        ActivityModelXMLExportTools.addElement(doc, operationElement, "supportsTestExecution", Boolean.toString(operation.supportsTestExecution()));
        if (!operation.isIconIDInherited()) {
            ActivityModelXMLExportTools.addElement(doc, operationElement, "iconID", operation.getIconID().toString());
        }
        if (!operation.isLicenceInformationInherited()) {
            ActivityModelXMLExportTools.addElement(doc, operationElement, "licenceInformation", operation.getLicenceInformation());
        }
        if (operation.getConfigurationDescription().getEntries().size() > 0) {
            operationElement.appendChild(ActivityModelXMLExportTools.createStorageConfigurationDescriptionElement(doc, NS, operation.getConfigurationDescription(), null, null));
        }
        if (operation.getConfiguration().getValues().size() > 0) {
            operationElement.appendChild(ActivityModelXMLExportTools.createStorageConfigurationElement(doc, NS, operation.getConfiguration(), "configuration", null, null));
        }
        if (operation.getTestConfiguration().getValues().size() > 0) {
            operationElement.appendChild(ActivityModelXMLExportTools.createStorageConfigurationElement(doc, NS, operation.getTestConfiguration(), "testConfiguration", null, null));
        }
        ActivityModelXMLExportTools.addElement(doc, operationElement, "parameterChangePolicy", operation.getParameterChangePolicy().name());
        if (operation.getParameters(ActivityConstants.AccessType.READ).size() > 0) {
            operationElement.appendChild(ActivityModelXMLExportTools.createInputParametersElement(doc, operation.getParameters(ActivityConstants.AccessType.READ)));
        }
        if (operation.getParameters(ActivityConstants.AccessType.WRITE).size() > 0) {
            operationElement.appendChild(ActivityModelXMLExportTools.createOutputParametersElement(doc, operation.getParameters(ActivityConstants.AccessType.WRITE)));
        }
        if (operation.getParameterTemplates().size() > 0) {
            operationElement.appendChild(ActivityModelXMLExportTools.createParameterTemplatesElement(doc, operation.getParameterTemplates(), null, null));
        }
        ActivityModelXMLExportTools.addElement(doc, operationElement, "staffAssignmentRule", operation.getStaffAssignmentRule());
        if (operation.getSupportedPlugins().size() > 0) {
            operationElement.appendChild(ActivityModelXMLExportTools.createPluginDataContainerElement(doc, NS, operation));
        }
        if (operation.getUserAttributes().size() > 0) {
            operationElement.appendChild(ActivityModelXMLExportTools.createUserAttributesElement(doc, NS, operation.getUserAttributes()));
        }
        return operationElement;
    }

    static Element createOperationReferenceElement(Document doc, OperationReference opRef) {
        Element opRefElement = doc.createElementNS(NS, "operationReference");
        ActivityModelXMLExportTools.addElement(doc, opRefElement, "ecName", opRef.getExecutableComponentName());
        ActivityModelXMLExportTools.addElement(doc, opRefElement, "name", opRef.getName());
        ActivityModelXMLExportTools.addElement(doc, opRefElement, "description", opRef.getDescription());
        ActivityModelXMLExportTools.addElement(doc, opRefElement, "developerDescription", opRef.getDeveloperDescription());
        ActivityModelXMLExportTools.addElement(doc, opRefElement, "revision", Long.toString(opRef.getRevision()));
        ActivityModelXMLExportTools.addElement(doc, opRefElement, "state", opRef.getState().name());
        if (opRef.getIconID() != null) {
            ActivityModelXMLExportTools.addElement(doc, opRefElement, "iconID", opRef.getIconID().toString());
        }
        if (opRef.getSupportedPlugins().size() > 0) {
            opRefElement.appendChild(ActivityModelXMLExportTools.createPluginDataContainerElement(doc, NS, opRef));
        }
        if (opRef.getUserAttributes().size() > 0) {
            opRefElement.appendChild(ActivityModelXMLExportTools.createUserAttributesElement(doc, NS, opRef.getUserAttributes()));
        }
        return opRefElement;
    }

    static Element createParameterTemplateElement(Document doc, StorageParameterTemplate template) {
        Element templateElement = doc.createElementNS(NS, "parameterTemplate");
        ActivityModelXMLExportTools.addElement(doc, templateElement, "templateName", template.getTemplateName());
        if (!template.isTemplateDescriptionInherited()) {
            ActivityModelXMLExportTools.addElement(doc, templateElement, "templateDescription", template.getTemplateDescription());
        }
        if (!template.isAccessTypeInherited()) {
            ActivityModelXMLExportTools.addElement(doc, templateElement, "accessType", template.getAccessType().name());
        }
        if (!template.isNameInherited()) {
            ActivityModelXMLExportTools.addElement(doc, templateElement, "name", template.getName());
        }
        if (!template.isDescriptionInherited()) {
            ActivityModelXMLExportTools.addElement(doc, templateElement, "description", template.getDescription());
        }
        if (!template.isDataTypeInherited()) {
            ActivityModelXMLExportTools.addElement(doc, templateElement, "type", template.getDataType().name());
        }
        if (template.getUDTName() != null) {
            ActivityModelXMLExportTools.addElement(doc, templateElement, "udtName", template.getUDTName());
        }
        if (!template.isIdentifierIDInherited()) {
            ActivityModelXMLExportTools.addElement(doc, templateElement, "identifierID", template.getIdentifierID().toString());
        }
        if (!template.isOptionalInherited()) {
            ActivityModelXMLExportTools.addElement(doc, templateElement, "isOptional", Boolean.toString(template.isOptional()));
        }
        if (!template.isVirtualInherited()) {
            ActivityModelXMLExportTools.addElement(doc, templateElement, "isVirtual", Boolean.toString(template.isVirtual()));
        }
        if (!template.isFailureInherited()) {
            ActivityModelXMLExportTools.addElement(doc, templateElement, "isFailure", Boolean.toString(template.isFailure()));
        }
        if (!template.isDefaultValueInherited()) {
            ActivityModelXMLExportTools.addElement(doc, templateElement, "defaultValue", template.getDefaultValue());
        }
        if (template.getConfigurationDescription().getEntries().size() > 0) {
            templateElement.appendChild(ActivityModelXMLExportTools.createStorageConfigurationDescriptionElement(doc, NS, template.getConfigurationDescription(), null, null));
        }
        if (template.getConfiguration().getValues().size() > 0) {
            templateElement.appendChild(ActivityModelXMLExportTools.createStorageConfigurationElement(doc, NS, template.getConfiguration(), "configuration", null, null));
        }
        if (template.getSupportedPlugins().size() > 0) {
            templateElement.appendChild(ActivityModelXMLExportTools.createPluginDataContainerElement(doc, NS, template));
        }
        if (template.getUserAttributes().size() > 0) {
            templateElement.appendChild(ActivityModelXMLExportTools.createUserAttributesElement(doc, NS, template.getUserAttributes()));
        }
        return templateElement;
    }

    static Element createATParameterTemplateElement(Document doc, ATParameterTemplate template) {
        Element templateElement = doc.createElementNS(NS, "parameterTemplate");
        if (template.getTemplateName() != null) {
            ActivityModelXMLExportTools.addElement(doc, templateElement, "templateName", template.getTemplateName());
        }
        if (template.getTemplateDescription() != null) {
            ActivityModelXMLExportTools.addElement(doc, templateElement, "templateDescription", template.getTemplateDescription());
        }
        if (template.getAccessType() != null) {
            ActivityModelXMLExportTools.addElement(doc, templateElement, "accessType", template.getAccessType().name());
        }
        if (template.getName() != null) {
            ActivityModelXMLExportTools.addElement(doc, templateElement, "name", template.getName());
        }
        if (template.getDescription() != null) {
            ActivityModelXMLExportTools.addElement(doc, templateElement, "description", template.getDescription());
        }
        if (template.getDataType() != null) {
            ActivityModelXMLExportTools.addElement(doc, templateElement, "type", template.getDataType().name());
        }
        if (template.getUDTName() != null) {
            ActivityModelXMLExportTools.addElement(doc, templateElement, "udtName", template.getUDTName());
        }
        if (template.getIdentifierID() != null) {
            ActivityModelXMLExportTools.addElement(doc, templateElement, "identifierID", template.getIdentifierID().toString());
        }
        if (template.isOptional() != null) {
            ActivityModelXMLExportTools.addElement(doc, templateElement, "isOptional", Boolean.toString(template.isOptional()));
        }
        if (template.isVirtual() != null) {
            ActivityModelXMLExportTools.addElement(doc, templateElement, "isVirtual", Boolean.toString(template.isVirtual()));
        }
        if (template.isFailure() != null) {
            ActivityModelXMLExportTools.addElement(doc, templateElement, "isFailure", Boolean.toString(template.isFailure()));
        }
        if (template.getDefaultValue() != null) {
            ActivityModelXMLExportTools.addElement(doc, templateElement, "defaultValue", template.getDefaultValue());
        }
        if (template.getConfigurationDescription().getEntries().size() > 0) {
            templateElement.appendChild(ActivityModelXMLExportTools.createConfigurationDescriptionElement(doc, NS, template.getConfigurationDescription(), null, null));
        }
        if (template.getConfiguration().getAllEntries().size() > 0) {
            templateElement.appendChild(ActivityModelXMLExportTools.createConfigurationElement(doc, NS, template.getConfiguration(), "configuration", null, null));
        }
        if (template.getSupportedPlugins().size() > 0) {
            templateElement.appendChild(ActivityModelXMLExportTools.createPluginDataContainerElement(doc, NS, template));
        }
        if (template.getUserAttributes().size() > 0) {
            templateElement.appendChild(ActivityModelXMLExportTools.createUserAttributesElement(doc, NS, template.getUserAttributes()));
        }
        return templateElement;
    }

    static Element createStorageConfigurationDescriptionElement(Document doc, String ns, StorageConfigurationDescription confDesc, String ecd, String operation) {
        Element confDescElement = doc.createElementNS(ns, "configurationDescription");
        if (ecd != null) {
            confDescElement.setAttributeNS(null, "ecd", ecd);
        }
        if (operation != null) {
            confDescElement.setAttributeNS(null, "operation", operation);
        }
        for (Map.Entry<String, ConfigurationDescription.ConfigurationEntry> entry : confDesc.getEntries().entrySet()) {
            if (confDesc instanceof InheritedConfigurationDescription && ((InheritedConfigurationDescription)((Object)confDesc)).isEntryInherited(entry.getKey())) continue;
            confDescElement.appendChild(ActivityModelXMLExportTools.createConfigurationEntryElement(doc, ns, entry.getKey(), entry.getValue()));
        }
        return confDescElement;
    }

    static Element createStorageConfigurationElement(Document doc, String ns, StorageConfiguration conf, String type, String ecd, String operation) {
        Element confElement = doc.createElementNS(ns, type);
        if (ecd != null) {
            confElement.setAttributeNS(null, "ecd", ecd);
        }
        if (operation != null) {
            confElement.setAttributeNS(null, "operation", operation);
        }
        for (Map.Entry<String, String> entry : conf.getValues().entrySet()) {
            Element confEntry = doc.createElementNS(ns, "configurationEntry");
            confEntry.setAttributeNS(null, "name", entry.getKey());
            confEntry.setAttributeNS(null, "fixed", Boolean.toString(conf.getFixedForChildren().contains(entry.getKey())));
            String value = entry.getValue();
            if (value == null) {
                confEntry.setAttributeNS(null, "isNull", Boolean.TRUE.toString());
            } else {
                confEntry.setTextContent(value);
            }
            confElement.appendChild(confEntry);
        }
        if (conf instanceof StorageActivityConfiguration) {
            Element confEntry;
            StorageActivityConfiguration actConf = (StorageActivityConfiguration)conf;
            for (Map.Entry<String, String> entry : actConf.getFromInputParameters().entrySet()) {
                confEntry = doc.createElementNS(ns, "configurationEntry");
                confEntry.setAttributeNS(null, "name", entry.getKey());
                confEntry.setAttributeNS(null, "fixed", Boolean.toString(conf.getFixedForChildren().contains(entry.getKey())));
                confEntry.setAttributeNS(null, "fromParameter", entry.getValue());
                confElement.appendChild(confEntry);
            }
            for (Map.Entry<String, String> entry : actConf.getFromProcessConfigurations().entrySet()) {
                confEntry = doc.createElementNS(ns, "configurationEntry");
                confEntry.setAttributeNS(null, "name", entry.getKey());
                confEntry.setAttributeNS(null, "fixed", Boolean.toString(conf.getFixedForChildren().contains(entry.getKey())));
                confEntry.setAttributeNS(null, "fromConfiguration", entry.getValue());
                confElement.appendChild(confEntry);
            }
        }
        return confElement;
    }

    private static Element createInputParametersElement(Document doc, Collection<ATParameter> parameters) {
        Element parametersElement = doc.createElementNS(NS, "inputParameters");
        for (ATParameter param : parameters) {
            parametersElement.appendChild(ActivityModelXMLExportTools.createInputParameterElement(doc, param));
        }
        return parametersElement;
    }

    private static Element createInputParametersElement(Document doc, Map<String, StorageActivityModelParameter> parameters) {
        Element parametersElement = doc.createElementNS(NS, "inputParameters");
        for (Map.Entry<String, StorageActivityModelParameter> entry : parameters.entrySet()) {
            if (entry.getValue() == null) {
                ActivityModelXMLExportTools.addElement(doc, parametersElement, "name", entry.getKey());
                continue;
            }
            parametersElement.appendChild(ActivityModelXMLExportTools.createInputParameterElement(doc, entry.getValue()));
        }
        return parametersElement;
    }

    private static Element createInputParameterElement(Document doc, ATParameter param) {
        Element inputParameterElement = doc.createElementNS(NS, "inputParameter");
        ActivityModelXMLExportTools.fillParameterElement(doc, inputParameterElement, param);
        return inputParameterElement;
    }

    private static Element createInputParameterElement(Document doc, StorageActivityModelParameter param) {
        Element inputParameterElement = doc.createElementNS(NS, "inputParameter");
        ActivityModelXMLExportTools.fillParameterElement(doc, inputParameterElement, param);
        return inputParameterElement;
    }

    private static Element createOutputParametersElement(Document doc, Collection<ATParameter> parameters) {
        Element parametersElement = doc.createElementNS(NS, "outputParameters");
        for (ATParameter param : parameters) {
            parametersElement.appendChild(ActivityModelXMLExportTools.createOutputParameterElement(doc, param));
        }
        return parametersElement;
    }

    private static Element createOutputParametersElement(Document doc, Map<String, StorageActivityModelParameter> parameters) {
        Element parametersElement = doc.createElementNS(NS, "outputParameters");
        for (Map.Entry<String, StorageActivityModelParameter> entry : parameters.entrySet()) {
            if (entry.getValue() == null) {
                ActivityModelXMLExportTools.addElement(doc, parametersElement, "name", entry.getKey());
                continue;
            }
            parametersElement.appendChild(ActivityModelXMLExportTools.createOutputParameterElement(doc, entry.getValue()));
        }
        return parametersElement;
    }

    private static Element createOutputParameterElement(Document doc, ATParameter param) {
        Element outputParameterElement = doc.createElementNS(NS, "outputParameter");
        ActivityModelXMLExportTools.fillParameterElement(doc, outputParameterElement, param);
        return outputParameterElement;
    }

    private static Element createOutputParameterElement(Document doc, StorageActivityModelParameter param) {
        Element outputParameterElement = doc.createElementNS(NS, "outputParameter");
        ActivityModelXMLExportTools.fillParameterElement(doc, outputParameterElement, param);
        return outputParameterElement;
    }

    private static void fillParameterElement(Document doc, Element parameterElement, ATParameter param) {
        ActivityModelXMLExportTools.addElement(doc, parameterElement, "name", param.getName());
        ActivityModelXMLExportTools.addElement(doc, parameterElement, "description", param.getDescription());
        ActivityModelXMLExportTools.addElement(doc, parameterElement, "developerDescription", param.getDeveloperDescription());
        ActivityModelXMLExportTools.addElement(doc, parameterElement, "type", param.getDataType().name());
        if (param.getUDTName() != null) {
            ActivityModelXMLExportTools.addElement(doc, parameterElement, "udtName", param.getUDTName());
        }
        ActivityModelXMLExportTools.addElement(doc, parameterElement, "identifierID", param.getIdentifierID().toString());
        ActivityModelXMLExportTools.addElement(doc, parameterElement, "isOptional", Boolean.toString(param.isOptional()));
        ActivityModelXMLExportTools.addElement(doc, parameterElement, "isVirtual", Boolean.toString(param.isVirtual()));
        ActivityModelXMLExportTools.addElement(doc, parameterElement, "isFailure", Boolean.toString(param.isFailure()));
        ActivityModelXMLExportTools.addElement(doc, parameterElement, "defaultValue", param.getDefaultValue());
        if (param.getConfigurationDescription().getEntries().size() > 0) {
            parameterElement.appendChild(ActivityModelXMLExportTools.createConfigurationDescriptionElement(doc, NS, param.getConfigurationDescription(), null, null));
        }
        if (param.getConfiguration().getAllEntries().size() > 0) {
            parameterElement.appendChild(ActivityModelXMLExportTools.createConfigurationElement(doc, NS, param.getConfiguration(), "configuration", null, null));
        }
        if (param.getSupportedPlugins().size() > 0) {
            parameterElement.appendChild(ActivityModelXMLExportTools.createPluginDataContainerElement(doc, NS, param));
        }
        if (param.getUserAttributes().size() > 0) {
            parameterElement.appendChild(ActivityModelXMLExportTools.createUserAttributesElement(doc, NS, param.getUserAttributes()));
        }
    }

    private static void fillParameterElement(Document doc, Element parameterElement, StorageActivityModelParameter param) {
        ActivityModelXMLExportTools.addElement(doc, parameterElement, "name", param.getName());
        if (!param.isDescriptionInherited()) {
            ActivityModelXMLExportTools.addElement(doc, parameterElement, "description", param.getDescription());
        }
        if (!param.isDeveloperDescriptionInherited()) {
            ActivityModelXMLExportTools.addElement(doc, parameterElement, "developerDescription", param.getDeveloperDescription());
        }
        ActivityModelXMLExportTools.addElement(doc, parameterElement, "type", param.getDataType().name());
        if (param.getUDTName() != null) {
            ActivityModelXMLExportTools.addElement(doc, parameterElement, "udtName", param.getUDTName());
        }
        ActivityModelXMLExportTools.addElement(doc, parameterElement, "identifierID", param.getIdentifierID().toString());
        if (!param.isOptionalInherited()) {
            ActivityModelXMLExportTools.addElement(doc, parameterElement, "isOptional", Boolean.toString(param.isOptional()));
        }
        ActivityModelXMLExportTools.addElement(doc, parameterElement, "isVirtual", Boolean.toString(param.isVirtual()));
        ActivityModelXMLExportTools.addElement(doc, parameterElement, "isFailure", Boolean.toString(param.isFailure()));
        if (!param.isDefaultValueInherited()) {
            ActivityModelXMLExportTools.addElement(doc, parameterElement, "defaultValue", param.getDefaultValue());
        }
        if (param.getConfigurationDescription().getEntries().size() > 0) {
            parameterElement.appendChild(ActivityModelXMLExportTools.createStorageConfigurationDescriptionElement(doc, NS, param.getConfigurationDescription(), null, null));
        }
        if (param.getConfiguration().getValues().size() > 0) {
            parameterElement.appendChild(ActivityModelXMLExportTools.createStorageConfigurationElement(doc, NS, param.getConfiguration(), "configuration", null, null));
        }
        if (param.getSupportedPlugins().size() > 0) {
            parameterElement.appendChild(ActivityModelXMLExportTools.createPluginDataContainerElement(doc, NS, param));
        }
        if (param.getUserAttributes().size() > 0) {
            parameterElement.appendChild(ActivityModelXMLExportTools.createUserAttributesElement(doc, NS, param.getUserAttributes()));
        }
    }

    private static Element createParameterTemplatesElement(Document doc, Map<String, StorageParameterTemplate> parameterTemplates, String ecd, String operation) {
        Element paramTemplatesElement = doc.createElementNS(NS, "parameterTemplates");
        if (ecd != null) {
            paramTemplatesElement.setAttributeNS(null, "ecd", ecd);
        }
        if (operation != null) {
            paramTemplatesElement.setAttributeNS(null, "operation", operation);
        }
        for (Map.Entry<String, StorageParameterTemplate> entry : parameterTemplates.entrySet()) {
            if (entry.getValue() == null) {
                ActivityModelXMLExportTools.addElement(doc, paramTemplatesElement, "parameterTemplate", entry.getKey());
                continue;
            }
            paramTemplatesElement.appendChild(ActivityModelXMLExportTools.createParameterTemplateElement(doc, entry.getValue()));
        }
        return paramTemplatesElement;
    }

    private static Element createSARElement(Document doc, String sar, String ecd, String operation) {
        Element sarElement = doc.createElementNS(NS, "staffAssignmentRule");
        if (ecd != null) {
            sarElement.setAttributeNS(null, "ecd", ecd);
        }
        if (operation != null) {
            sarElement.setAttributeNS(null, "operation", operation);
        }
        sarElement.setTextContent(sar);
        return sarElement;
    }

    private static void addDimension(Document doc, Element parent, IconDescriptor.Dimension dim) {
        String tagName = "dimension";
        Element element = doc.createElementNS(NS, tagName);
        element.setAttributeNS(null, "width", Integer.toString(dim.width));
        element.setAttributeNS(null, "height", Integer.toString(dim.height));
        parent.appendChild(element);
    }

    private static void addElement(Document document, Element parent, String type, String textContent) {
        ActivityModelXMLExportTools.addElement(document, NS, parent, type, textContent);
    }

    private static void addElement(Document document, Element parent, String type, String textContent, ActivityConstants.ActivityModelEntityType entityType) {
        ActivityModelXMLExportTools.addElement(document, NS, parent, type, textContent, entityType);
    }

    private static void addOrigin(Document doc, Element parent, ActivityConstants.LocallyOverrideableActivityAttribute attribute, ActivityConstants.ActivityModelEntityType entityType) {
        Element origin = doc.createElementNS(NS, "origin");
        origin.setAttributeNS(null, "origin", Byte.toString(entityType.getCode()));
        origin.setTextContent(Byte.toString(attribute.getCode()));
        parent.appendChild(origin);
    }
}

