/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.activitymodel.xml;

import de.aristaflow.adept2.model.activitymodel.ATDReference;
import de.aristaflow.adept2.model.activitymodel.ATParameter;
import de.aristaflow.adept2.model.activitymodel.ATParameterTemplate;
import de.aristaflow.adept2.model.activitymodel.ActivityModelFactory;
import de.aristaflow.adept2.model.activitymodel.ActivityTemplate;
import de.aristaflow.adept2.model.activitymodel.CSReference;
import de.aristaflow.adept2.model.activitymodel.ChangeableIconDescriptor;
import de.aristaflow.adept2.model.activitymodel.ChangeableResourceDescriptor;
import de.aristaflow.adept2.model.activitymodel.ECDReference;
import de.aristaflow.adept2.model.activitymodel.Identifier;
import de.aristaflow.adept2.model.activitymodel.InheritedActivityConfiguration;
import de.aristaflow.adept2.model.activitymodel.InheritedConfiguration;
import de.aristaflow.adept2.model.activitymodel.InheritedConfigurationDescription;
import de.aristaflow.adept2.model.activitymodel.OperationReference;
import de.aristaflow.adept2.model.activitymodel.StorageActivityConfiguration;
import de.aristaflow.adept2.model.activitymodel.StorageActivityModelParameter;
import de.aristaflow.adept2.model.activitymodel.StorageActivityTemplateDefinition;
import de.aristaflow.adept2.model.activitymodel.StorageConfiguration;
import de.aristaflow.adept2.model.activitymodel.StorageConfigurationDescription;
import de.aristaflow.adept2.model.activitymodel.StorageConfigurationSet;
import de.aristaflow.adept2.model.activitymodel.StorageExecutableComponentDescription;
import de.aristaflow.adept2.model.activitymodel.StorageOperation;
import de.aristaflow.adept2.model.activitymodel.StorageParameterTemplate;
import de.aristaflow.adept2.model.common.ActivityConfiguration;
import de.aristaflow.adept2.model.common.Configuration;
import de.aristaflow.adept2.model.common.ConfigurationDescription;
import de.aristaflow.adept2.model.common.ExecutionControlProperties;
import de.aristaflow.adept2.model.common.IconDescriptor;
import de.aristaflow.adept2.model.common.ParameterChangePolicy;
import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.model.common.State;
import de.aristaflow.adept2.model.common.XMLImportTools;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.util.Base64;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.w3c.dom.Element;

public class ActivityModelXMLImportTools
extends XMLImportTools {
    static InheritedActivityConfiguration getInheritedActivityConfiguration(ActivityModelFactory amf, Element confElement) {
        Element child = ActivityModelXMLImportTools.getElement(confElement.getFirstChild());
        HashMap<String, String> values = new HashMap<String, String>();
        HashMap<String, String> fromParameter = new HashMap<String, String>();
        HashMap<String, String> fromConfiguration = new HashMap<String, String>();
        HashSet<String> fixedForChildren = new HashSet<String>();
        while (child != null) {
            String name = child.getAttribute("name");
            String fromParam = child.getAttribute("fromParameter");
            String fromConf = child.getAttribute("fromConfiguration");
            if (Boolean.parseBoolean(child.getAttribute("fixed"))) {
                fixedForChildren.add(name);
            }
            if (fromParam != null && fromParam.length() > 0) {
                fromParameter.put(name, fromParam);
            } else if (fromConf != null && fromConf.length() > 0) {
                fromConfiguration.put(name, fromConf);
            } else if (child.getTextContent().length() > 0) {
                values.put(name, child.getTextContent());
            } else {
                values.put(name, null);
            }
            child = ActivityModelXMLImportTools.getElement(child.getNextSibling());
        }
        return amf.createInheritedActivityConfiguration(null, values, fromParameter, fromConfiguration, fixedForChildren);
    }

    static StorageActivityConfiguration getStorageActivityConfiguration(ActivityModelFactory amf, Element confElement) {
        Element child = ActivityModelXMLImportTools.getElement(confElement.getFirstChild());
        HashMap<String, String> values = new HashMap<String, String>();
        HashMap<String, String> fromParameter = new HashMap<String, String>();
        HashMap<String, String> fromConfiguration = new HashMap<String, String>();
        HashSet<String> fixedForChildren = new HashSet<String>();
        while (child != null) {
            String name = child.getAttribute("name");
            String fromParam = child.getAttribute("fromParameter");
            String fromConf = child.getAttribute("fromConfiguration");
            if (Boolean.parseBoolean(child.getAttribute("fixed"))) {
                fixedForChildren.add(name);
            }
            if (fromParam != null && fromParam.length() > 0) {
                fromParameter.put(name, fromParam);
            } else if (fromConf != null && fromConf.length() > 0) {
                fromConfiguration.put(name, fromConf);
            } else if (Boolean.parseBoolean(child.getAttribute("isNull"))) {
                values.put(name, null);
            } else {
                values.put(name, child.getTextContent());
            }
            child = ActivityModelXMLImportTools.getElement(child.getNextSibling());
        }
        return amf.createStorageActivityConfiguration(values, fromParameter, fromConfiguration, fixedForChildren);
    }

    static InheritedConfiguration getInheritedConfiguration(ActivityModelFactory amf, Element confElement) {
        Element child = ActivityModelXMLImportTools.getElement(confElement.getFirstChild());
        HashMap<String, String> values = new HashMap<String, String>();
        HashSet<String> fixedForChildren = new HashSet<String>();
        while (child != null) {
            String name = child.getAttribute("name");
            if (Boolean.parseBoolean(child.getAttribute("fixed"))) {
                fixedForChildren.add(name);
            }
            if (child.getTextContent().length() > 0) {
                values.put(name, child.getTextContent());
            } else {
                values.put(name, null);
            }
            child = ActivityModelXMLImportTools.getElement(child.getNextSibling());
        }
        return amf.createInheritedConfiguration(null, values, fixedForChildren);
    }

    static StorageConfiguration getStorageConfiguration(ActivityModelFactory amf, Element confElement) {
        Element child = ActivityModelXMLImportTools.getElement(confElement.getFirstChild());
        HashMap<String, String> values = new HashMap<String, String>();
        HashSet<String> fixedForChildren = new HashSet<String>();
        while (child != null) {
            String name = child.getAttribute("name");
            if (Boolean.parseBoolean(child.getAttribute("fixed"))) {
                fixedForChildren.add(name);
            }
            if (Boolean.parseBoolean(child.getAttribute("isNull"))) {
                values.put(name, null);
            } else {
                values.put(name, child.getTextContent());
            }
            child = ActivityModelXMLImportTools.getElement(child.getNextSibling());
        }
        return amf.createStorageConfiguration(values, fixedForChildren);
    }

    static InheritedConfigurationDescription getInheritedConfigurationDescription(ActivityModelFactory amf, Element element) {
        Element child = ActivityModelXMLImportTools.getElement(element.getFirstChild());
        HashMap<String, ConfigurationDescription.ConfigurationEntry> entries = new HashMap<String, ConfigurationDescription.ConfigurationEntry>();
        while (child != null) {
            String name = child.getAttribute("name");
            ConfigurationDescription.ConfigurationEntry value = null;
            Element entry = ActivityModelXMLImportTools.getElement(child.getFirstChild());
            if (entry != null) {
                String description = entry.getTextContent();
                entry = ActivityModelXMLImportTools.getElement(entry.getNextSibling());
                ProcessConstants.AdeptDataType dataType = ProcessConstants.AdeptDataType.valueOf(entry.getTextContent());
                entry = ActivityModelXMLImportTools.getElement(entry.getNextSibling());
                boolean isOptional = Boolean.parseBoolean(entry.getTextContent());
                entry = ActivityModelXMLImportTools.getElement(entry.getNextSibling());
                ArrayList<String> restrictions = new ArrayList<String>();
                PluginDataContainer pluginData = null;
                Map<String, String> userAttributes = null;
                while (entry != null) {
                    if (entry.getTagName().equals("restriction")) {
                        restrictions.add(entry.getTextContent());
                    } else if (entry.getTagName().equals("pluginDataContainer")) {
                        pluginData = ActivityModelXMLImportTools.getPluginDataContainer(amf, entry);
                    } else if (entry.getTagName().equals("userAttributes")) {
                        userAttributes = ActivityModelXMLImportTools.getUserAttributes(entry);
                    }
                    entry = ActivityModelXMLImportTools.getElement(entry.getNextSibling());
                }
                value = amf.createConfigurationEntry(name, description, dataType, isOptional, restrictions.toArray(new String[restrictions.size()]), pluginData, userAttributes);
            }
            entries.put(name, value);
            child = ActivityModelXMLImportTools.getElement(child.getNextSibling());
        }
        return amf.createInheritedConfigurationDescription(null, entries);
    }

    static StorageConfigurationDescription getStorageConfigurationDescription(ActivityModelFactory amf, Element element) {
        Element child = ActivityModelXMLImportTools.getElement(element.getFirstChild());
        HashMap<String, ConfigurationDescription.ConfigurationEntry> entries = new HashMap<String, ConfigurationDescription.ConfigurationEntry>();
        while (child != null) {
            String name = child.getAttribute("name");
            ConfigurationDescription.ConfigurationEntry value = null;
            Element entry = ActivityModelXMLImportTools.getElement(child.getFirstChild());
            if (entry != null) {
                String description = entry.getTextContent();
                entry = ActivityModelXMLImportTools.getElement(entry.getNextSibling());
                ProcessConstants.AdeptDataType dataType = ProcessConstants.AdeptDataType.valueOf(entry.getTextContent());
                entry = ActivityModelXMLImportTools.getElement(entry.getNextSibling());
                boolean isOptional = Boolean.parseBoolean(entry.getTextContent());
                entry = ActivityModelXMLImportTools.getElement(entry.getNextSibling());
                ArrayList<String> restrictions = new ArrayList<String>();
                PluginDataContainer pluginData = null;
                Map<String, String> userAttributes = null;
                while (entry != null) {
                    if (entry.getTagName().equals("restriction")) {
                        restrictions.add(entry.getTextContent());
                    } else if (entry.getTagName().equals("pluginDataContainer")) {
                        pluginData = ActivityModelXMLImportTools.getPluginDataContainer(amf, entry);
                    } else if (entry.getTagName().equals("userAttributes")) {
                        userAttributes = ActivityModelXMLImportTools.getUserAttributes(entry);
                    }
                    entry = ActivityModelXMLImportTools.getElement(entry.getNextSibling());
                }
                value = amf.createConfigurationEntry(name, description, dataType, isOptional, restrictions.toArray(new String[restrictions.size()]), pluginData, userAttributes);
            }
            entries.put(name, value);
            child = ActivityModelXMLImportTools.getElement(child.getNextSibling());
        }
        return amf.createStorageConfigurationDescription(entries);
    }

    static StorageActivityModelParameter getActivityModelParameter(ActivityModelFactory amf, Element paramElement) {
        Element child = ActivityModelXMLImportTools.getElement(paramElement.getFirstChild());
        String name = child.getTextContent();
        child = ActivityModelXMLImportTools.getElement(child.getNextSibling());
        String description = null;
        String developerDescription = null;
        ProcessConstants.AdeptDataType dataType = null;
        String udtName = null;
        UUID identifierID = null;
        Boolean isOptional = null;
        boolean isVirtual = false;
        boolean isFailure = false;
        String defaultValue = null;
        StorageConfigurationDescription configurationDescription = null;
        StorageActivityConfiguration configuration = null;
        PluginDataContainer pluginData = null;
        Map<String, String> userAttributes = null;
        while (child != null) {
            if (child.getTagName().equals("description")) {
                description = child.getTextContent();
            } else if (child.getTagName().equals("developerDescription")) {
                developerDescription = child.getTextContent();
            } else if (child.getTagName().equals("type")) {
                dataType = ProcessConstants.AdeptDataType.valueOf(child.getTextContent());
            } else if (child.getTagName().equals("udtName")) {
                udtName = child.getTextContent();
            } else if (child.getTagName().equals("identifierID")) {
                identifierID = UUID.fromString(child.getTextContent());
            } else if (child.getTagName().equals("isOptional")) {
                isOptional = Boolean.valueOf(child.getTextContent());
            } else if (child.getTagName().equals("isVirtual")) {
                isVirtual = Boolean.parseBoolean(child.getTextContent());
            } else if (child.getTagName().equals("isFailure")) {
                isFailure = Boolean.parseBoolean(child.getTextContent());
            } else if (child.getTagName().equals("defaultValue")) {
                defaultValue = child.getTextContent();
            } else if (child.getTagName().equals("configurationDescription")) {
                configurationDescription = ActivityModelXMLImportTools.getStorageConfigurationDescription(amf, child);
            } else if (child.getTagName().equals("configuration")) {
                configuration = ActivityModelXMLImportTools.getStorageActivityConfiguration(amf, child);
            } else if (child.getTagName().equals("pluginDataContainer")) {
                pluginData = ActivityModelXMLImportTools.getPluginDataContainer(amf, child);
            } else if (child.getTagName().equals("userAttributes")) {
                userAttributes = ActivityModelXMLImportTools.getUserAttributes(child);
            }
            child = ActivityModelXMLImportTools.getElement(child.getNextSibling());
        }
        return amf.createStorageParameter(name, description, developerDescription, dataType, udtName, identifierID, isOptional, isVirtual, isFailure, defaultValue, configurationDescription, configuration, pluginData, userAttributes);
    }

    static ATParameter getATParameter(ActivityModelFactory amf, Element paramElement) {
        Element child = ActivityModelXMLImportTools.getElement(paramElement.getFirstChild());
        String name = child.getTextContent();
        child = ActivityModelXMLImportTools.getElement(child.getNextSibling());
        String description = null;
        String developerDescription = null;
        ProcessConstants.AdeptDataType dataType = null;
        String udtName = null;
        UUID identifierID = null;
        Boolean isOptional = null;
        boolean isVirtual = false;
        boolean isFailure = false;
        String defaultValue = null;
        ConfigurationDescription configurationDescription = null;
        ActivityConfiguration configuration = null;
        PluginDataContainer pluginData = null;
        Map<String, String> userAttributes = null;
        while (child != null) {
            if (child.getTagName().equals("description")) {
                description = child.getTextContent();
            } else if (child.getTagName().equals("developerDescription")) {
                developerDescription = child.getTextContent();
            } else if (child.getTagName().equals("type")) {
                dataType = ProcessConstants.AdeptDataType.valueOf(child.getTextContent());
            } else if (child.getTagName().equals("udtName")) {
                udtName = child.getTextContent();
            } else if (child.getTagName().equals("identifierID")) {
                identifierID = UUID.fromString(child.getTextContent());
            } else if (child.getTagName().equals("isOptional")) {
                isOptional = Boolean.valueOf(child.getTextContent());
            } else if (child.getTagName().equals("isVirtual")) {
                isVirtual = Boolean.parseBoolean(child.getTextContent());
            } else if (child.getTagName().equals("isFailure")) {
                isFailure = Boolean.parseBoolean(child.getTextContent());
            } else if (child.getTagName().equals("defaultValue")) {
                defaultValue = child.getTextContent();
            } else if (child.getTagName().equals("configurationDescription")) {
                configurationDescription = ActivityModelXMLImportTools.getConfigurationDescription(amf, child);
            } else if (child.getTagName().equals("configuration")) {
                configuration = ActivityModelXMLImportTools.getActivityConfiguration(amf, child);
            } else if (child.getTagName().equals("pluginDataContainer")) {
                pluginData = ActivityModelXMLImportTools.getPluginDataContainer(amf, child);
            } else if (child.getTagName().equals("userAttributes")) {
                userAttributes = ActivityModelXMLImportTools.getUserAttributes(child);
            }
            child = ActivityModelXMLImportTools.getElement(child.getNextSibling());
        }
        return amf.createATParameter(name, description, developerDescription, dataType, udtName, identifierID, isOptional, isVirtual, isFailure, defaultValue, configurationDescription, configuration, pluginData, userAttributes);
    }

    static ActivityTemplate getActivityTemplate(ActivityModelFactory amf, Element element) {
        UUID id = UUID.fromString(element.getAttribute("id"));
        Element child = ActivityModelXMLImportTools.getElement(element.getFirstChild());
        String executableComponentDescriptionName = child.getTextContent();
        child = ActivityModelXMLImportTools.getElement(child.getNextSibling());
        String operationName = child.getTextContent();
        child = ActivityModelXMLImportTools.getElement(child.getNextSibling());
        String configurationSetName = null;
        String name = null;
        String description = null;
        String developerDescription = null;
        State state = null;
        String implementationClass = null;
        Map<ActivityConstants.ActivityModelEntityType, List<String>> classPath = null;
        boolean isSingleton = false;
        byte[] systemComponentSignature = null;
        String guiContextID = null;
        ExecutionControlProperties executionControlProperties = null;
        boolean supportsViewOnly = false;
        boolean supportsTestExecution = false;
        UUID iconID = null;
        Map<ActivityConstants.LocallyOverrideableActivityAttribute, ActivityConstants.ActivityModelEntityType> attributeOrigins = ActivityConstants.LocallyOverrideableActivityAttribute.getDefaultOrigins();
        String licenceInformation = null;
        ConfigurationDescription configurationDescription = null;
        ActivityConfiguration configuration = null;
        ActivityConfiguration testConfiguration = null;
        ParameterChangePolicy parameterChangePolicy = null;
        Collection<ATParameter> inputParameters = new HashSet<ATParameter>();
        Collection<ATParameter> outputParameters = new HashSet<ATParameter>();
        Collection<ATParameterTemplate> parameterTemplates = null;
        String staffAssignmentRule = null;
        Collection<Identifier> identifiers = new HashSet<Identifier>();
        PluginDataContainer pluginData = null;
        Map<String, String> userAttributes = null;
        while (child != null) {
            String origin;
            if (child.getTagName().equals("configurationName")) {
                configurationSetName = child.getTextContent();
            } else if (child.getTagName().equals("name")) {
                name = child.getTextContent();
            } else if (child.getTagName().equals("description")) {
                description = child.getTextContent();
                origin = child.getAttribute("origin");
                if (origin.length() > 0) {
                    attributeOrigins.put(ActivityConstants.LocallyOverrideableActivityAttribute.DESCRIPTION, ActivityConstants.ActivityModelEntityType.valueOf(origin));
                }
            } else if (child.getTagName().equals("developerDescription")) {
                developerDescription = child.getTextContent();
            } else if (child.getTagName().equals("state")) {
                state = ActivityModelXMLImportTools.getState(child.getTextContent());
            } else if (child.getTagName().equals("implementationClass")) {
                implementationClass = child.getTextContent();
                origin = child.getAttribute("origin");
                if (origin.length() > 0) {
                    attributeOrigins.put(ActivityConstants.LocallyOverrideableActivityAttribute.IMPLEMENTATION_CLASS, ActivityConstants.ActivityModelEntityType.valueOf(origin));
                }
            } else if (child.getTagName().equals("classPaths")) {
                classPath = ActivityModelXMLImportTools.getSeparatedClassPath(child);
            } else if (child.getTagName().equals("isSingleton")) {
                isSingleton = Boolean.parseBoolean(child.getTextContent());
                origin = child.getAttribute("origin");
                if (origin.length() > 0) {
                    attributeOrigins.put(ActivityConstants.LocallyOverrideableActivityAttribute.IS_SINGLETON, ActivityConstants.ActivityModelEntityType.valueOf(origin));
                }
            } else if (child.getTagName().equals("systemComponent")) {
                systemComponentSignature = Base64.decode(child.getTextContent());
                origin = child.getAttribute("origin");
                if (origin.length() > 0) {
                    attributeOrigins.put(ActivityConstants.LocallyOverrideableActivityAttribute.SYSTEM_COMPONENT, ActivityConstants.ActivityModelEntityType.valueOf(origin));
                }
            } else if (child.getTagName().equals("guiContextID")) {
                guiContextID = child.getTextContent();
                origin = child.getAttribute("origin");
                if (origin.length() > 0) {
                    attributeOrigins.put(ActivityConstants.LocallyOverrideableActivityAttribute.GUI_CONTEXT_ID, ActivityConstants.ActivityModelEntityType.valueOf(origin));
                }
            } else if (child.getTagName().equals("executionControlProperties")) {
                executionControlProperties = ActivityModelXMLImportTools.getExecutionControlProperties(child);
                origin = child.getAttribute("origin");
                if (origin.length() > 0) {
                    attributeOrigins.put(ActivityConstants.LocallyOverrideableActivityAttribute.EXECUTION_CONTROL_PROPERTIES, ActivityConstants.ActivityModelEntityType.valueOf(origin));
                }
            } else if (child.getTagName().equals("supportsViewOnly")) {
                supportsViewOnly = Boolean.parseBoolean(child.getTextContent());
                origin = child.getAttribute("origin");
                if (origin.length() > 0) {
                    attributeOrigins.put(ActivityConstants.LocallyOverrideableActivityAttribute.SUPPORTS_VIEW_ONLY, ActivityConstants.ActivityModelEntityType.valueOf(origin));
                }
            } else if (child.getTagName().equals("supportsTestExecution")) {
                supportsTestExecution = Boolean.parseBoolean(child.getTextContent());
                origin = child.getAttribute("origin");
                if (origin.length() > 0) {
                    attributeOrigins.put(ActivityConstants.LocallyOverrideableActivityAttribute.SUPPORTS_TEST_EXECUTION, ActivityConstants.ActivityModelEntityType.valueOf(origin));
                }
            } else if (child.getTagName().equals("iconID")) {
                iconID = UUID.fromString(child.getTextContent());
                origin = child.getAttribute("origin");
                if (origin.length() > 0) {
                    attributeOrigins.put(ActivityConstants.LocallyOverrideableActivityAttribute.ICON_ID, ActivityConstants.ActivityModelEntityType.valueOf(origin));
                }
            } else if (child.getTagName().equals("licenceInformation")) {
                licenceInformation = child.getTextContent();
            } else if (child.getTagName().equals("configurationDescription")) {
                configurationDescription = ActivityModelXMLImportTools.getConfigurationDescription(amf, child);
            } else if (child.getTagName().equals("configuration")) {
                configuration = ActivityModelXMLImportTools.getActivityConfiguration(amf, child);
            } else if (child.getTagName().equals("testConfiguration")) {
                testConfiguration = ActivityModelXMLImportTools.getActivityConfiguration(amf, child);
            } else if (child.getTagName().equals("parameterChangePolicy")) {
                parameterChangePolicy = ParameterChangePolicy.valueOf(child.getTextContent());
            } else if (child.getTagName().equals("inputParameters")) {
                inputParameters = ActivityModelXMLImportTools.getATParameters(amf, child);
            } else if (child.getTagName().equals("outputParameters")) {
                outputParameters = ActivityModelXMLImportTools.getATParameters(amf, child);
            } else if (child.getTagName().equals("parameterTemplates")) {
                parameterTemplates = ActivityModelXMLImportTools.getATParameterTemplates(amf, child, false).values();
            } else if (child.getTagName().equals("staffAssignmentRule")) {
                staffAssignmentRule = child.getTextContent();
            } else if (child.getTagName().equals("identifiers")) {
                identifiers = ActivityModelXMLImportTools.getIdentifiers(amf, child);
            } else if (child.getTagName().equals("origin")) {
                ActivityConstants.LocallyOverrideableActivityAttribute loaa = ActivityConstants.LocallyOverrideableActivityAttribute.valueOf(Byte.parseByte(child.getTextContent()));
                ActivityConstants.ActivityModelEntityType amet = ActivityConstants.ActivityModelEntityType.valueOf(Byte.parseByte(child.getAttribute("origin")));
                attributeOrigins.put(loaa, amet);
            } else if (child.getTagName().equals("pluginDataContainer")) {
                pluginData = ActivityModelXMLImportTools.getPluginDataContainer(amf, child);
            } else if (child.getTagName().equals("userAttributes")) {
                userAttributes = ActivityModelXMLImportTools.getUserAttributes(child);
            }
            child = ActivityModelXMLImportTools.getElement(child.getNextSibling());
        }
        return amf.createActivityTemplate(id, executableComponentDescriptionName, operationName, configurationSetName, name, description, developerDescription, state, implementationClass, classPath, isSingleton, systemComponentSignature, guiContextID, executionControlProperties, supportsViewOnly, supportsTestExecution, iconID, attributeOrigins, licenceInformation, configurationDescription, configuration, testConfiguration, parameterChangePolicy, inputParameters, outputParameters, parameterTemplates, staffAssignmentRule, identifiers, pluginData, userAttributes);
    }

    static StorageActivityTemplateDefinition getStorageActivityTemplateDefinition(ActivityModelFactory amf, Element element) {
        UUID id = UUID.fromString(element.getAttribute("id"));
        Element child = ActivityModelXMLImportTools.getElement(element.getFirstChild());
        String ecName = child.getTextContent();
        child = ActivityModelXMLImportTools.getElement(child.getNextSibling());
        String operationName = child.getTextContent();
        child = ActivityModelXMLImportTools.getElement(child.getNextSibling());
        String configurationSetName = null;
        String name = null;
        String description = null;
        String developerDescription = null;
        long revision = 0L;
        State state = null;
        String implementationClass = null;
        List<String> classPath = null;
        Boolean isSingleton = null;
        byte[] systemComponentSignature = null;
        String guiContextID = null;
        ExecutionControlProperties executionControlProperties = null;
        Boolean supportsViewOnly = null;
        Boolean supportsTestExecution = null;
        String licenceInformation = null;
        UUID iconID = null;
        StorageConfigurationDescription configurationDescription = null;
        StorageActivityConfiguration configuration = null;
        StorageActivityConfiguration testConfiguration = null;
        ParameterChangePolicy parameterChangePolicy = null;
        Map<String, StorageActivityModelParameter> inputParameters = null;
        Map<String, StorageActivityModelParameter> outputParameters = null;
        Map<String, StorageParameterTemplate> parameterTemplates = null;
        String staffAssignmentRule = null;
        PluginDataContainer pluginData = null;
        Map<String, String> userAttributes = null;
        while (child != null) {
            if (child.getTagName().equals("configurationName")) {
                configurationSetName = child.getTextContent();
            } else if (child.getTagName().equals("name")) {
                name = child.getTextContent();
            } else if (child.getTagName().equals("description")) {
                description = child.getTextContent();
            } else if (child.getTagName().equals("developerDescription")) {
                developerDescription = child.getTextContent();
            } else if (child.getTagName().equals("revision")) {
                revision = Long.parseLong(child.getTextContent());
            } else if (child.getTagName().equals("state")) {
                state = ActivityModelXMLImportTools.getState(child.getTextContent());
            } else if (child.getTagName().equals("implementationClass")) {
                implementationClass = child.getTextContent();
            } else if (child.getTagName().equals("ownClassPaths")) {
                classPath = ActivityModelXMLImportTools.getClassPath(child);
            } else if (child.getTagName().equals("isSingleton")) {
                isSingleton = Boolean.parseBoolean(child.getTextContent());
            } else if (child.getTagName().equals("systemComponent")) {
                systemComponentSignature = Base64.decode(child.getTextContent());
            } else if (child.getTagName().equals("guiContextID")) {
                guiContextID = child.getTextContent();
            } else if (child.getTagName().equals("executionControlProperties")) {
                executionControlProperties = ActivityModelXMLImportTools.getExecutionControlProperties(child);
            } else if (child.getTagName().equals("supportsViewOnly")) {
                supportsViewOnly = Boolean.parseBoolean(child.getTextContent());
            } else if (child.getTagName().equals("supportsTestExecution")) {
                supportsTestExecution = Boolean.parseBoolean(child.getTextContent());
            } else if (child.getTagName().equals("licenceInformation")) {
                licenceInformation = child.getTextContent();
            } else if (child.getTagName().equals("iconID")) {
                iconID = UUID.fromString(child.getTextContent());
            } else if (child.getTagName().equals("configurationDescription")) {
                configurationDescription = ActivityModelXMLImportTools.getStorageConfigurationDescription(amf, child);
            } else if (child.getTagName().equals("configuration")) {
                configuration = ActivityModelXMLImportTools.getStorageActivityConfiguration(amf, child);
            } else if (child.getTagName().equals("testConfiguration")) {
                testConfiguration = ActivityModelXMLImportTools.getStorageActivityConfiguration(amf, child);
            } else if (child.getTagName().equals("parameterChangePolicy")) {
                parameterChangePolicy = ParameterChangePolicy.valueOf(child.getTextContent());
            } else if (child.getTagName().equals("inputParameters")) {
                inputParameters = ActivityModelXMLImportTools.getParameters(amf, child);
            } else if (child.getTagName().equals("outputParameters")) {
                outputParameters = ActivityModelXMLImportTools.getParameters(amf, child);
            } else if (child.getTagName().equals("parameterTemplates")) {
                parameterTemplates = ActivityModelXMLImportTools.getParameterTemplates(amf, child, false);
            } else if (child.getTagName().equals("staffAssignmentRule")) {
                staffAssignmentRule = child.getTextContent();
            } else if (child.getTagName().equals("pluginDataContainer")) {
                pluginData = ActivityModelXMLImportTools.getPluginDataContainer(amf, child);
            } else if (child.getTagName().equals("userAttributes")) {
                userAttributes = ActivityModelXMLImportTools.getUserAttributes(child);
            }
            child = ActivityModelXMLImportTools.getElement(child.getNextSibling());
        }
        return amf.createStorageActivityTemplateDefinition(ecName, operationName, configurationSetName, id, name, description, developerDescription, revision, state, implementationClass, classPath, isSingleton, systemComponentSignature, guiContextID, executionControlProperties, supportsViewOnly, supportsTestExecution, iconID, licenceInformation, configurationDescription, configuration, testConfiguration, parameterChangePolicy, inputParameters, outputParameters, parameterTemplates, staffAssignmentRule, pluginData, userAttributes);
    }

    static ATDReference getATDReference(ActivityModelFactory amf, Element element) {
        UUID id = UUID.fromString(element.getAttribute("id"));
        Element child = ActivityModelXMLImportTools.getElement(element.getFirstChild());
        String executableComponentDescriptionName = child.getTextContent();
        child = ActivityModelXMLImportTools.getElement(child.getNextSibling());
        String operationName = child.getTextContent();
        child = ActivityModelXMLImportTools.getElement(child.getNextSibling());
        String configurationSetName = null;
        String name = null;
        String description = null;
        String developerDescription = null;
        long revision = 0L;
        long branch = -1L;
        State state = null;
        UUID iconID = null;
        PluginDataContainer pluginData = null;
        Map<String, String> userAttributes = null;
        while (child != null) {
            if (child.getTagName().equals("configurationName")) {
                configurationSetName = child.getTextContent();
            } else if (child.getTagName().equals("name")) {
                name = child.getTextContent();
            } else if (child.getTagName().equals("description")) {
                description = child.getTextContent();
            } else if (child.getTagName().equals("developerDescription")) {
                developerDescription = child.getTextContent();
            } else if (child.getTagName().equals("revision")) {
                revision = Long.parseLong(child.getTextContent());
            } else if (child.getTagName().equals("branch")) {
                branch = Long.parseLong(child.getTextContent());
            } else if (child.getTagName().equals("state")) {
                state = ActivityModelXMLImportTools.getState(child.getTextContent());
            }
            if (child.getTagName().equals("iconID")) {
                iconID = UUID.fromString(child.getTextContent());
            } else if (child.getTagName().equals("pluginDataContainer")) {
                pluginData = ActivityModelXMLImportTools.getPluginDataContainer(amf, child);
            } else if (child.getTagName().equals("userAttributes")) {
                userAttributes = ActivityModelXMLImportTools.getUserAttributes(child);
            }
            child = ActivityModelXMLImportTools.getElement(child.getNextSibling());
        }
        return amf.createATDReference(id, executableComponentDescriptionName, operationName, configurationSetName, name, description, developerDescription, revision, branch, state, iconID, pluginData, userAttributes);
    }

    static ChangeableIconDescriptor getChangeableIconDescriptor(ActivityModelFactory amf, Element element) {
        UUID id = UUID.fromString(element.getAttribute("id"));
        Element child = ActivityModelXMLImportTools.getElement(element.getFirstChild());
        String name = child.getTextContent();
        child = ActivityModelXMLImportTools.getElement(child.getNextSibling());
        String description = child.getTextContent();
        child = ActivityModelXMLImportTools.getElement(child.getNextSibling());
        ArrayList<IconDescriptor.Dimension> dimensionSet = new ArrayList<IconDescriptor.Dimension>();
        long revision = 0L;
        State state = null;
        PluginDataContainer pluginData = null;
        Map<String, String> userAttributes = null;
        while (child != null) {
            if (child.getTagName().equals("dimension")) {
                dimensionSet.add(ActivityModelXMLImportTools.getDimension(child));
            } else if (child.getTagName().equals("revision")) {
                revision = Long.parseLong(child.getTextContent());
            } else if (child.getTagName().equals("state")) {
                state = ActivityModelXMLImportTools.getState(child.getTextContent());
            } else if (child.getTagName().equals("pluginDataContainer")) {
                pluginData = ActivityModelXMLImportTools.getPluginDataContainer(amf, child);
            } else if (child.getTagName().equals("userAttributes")) {
                userAttributes = ActivityModelXMLImportTools.getUserAttributes(child);
            }
            child = ActivityModelXMLImportTools.getElement(child.getNextSibling());
        }
        IconDescriptor.Dimension[] dimensions = dimensionSet.toArray(new IconDescriptor.Dimension[dimensionSet.size()]);
        return amf.createChangeableIconDescriptor(id, name, description, dimensions, revision, state, pluginData, userAttributes);
    }

    static ChangeableResourceDescriptor getChangeableResourceDescriptor(ActivityModelFactory amf, Element element) {
        UUID id = UUID.fromString(element.getAttribute("id"));
        Element child = ActivityModelXMLImportTools.getElement(element.getFirstChild());
        String name = child.getTextContent();
        child = ActivityModelXMLImportTools.getElement(child.getNextSibling());
        String description = child.getTextContent();
        child = ActivityModelXMLImportTools.getElement(child.getNextSibling());
        long revision = Long.parseLong(child.getTextContent());
        child = ActivityModelXMLImportTools.getElement(child.getNextSibling());
        State state = ActivityModelXMLImportTools.getState(child.getTextContent());
        child = ActivityModelXMLImportTools.getElement(child.getNextSibling());
        PluginDataContainer pluginData = null;
        Map<String, String> userAttributes = null;
        while (child != null) {
            if (child.getTagName().equals("pluginDataContainer")) {
                pluginData = ActivityModelXMLImportTools.getPluginDataContainer(amf, child);
            } else if (child.getTagName().equals("userAttributes")) {
                userAttributes = ActivityModelXMLImportTools.getUserAttributes(child);
            }
            child = ActivityModelXMLImportTools.getElement(child.getNextSibling());
        }
        return amf.createChangeableResourceDescriptor(id, name, description, revision, state, pluginData, userAttributes);
    }

    static StorageConfigurationSet getStorageConfigurationSet(ActivityModelFactory amf, Element element) {
        String ecd;
        Element child = ActivityModelXMLImportTools.getElement(element.getFirstChild());
        String name = child.getTextContent();
        child = ActivityModelXMLImportTools.getElement(child.getNextSibling());
        String description = child.getTextContent();
        child = ActivityModelXMLImportTools.getElement(child.getNextSibling());
        long revision = Long.parseLong(child.getTextContent());
        child = ActivityModelXMLImportTools.getElement(child.getNextSibling());
        State state = ActivityModelXMLImportTools.getState(child.getTextContent());
        child = ActivityModelXMLImportTools.getElement(child.getNextSibling());
        HashMap operationNames = new HashMap();
        StorageConfiguration globalConf = null;
        HashMap<String, StorageConfiguration> ecdConf = new HashMap<String, StorageConfiguration>();
        HashMap opConf = new HashMap();
        StorageConfigurationDescription globalConfDesc = null;
        HashMap<String, StorageConfigurationDescription> ecdConfDesc = new HashMap<String, StorageConfigurationDescription>();
        HashMap opConfDesc = new HashMap();
        StorageConfiguration globalTestConf = null;
        HashMap<String, StorageConfiguration> ecdTestConf = new HashMap<String, StorageConfiguration>();
        HashMap opTestConf = new HashMap();
        Map<String, StorageParameterTemplate> globalParams = null;
        HashMap<String, Map<String, StorageParameterTemplate>> ecdParams = new HashMap<String, Map<String, StorageParameterTemplate>>();
        HashMap opParams = new HashMap();
        String globalSAR = null;
        HashMap opSAR = new HashMap();
        PluginDataContainer pluginData = null;
        Map<String, String> userAttributes = null;
        while (child != null) {
            Map<String, String> map;
            String operationName;
            String ecd2;
            if (child.getTagName().equals("operationNames")) {
                ecd2 = child.getAttribute("ecd");
                ArrayList<String> operations = new ArrayList<String>();
                Element opChild = ActivityModelXMLImportTools.getElement(child.getFirstChild());
                while (opChild != null) {
                    operations.add(opChild.getTextContent());
                    opChild = ActivityModelXMLImportTools.getElement(opChild.getNextSibling());
                }
                operationNames.put(ecd2, operations);
            } else if (child.getTagName().equals("configurationDescription")) {
                ecd2 = child.getAttribute("ecd");
                operationName = child.getAttribute("operation");
                if (ecd2.length() > 0) {
                    if (operationName.length() > 0) {
                        map = (HashMap<String, StorageConfigurationDescription>)opConfDesc.get(ecd2);
                        if (map == null) {
                            map = new HashMap<String, StorageConfigurationDescription>();
                        }
                        map.put(operationName, (String)((Object)ActivityModelXMLImportTools.getStorageConfigurationDescription(amf, child)));
                        opConfDesc.put(ecd2, map);
                    } else {
                        ecdConfDesc.put(ecd2, ActivityModelXMLImportTools.getStorageConfigurationDescription(amf, child));
                    }
                } else {
                    globalConfDesc = ActivityModelXMLImportTools.getStorageConfigurationDescription(amf, child);
                }
            } else if (child.getTagName().equals("configuration")) {
                ecd2 = child.getAttribute("ecd");
                operationName = child.getAttribute("operation");
                if (ecd2.length() > 0) {
                    if (operationName.length() > 0) {
                        map = (Map)opConf.get(ecd2);
                        if (map == null) {
                            map = new HashMap();
                        }
                        map.put(operationName, (String)((Object)ActivityModelXMLImportTools.getStorageActivityConfiguration(amf, child)));
                        opConf.put(ecd2, map);
                    } else {
                        ecdConf.put(ecd2, ActivityModelXMLImportTools.getStorageConfiguration(amf, child));
                    }
                } else {
                    globalConf = ActivityModelXMLImportTools.getStorageConfiguration(amf, child);
                }
            } else if (child.getTagName().equals("testConfiguration")) {
                ecd2 = child.getAttribute("ecd");
                operationName = child.getAttribute("operation");
                if (ecd2.length() > 0) {
                    if (operationName.length() > 0) {
                        map = (Map)opTestConf.get(ecd2);
                        if (map == null) {
                            map = new HashMap();
                        }
                        map.put(operationName, (String)((Object)ActivityModelXMLImportTools.getStorageActivityConfiguration(amf, child)));
                        opTestConf.put(ecd2, map);
                    } else {
                        ecdTestConf.put(ecd2, ActivityModelXMLImportTools.getStorageConfiguration(amf, child));
                    }
                } else {
                    globalTestConf = ActivityModelXMLImportTools.getStorageConfiguration(amf, child);
                }
            } else if (child.getTagName().equals("parameterTemplates")) {
                ecd2 = child.getAttribute("ecd");
                operationName = child.getAttribute("operation");
                if (ecd2.length() > 0) {
                    if (operationName.length() > 0) {
                        map = (Map)opParams.get(ecd2);
                        if (map == null) {
                            map = new HashMap();
                        }
                        map.put(operationName, (String)((Object)ActivityModelXMLImportTools.getParameterTemplates(amf, child, true)));
                        opParams.put(ecd2, map);
                    } else {
                        ecdParams.put(ecd2, ActivityModelXMLImportTools.getParameterTemplates(amf, child, true));
                    }
                } else {
                    globalParams = ActivityModelXMLImportTools.getParameterTemplates(amf, child, true);
                }
            } else if (child.getTagName().equals("staffAssignmentRule")) {
                ecd2 = child.getAttribute("ecd");
                operationName = child.getAttribute("operation");
                if (ecd2.length() > 0) {
                    if (operationName.length() > 0) {
                        map = (Map)opSAR.get(ecd2);
                        if (map == null) {
                            map = new HashMap();
                        }
                        map.put(operationName, child.getTextContent());
                        opSAR.put(ecd2, map);
                    }
                } else {
                    globalSAR = child.getTextContent();
                }
            } else if (child.getTagName().equals("pluginDataContainer")) {
                pluginData = ActivityModelXMLImportTools.getPluginDataContainer(amf, child);
            } else if (child.getTagName().equals("userAttributes")) {
                userAttributes = ActivityModelXMLImportTools.getUserAttributes(child);
            }
            child = ActivityModelXMLImportTools.getElement(child.getNextSibling());
        }
        StorageConfigurationSet cs = amf.createStorageConfigurationSet(name, description, revision, state, pluginData, userAttributes);
        for (Map.Entry entry : operationNames.entrySet()) {
            for (String operation : (Collection)entry.getValue()) {
                cs.addOperation((String)entry.getKey(), operation);
            }
        }
        cs.setConfigurationDescription(globalConfDesc);
        for (Map.Entry entry : ecdConfDesc.entrySet()) {
            cs.setConfigurationDescription((StorageConfigurationDescription)entry.getValue(), (String)entry.getKey());
        }
        for (Map.Entry ecdEntry : opConfDesc.entrySet()) {
            ecd = (String)ecdEntry.getKey();
            for (Map.Entry opEntry : ((Map)ecdEntry.getValue()).entrySet()) {
                cs.setConfigurationDescription((StorageConfigurationDescription)opEntry.getValue(), ecd, (String)opEntry.getKey());
            }
        }
        cs.setConfiguration(globalConf);
        for (Map.Entry entry : ecdConf.entrySet()) {
            cs.setConfiguration((StorageConfiguration)entry.getValue(), (String)entry.getKey());
        }
        for (Map.Entry ecdEntry : opConf.entrySet()) {
            ecd = (String)ecdEntry.getKey();
            for (Map.Entry opEntry : ((Map)ecdEntry.getValue()).entrySet()) {
                cs.setConfiguration((StorageActivityConfiguration)opEntry.getValue(), ecd, (String)opEntry.getKey());
            }
        }
        cs.setTestConfiguration(globalTestConf);
        for (Map.Entry entry : ecdTestConf.entrySet()) {
            cs.setTestConfiguration((StorageConfiguration)entry.getValue(), (String)entry.getKey());
        }
        for (Map.Entry ecdEntry : opTestConf.entrySet()) {
            ecd = (String)ecdEntry.getKey();
            for (Map.Entry opEntry : ((Map)ecdEntry.getValue()).entrySet()) {
                cs.setTestConfiguration((StorageActivityConfiguration)opEntry.getValue(), ecd, (String)opEntry.getKey());
            }
        }
        cs.setParameterTemplates(globalParams);
        for (Map.Entry entry : ecdParams.entrySet()) {
            cs.setParameterTemplates((Map)entry.getValue(), (String)entry.getKey());
        }
        for (Map.Entry ecdEntry : opParams.entrySet()) {
            ecd = (String)ecdEntry.getKey();
            for (Map.Entry opEntry : ((Map)ecdEntry.getValue()).entrySet()) {
                cs.setParameterTemplates((Map)opEntry.getValue(), ecd, (String)opEntry.getKey());
            }
        }
        cs.setStaffAssignmentRule(globalSAR);
        for (Map.Entry ecdEntry : opSAR.entrySet()) {
            ecd = (String)ecdEntry.getKey();
            for (Map.Entry opEntry : ((Map)ecdEntry.getValue()).entrySet()) {
                cs.setStaffAssignmentRule((String)opEntry.getValue(), ecd, (String)opEntry.getKey());
            }
        }
        return cs;
    }

    static CSReference getCSReference(ActivityModelFactory amf, Element element) {
        Element child = ActivityModelXMLImportTools.getElement(element.getFirstChild());
        String name = child.getTextContent();
        child = ActivityModelXMLImportTools.getElement(child.getNextSibling());
        String description = child.getTextContent();
        child = ActivityModelXMLImportTools.getElement(child.getNextSibling());
        long revision = Long.parseLong(child.getTextContent());
        child = ActivityModelXMLImportTools.getElement(child.getNextSibling());
        State state = ActivityModelXMLImportTools.getState(child.getTextContent());
        child = ActivityModelXMLImportTools.getElement(child.getNextSibling());
        HashMap<String, Collection<String>> operationNames = new HashMap<String, Collection<String>>();
        PluginDataContainer pluginData = null;
        Map<String, String> userAttributes = null;
        while (child != null) {
            if (child.getTagName().equals("operationNames")) {
                String ecd = child.getAttribute("ecd");
                HashSet<String> operations = new HashSet<String>();
                Element opChild = ActivityModelXMLImportTools.getElement(child.getFirstChild());
                while (opChild != null) {
                    operations.add(opChild.getTextContent());
                    opChild = ActivityModelXMLImportTools.getElement(opChild.getNextSibling());
                }
                operationNames.put(ecd, operations);
            } else if (child.getTagName().equals("pluginDataContainer")) {
                pluginData = ActivityModelXMLImportTools.getPluginDataContainer(amf, child);
            } else if (child.getTagName().equals("userAttributes")) {
                userAttributes = ActivityModelXMLImportTools.getUserAttributes(child);
            }
            child = ActivityModelXMLImportTools.getElement(child.getNextSibling());
        }
        return amf.createCSReference(name, description, revision, state, operationNames, pluginData, userAttributes);
    }

    static StorageExecutableComponentDescription getStorageExecutableComponentDescription(ActivityModelFactory amf, Element element) {
        Element child = ActivityModelXMLImportTools.getElement(element.getFirstChild());
        String name = child.getTextContent();
        child = ActivityModelXMLImportTools.getElement(child.getNextSibling());
        String developerDescription = child.getTextContent();
        child = ActivityModelXMLImportTools.getElement(child.getNextSibling());
        long revision = Long.parseLong(child.getTextContent());
        child = ActivityModelXMLImportTools.getElement(child.getNextSibling());
        State state = ActivityModelXMLImportTools.getState(child.getTextContent());
        child = ActivityModelXMLImportTools.getElement(child.getNextSibling());
        String implementationClass = child.getTextContent();
        child = ActivityModelXMLImportTools.getElement(child.getNextSibling());
        List<String> classPath = null;
        Boolean isSingleton = null;
        byte[] systemComponentSignature = null;
        String guiContextID = null;
        ExecutionControlProperties executionControlProperties = null;
        UUID iconID = null;
        String licenceInformation = null;
        StorageConfigurationDescription configurationDescription = null;
        Collection<StorageParameterTemplate> parameterTemplates = null;
        PluginDataContainer pluginData = null;
        Map<String, String> userAttributes = null;
        while (child != null) {
            if (child.getTagName().equals("classPaths")) {
                classPath = ActivityModelXMLImportTools.getClassPath(child);
            } else if (child.getTagName().equals("isSingleton")) {
                isSingleton = Boolean.parseBoolean(child.getTextContent());
            } else if (child.getTagName().equals("systemComponent")) {
                systemComponentSignature = Base64.decode(child.getTextContent());
            } else if (child.getTagName().equals("guiContextID")) {
                guiContextID = child.getTextContent();
            } else if (child.getTagName().equals("executionControlProperties")) {
                executionControlProperties = ActivityModelXMLImportTools.getExecutionControlProperties(child);
            } else if (child.getTagName().equals("iconID")) {
                iconID = UUID.fromString(child.getTextContent());
            } else if (child.getTagName().equals("licenceInformation")) {
                licenceInformation = child.getTextContent();
            } else if (child.getTagName().equals("configurationDescription")) {
                configurationDescription = ActivityModelXMLImportTools.getStorageConfigurationDescription(amf, child);
            } else if (child.getTagName().equals("parameterTemplates")) {
                parameterTemplates = ActivityModelXMLImportTools.getParameterTemplates(amf, child, false).values();
            } else if (child.getTagName().equals("pluginDataContainer")) {
                pluginData = ActivityModelXMLImportTools.getPluginDataContainer(amf, child);
            } else if (child.getTagName().equals("userAttributes")) {
                userAttributes = ActivityModelXMLImportTools.getUserAttributes(child);
            }
            child = ActivityModelXMLImportTools.getElement(child.getNextSibling());
        }
        return amf.createStorageExecutableComponentDescription(name, developerDescription, revision, state, implementationClass, classPath, isSingleton, systemComponentSignature, guiContextID, executionControlProperties, iconID, licenceInformation, configurationDescription, parameterTemplates, pluginData, userAttributes);
    }

    static ECDReference getECDReference(ActivityModelFactory amf, Element element) {
        Element child = ActivityModelXMLImportTools.getElement(element.getFirstChild());
        String name = child.getTextContent();
        child = ActivityModelXMLImportTools.getElement(child.getNextSibling());
        String developerDescription = child.getTextContent();
        child = ActivityModelXMLImportTools.getElement(child.getNextSibling());
        long revision = Long.parseLong(child.getTextContent());
        child = ActivityModelXMLImportTools.getElement(child.getNextSibling());
        State state = ActivityModelXMLImportTools.getState(child.getTextContent());
        child = ActivityModelXMLImportTools.getElement(child.getNextSibling());
        UUID iconID = null;
        PluginDataContainer pluginData = null;
        Map<String, String> userAttributes = null;
        while (child != null) {
            if (child.getTagName().equals("iconID")) {
                iconID = UUID.fromString(child.getTextContent());
            } else if (child.getTagName().equals("pluginDataContainer")) {
                pluginData = ActivityModelXMLImportTools.getPluginDataContainer(amf, child);
            } else if (child.getTagName().equals("userAttributes")) {
                userAttributes = ActivityModelXMLImportTools.getUserAttributes(child);
            }
            child = ActivityModelXMLImportTools.getElement(child.getNextSibling());
        }
        return amf.createECDReference(name, developerDescription, revision, state, iconID, pluginData, userAttributes);
    }

    static Identifier getIdentifier(ActivityModelFactory amf, Element identifierElement) {
        UUID id = UUID.fromString(identifierElement.getAttribute("id"));
        Element child = ActivityModelXMLImportTools.getElement(identifierElement.getFirstChild());
        String name = child.getTextContent();
        child = ActivityModelXMLImportTools.getElement(child.getNextSibling());
        String description = child.getTextContent();
        child = ActivityModelXMLImportTools.getElement(child.getNextSibling());
        long revision = Long.parseLong(child.getTextContent());
        child = ActivityModelXMLImportTools.getElement(child.getNextSibling());
        State state = ActivityModelXMLImportTools.getState(child.getTextContent());
        child = ActivityModelXMLImportTools.getElement(child.getNextSibling());
        PluginDataContainer pluginData = null;
        Map<String, String> userAttributes = null;
        while (child != null) {
            if (child.getTagName().equals("pluginDataContainer")) {
                pluginData = ActivityModelXMLImportTools.getPluginDataContainer(amf, child);
            } else if (child.getTagName().equals("userAttributes")) {
                userAttributes = ActivityModelXMLImportTools.getUserAttributes(child);
            }
            child = ActivityModelXMLImportTools.getElement(child.getNextSibling());
        }
        return amf.createIdentifier(id, name, description, revision, state, pluginData, userAttributes);
    }

    static StorageOperation getStorageOperation(ActivityModelFactory amf, Element element) {
        Element child = ActivityModelXMLImportTools.getElement(element.getFirstChild());
        String ecdName = child.getTextContent();
        child = ActivityModelXMLImportTools.getElement(child.getNextSibling());
        String name = child.getTextContent();
        child = ActivityModelXMLImportTools.getElement(child.getNextSibling());
        String description = child.getTextContent();
        child = ActivityModelXMLImportTools.getElement(child.getNextSibling());
        String developerDescription = null;
        long revision = 0L;
        State state = null;
        String implementationClass = null;
        List<String> classPath = null;
        Boolean isSingleton = null;
        byte[] systemComponentSignature = null;
        String guiContextID = null;
        ExecutionControlProperties executionControlProperties = null;
        boolean supportsViewOnly = false;
        boolean supportsTestExecution = false;
        UUID iconID = null;
        String licenceInformation = null;
        StorageConfigurationDescription configurationDescription = null;
        StorageActivityConfiguration configuration = null;
        StorageActivityConfiguration testConfiguration = null;
        ParameterChangePolicy parameterChangePolicy = null;
        Collection<StorageActivityModelParameter> inputParameters = null;
        Collection<StorageActivityModelParameter> outputParameters = null;
        Map<String, StorageParameterTemplate> parameterTemplates = null;
        String staffAssignmentRule = null;
        PluginDataContainer pluginData = null;
        Map<String, String> userAttributes = null;
        while (child != null) {
            if (child.getTagName().equals("developerDescription")) {
                developerDescription = child.getTextContent();
            } else if (child.getTagName().equals("revision")) {
                revision = Long.parseLong(child.getTextContent());
            } else if (child.getTagName().equals("state")) {
                state = ActivityModelXMLImportTools.getState(child.getTextContent());
            } else if (child.getTagName().equals("implementationClass")) {
                implementationClass = child.getTextContent();
            } else if (child.getTagName().equals("ownClassPaths")) {
                classPath = ActivityModelXMLImportTools.getClassPath(child);
            } else if (child.getTagName().equals("isSingleton")) {
                isSingleton = Boolean.parseBoolean(child.getTextContent());
            } else if (child.getTagName().equals("systemComponent")) {
                systemComponentSignature = Base64.decode(child.getTextContent());
            } else if (child.getTagName().equals("guiContextID")) {
                guiContextID = child.getTextContent();
            } else if (child.getTagName().equals("executionControlProperties")) {
                executionControlProperties = ActivityModelXMLImportTools.getExecutionControlProperties(child);
            } else if (child.getTagName().equals("supportsViewOnly")) {
                supportsViewOnly = Boolean.parseBoolean(child.getTextContent());
            } else if (child.getTagName().equals("supportsTestExecution")) {
                supportsTestExecution = Boolean.parseBoolean(child.getTextContent());
            } else if (child.getTagName().equals("iconID")) {
                iconID = UUID.fromString(child.getTextContent());
            } else if (child.getTagName().equals("licenceInformation")) {
                licenceInformation = child.getTextContent();
            } else if (child.getTagName().equals("configurationDescription")) {
                configurationDescription = ActivityModelXMLImportTools.getStorageConfigurationDescription(amf, child);
            } else if (child.getTagName().equals("configuration")) {
                configuration = ActivityModelXMLImportTools.getStorageActivityConfiguration(amf, child);
            } else if (child.getTagName().equals("testConfiguration")) {
                testConfiguration = ActivityModelXMLImportTools.getStorageActivityConfiguration(amf, child);
            } else if (child.getTagName().equals("parameterChangePolicy")) {
                parameterChangePolicy = ParameterChangePolicy.valueOf(child.getTextContent());
            } else if (child.getTagName().equals("inputParameters")) {
                inputParameters = ActivityModelXMLImportTools.getParameters(amf, child).values();
            } else if (child.getTagName().equals("outputParameters")) {
                outputParameters = ActivityModelXMLImportTools.getParameters(amf, child).values();
            } else if (child.getTagName().equals("parameterTemplates")) {
                parameterTemplates = ActivityModelXMLImportTools.getParameterTemplates(amf, child, false);
            } else if (child.getTagName().equals("staffAssignmentRule")) {
                staffAssignmentRule = child.getTextContent();
            } else if (child.getTagName().equals("pluginDataContainer")) {
                pluginData = ActivityModelXMLImportTools.getPluginDataContainer(amf, child);
            } else if (child.getTagName().equals("userAttributes")) {
                userAttributes = ActivityModelXMLImportTools.getUserAttributes(child);
            }
            child = ActivityModelXMLImportTools.getElement(child.getNextSibling());
        }
        return amf.createStorageOperation(ecdName, name, description, developerDescription, revision, state, implementationClass, classPath, isSingleton, systemComponentSignature, guiContextID, executionControlProperties, supportsViewOnly, supportsTestExecution, iconID, licenceInformation, configurationDescription, configuration, testConfiguration, parameterChangePolicy, inputParameters, outputParameters, parameterTemplates, staffAssignmentRule, pluginData, userAttributes);
    }

    static OperationReference getOperationReference(ActivityModelFactory amf, Element element) {
        Element child = ActivityModelXMLImportTools.getElement(element.getFirstChild());
        String executableComponentDescriptionName = child.getTextContent();
        child = ActivityModelXMLImportTools.getElement(child.getNextSibling());
        String name = child.getTextContent();
        child = ActivityModelXMLImportTools.getElement(child.getNextSibling());
        String description = child.getTextContent();
        child = ActivityModelXMLImportTools.getElement(child.getNextSibling());
        String developerDescription = child.getTextContent();
        child = ActivityModelXMLImportTools.getElement(child.getNextSibling());
        long revision = Long.parseLong(child.getTextContent());
        child = ActivityModelXMLImportTools.getElement(child.getNextSibling());
        State state = ActivityModelXMLImportTools.getState(child.getTextContent());
        child = ActivityModelXMLImportTools.getElement(child.getNextSibling());
        UUID iconID = null;
        PluginDataContainer pluginData = null;
        Map<String, String> userAttributes = null;
        while (child != null) {
            if (child.getTagName().equals("iconID")) {
                iconID = UUID.fromString(child.getTextContent());
            } else if (child.getTagName().equals("pluginDataContainer")) {
                pluginData = ActivityModelXMLImportTools.getPluginDataContainer(amf, child);
            } else if (child.getTagName().equals("userAttributes")) {
                userAttributes = ActivityModelXMLImportTools.getUserAttributes(child);
            }
            child = ActivityModelXMLImportTools.getElement(child.getNextSibling());
        }
        return amf.createOperationReference(executableComponentDescriptionName, name, description, developerDescription, revision, state, iconID, pluginData, userAttributes);
    }

    static StorageParameterTemplate getParameterTemplate(ActivityModelFactory amf, Element templateElement) {
        Element child = ActivityModelXMLImportTools.getElement(templateElement.getFirstChild());
        String templateName = child.getTextContent();
        child = ActivityModelXMLImportTools.getElement(child.getNextSibling());
        String templateDescription = null;
        ActivityConstants.AccessType accessType = null;
        String name = null;
        String description = null;
        ProcessConstants.AdeptDataType dataType = null;
        String udtName = null;
        UUID identifierID = null;
        Boolean isOptional = null;
        Boolean isVirtual = null;
        Boolean isFailure = null;
        String defaultValue = null;
        StorageConfigurationDescription configurationDescription = null;
        StorageConfiguration configuration = null;
        PluginDataContainer pluginData = null;
        Map<String, String> userAttributes = null;
        while (child != null) {
            if (child.getTagName().equals("templateDescription")) {
                templateDescription = child.getTextContent();
            } else if (child.getTagName().equals("accessType")) {
                accessType = ActivityConstants.AccessType.valueOf(child.getTextContent());
            } else if (child.getTagName().equals("name")) {
                name = child.getTextContent();
            } else if (child.getTagName().equals("description")) {
                description = child.getTextContent();
            } else if (child.getTagName().equals("type")) {
                dataType = ProcessConstants.AdeptDataType.valueOf(child.getTextContent());
            } else if (child.getTagName().equals("udtName")) {
                udtName = child.getTextContent();
            } else if (child.getTagName().equals("identifierID")) {
                identifierID = UUID.fromString(child.getTextContent());
            } else if (child.getTagName().equals("isOptional")) {
                isOptional = Boolean.valueOf(child.getTextContent());
            } else if (child.getTagName().equals("isVirtual")) {
                isVirtual = Boolean.valueOf(child.getTextContent());
            } else if (child.getTagName().equals("isFailure")) {
                isFailure = Boolean.valueOf(child.getTextContent());
            } else if (child.getTagName().equals("defaultValue")) {
                defaultValue = child.getTextContent();
            } else if (child.getTagName().equals("configurationDescription")) {
                configurationDescription = ActivityModelXMLImportTools.getStorageConfigurationDescription(amf, child);
            } else if (child.getTagName().equals("configuration")) {
                configuration = ActivityModelXMLImportTools.getStorageConfiguration(amf, child);
            } else if (child.getTagName().equals("pluginDataContainer")) {
                pluginData = ActivityModelXMLImportTools.getPluginDataContainer(amf, child);
            } else if (child.getTagName().equals("userAttributes")) {
                userAttributes = ActivityModelXMLImportTools.getUserAttributes(child);
            }
            child = ActivityModelXMLImportTools.getElement(child.getNextSibling());
        }
        return amf.createStorageParameterTemplate(templateName, templateDescription, accessType, name, description, dataType, udtName, identifierID, isOptional, isVirtual, isFailure, defaultValue, configurationDescription, configuration, pluginData, userAttributes);
    }

    static ATParameterTemplate getATParameterTemplate(ActivityModelFactory amf, Element templateElement) {
        Element child = ActivityModelXMLImportTools.getElement(templateElement.getFirstChild());
        String templateName = child.getTextContent();
        child = ActivityModelXMLImportTools.getElement(child.getNextSibling());
        String templateDescription = null;
        ActivityConstants.AccessType accessType = null;
        String name = null;
        String description = null;
        ProcessConstants.AdeptDataType dataType = null;
        String udtName = null;
        UUID identifierID = null;
        Boolean isOptional = null;
        Boolean isVirtual = null;
        Boolean isFailure = null;
        String defaultValue = null;
        ConfigurationDescription configurationDescription = null;
        Configuration configuration = null;
        PluginDataContainer pluginData = null;
        Map<String, String> userAttributes = null;
        while (child != null) {
            if (child.getTagName().equals("templateDescription")) {
                templateDescription = child.getTextContent();
            } else if (child.getTagName().equals("accessType")) {
                accessType = ActivityConstants.AccessType.valueOf(child.getTextContent());
            } else if (child.getTagName().equals("name")) {
                name = child.getTextContent();
            } else if (child.getTagName().equals("description")) {
                description = child.getTextContent();
            } else if (child.getTagName().equals("type")) {
                dataType = ProcessConstants.AdeptDataType.valueOf(child.getTextContent());
            } else if (child.getTagName().equals("udtName")) {
                udtName = child.getTextContent();
            } else if (child.getTagName().equals("identifierID")) {
                identifierID = UUID.fromString(child.getTextContent());
            } else if (child.getTagName().equals("isOptional")) {
                isOptional = Boolean.valueOf(child.getTextContent());
            } else if (child.getTagName().equals("isVirtual")) {
                isVirtual = Boolean.valueOf(child.getTextContent());
            } else if (child.getTagName().equals("isFailure")) {
                isFailure = Boolean.valueOf(child.getTextContent());
            } else if (child.getTagName().equals("defaultValue")) {
                defaultValue = child.getTextContent();
            } else if (child.getTagName().equals("configurationDescription")) {
                configurationDescription = ActivityModelXMLImportTools.getConfigurationDescription(amf, child);
            } else if (child.getTagName().equals("configuration")) {
                configuration = ActivityModelXMLImportTools.getConfiguration(amf, child);
            } else if (child.getTagName().equals("pluginDataContainer")) {
                pluginData = ActivityModelXMLImportTools.getPluginDataContainer(amf, child);
            } else if (child.getTagName().equals("userAttributes")) {
                userAttributes = ActivityModelXMLImportTools.getUserAttributes(child);
            }
            child = ActivityModelXMLImportTools.getElement(child.getNextSibling());
        }
        return amf.createATParameterTemplate(templateName, templateDescription, accessType, name, description, dataType, udtName, identifierID, isOptional, isVirtual, isFailure, defaultValue, configurationDescription, configuration, pluginData, userAttributes);
    }

    private static Map<String, StorageActivityModelParameter> getParameters(ActivityModelFactory amf, Element parameterElement) {
        HashMap<String, StorageActivityModelParameter> parameters = new HashMap<String, StorageActivityModelParameter>();
        Element child = ActivityModelXMLImportTools.getElement(parameterElement.getFirstChild());
        while (child != null) {
            StorageActivityModelParameter param = ActivityModelXMLImportTools.getActivityModelParameter(amf, child);
            parameters.put(param.getName(), param);
            child = ActivityModelXMLImportTools.getElement(child.getNextSibling());
        }
        return parameters;
    }

    private static Collection<ATParameter> getATParameters(ActivityModelFactory amf, Element parameterElement) {
        HashSet<ATParameter> parameters = new HashSet<ATParameter>();
        Element child = ActivityModelXMLImportTools.getElement(parameterElement.getFirstChild());
        while (child != null) {
            parameters.add(ActivityModelXMLImportTools.getATParameter(amf, child));
            child = ActivityModelXMLImportTools.getElement(child.getNextSibling());
        }
        return parameters;
    }

    private static Map<String, StorageParameterTemplate> getParameterTemplates(ActivityModelFactory amf, Element templatesElement, boolean inherited) {
        HashMap<String, StorageParameterTemplate> templates = new HashMap<String, StorageParameterTemplate>();
        Element child = ActivityModelXMLImportTools.getElement(templatesElement.getFirstChild());
        while (child != null) {
            String name;
            if (ActivityModelXMLImportTools.getElement(child.getFirstChild()) == null) {
                name = child.getTextContent();
                if (inherited) {
                    templates.put(name, null);
                }
            } else {
                StorageParameterTemplate template = ActivityModelXMLImportTools.getParameterTemplate(amf, child);
                name = template.getTemplateName();
                templates.put(name, template);
            }
            child = ActivityModelXMLImportTools.getElement(child.getNextSibling());
        }
        return templates;
    }

    private static Map<String, ATParameterTemplate> getATParameterTemplates(ActivityModelFactory amf, Element templatesElement, boolean inherited) {
        HashMap<String, ATParameterTemplate> templates = new HashMap<String, ATParameterTemplate>();
        Element child = ActivityModelXMLImportTools.getElement(templatesElement.getFirstChild());
        while (child != null) {
            String name;
            if (ActivityModelXMLImportTools.getElement(child.getFirstChild()) == null) {
                name = child.getTextContent();
                if (inherited) {
                    templates.put(name, null);
                }
            } else {
                ATParameterTemplate template = ActivityModelXMLImportTools.getATParameterTemplate(amf, child);
                name = template.getTemplateName();
                templates.put(name, template);
            }
            child = ActivityModelXMLImportTools.getElement(child.getNextSibling());
        }
        return templates;
    }

    private static Collection<Identifier> getIdentifiers(ActivityModelFactory amf, Element identifiersElement) {
        HashSet<Identifier> identifiers = new HashSet<Identifier>();
        Element child = ActivityModelXMLImportTools.getElement(identifiersElement.getFirstChild());
        while (child != null) {
            identifiers.add(ActivityModelXMLImportTools.getIdentifier(amf, child));
            child = ActivityModelXMLImportTools.getElement(child.getNextSibling());
        }
        return identifiers;
    }

    private static IconDescriptor.Dimension getDimension(Element dimension) {
        int width = Integer.parseInt(dimension.getAttribute("width"));
        int height = Integer.parseInt(dimension.getAttribute("height"));
        return new IconDescriptor.Dimension(width, height);
    }

    private static State getState(String stateString) {
        if (stateString.equals("UNDER_CONSTRUCTION")) {
            return State.IN_DEVELOPMENT;
        }
        return State.valueOf(stateString);
    }
}

