/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.activitymodelbak.defaultimplementation;

import de.aristaflow.adept2.model.activitymodelbak.OldComponentConfiguration;
import de.aristaflow.adept2.model.activitymodelbak.OldVersion;
import de.aristaflow.adept2.model.common.PluginData;
import de.aristaflow.adept2.model.common.defaultimplementation.SerialisablePluginDataContainer;
import de.aristaflow.adept2.util.NullArgumentException;
import de.aristaflow.adept2.util.UUIDTools;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class DefaultComponentConfiguration
extends SerialisablePluginDataContainer
implements OldComponentConfiguration {
    private static final long serialVersionUID = -2316485642116397918L;
    protected UUID versionID;
    protected UUID componentVersionID = UUIDTools.createRandomUUID();
    protected UUID componentConfigurationID;
    protected String name = "";
    protected OldVersion version;
    protected Map<String, String> applicationConfiguration;
    protected Map<String, Map<String, String>> activityTypeConfiguration;
    protected Map<String, Map<String, String>> testActivityTypeConfiguration;
    protected Map<String, String> testApplicationConfiguration;
    protected String configurationNamespace = "";

    protected DefaultComponentConfiguration(UUID versionID, UUID componentVersionID, UUID componentConfigurationID, String name, OldVersion version, Map<String, String> applicationConfiguration, Map<String, Map<String, String>> activityTypeConfiguration, Map<String, String> testApplicationConfiguration, Map<String, Map<String, String>> testActivityTypeConfiguration, String configurationNameSpace, Map<String, Set<String>> supportedPlugins, Map<String, PluginData> pluginData, Map<String, String> userAttributes) {
        this();
        this.componentVersionID = componentVersionID;
        this.versionID = versionID;
        this.componentConfigurationID = componentConfigurationID;
        this.name = name != null ? name : "";
        this.version = version != null ? version : new OldVersion(0, 0, 0);
        this.applicationConfiguration = applicationConfiguration != null ? applicationConfiguration : new HashMap<String, String>();
        this.activityTypeConfiguration = activityTypeConfiguration != null ? activityTypeConfiguration : new HashMap<String, Map<String, String>>();
        this.testApplicationConfiguration = testApplicationConfiguration != null ? testApplicationConfiguration : new HashMap<String, String>();
        this.testActivityTypeConfiguration = testActivityTypeConfiguration != null ? testActivityTypeConfiguration : new HashMap<String, Map<String, String>>();
        this.configurationNamespace = configurationNameSpace != null ? configurationNameSpace : "";
        if (supportedPlugins != null) {
            for (Map.Entry<String, Set<String>> pdcEntry : supportedPlugins.entrySet()) {
                for (String pluginID : pdcEntry.getValue()) {
                    if (!pluginData.containsKey(pluginID)) continue;
                    this.addSupportedPlugin(pdcEntry.getKey(), pluginID, pluginData.get(pluginID));
                }
            }
        }
        if (userAttributes != null) {
            this.setUserAttributes(userAttributes);
        } else {
            this.setUserAttributes(new HashMap<String, String>());
        }
    }

    DefaultComponentConfiguration() {
        this.versionID = UUIDTools.createRandomUUID();
        this.componentConfigurationID = UUIDTools.createRandomUUID();
        this.version = new OldVersion(0, 0, 0);
        this.applicationConfiguration = new HashMap<String, String>();
        this.activityTypeConfiguration = new HashMap<String, Map<String, String>>();
        this.testActivityTypeConfiguration = new HashMap<String, Map<String, String>>();
        this.testApplicationConfiguration = new HashMap<String, String>();
    }

    @Override
    public UUID getComponentVersionID() {
        return this.componentVersionID;
    }

    @Override
    public void setComponentVersionID(UUID componentVersionID) {
        this.componentVersionID = componentVersionID;
    }

    @Override
    public UUID getVersionID() {
        return this.versionID;
    }

    @Override
    public void setVersionID(UUID versionID) {
        this.versionID = versionID;
    }

    @Override
    public UUID getComponentConfigurationID() {
        return this.componentConfigurationID;
    }

    @Override
    public void setComponentConfigurationID(UUID configurationID) {
        this.componentConfigurationID = configurationID;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.checkForIllegalNullArgument(name, "name");
        this.name = name;
    }

    @Override
    public OldVersion getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(OldVersion version) {
        this.checkForIllegalNullArgument(version, "version");
        this.version = version;
    }

    @Override
    public Map<String, String> getApplicationConfiguration() {
        return Collections.unmodifiableMap(this.applicationConfiguration);
    }

    @Override
    public void setApplicationConfigurationField(String name, String value) {
        this.checkForIllegalNullArgument(name, "name");
        this.checkForIllegalNullArgument(value, "value");
        if (!(this.applicationConfiguration instanceof HashMap)) {
            this.applicationConfiguration = new HashMap<String, String>();
        }
        this.applicationConfiguration.put(name, value);
    }

    @Override
    public void removeApplicationConfigurationField(String name) {
        this.applicationConfiguration.remove(name);
    }

    @Override
    public Map<String, Map<String, String>> getActivityTypeConfigurations() {
        return Collections.unmodifiableMap(this.activityTypeConfiguration);
    }

    @Override
    public void setActivityTypeConfigurationField(String activityType, String name, String value) {
        this.checkForIllegalNullArgument(activityType, "activityType");
        this.checkForIllegalNullArgument(name, "name");
        this.checkForIllegalNullArgument(value, "value");
        if (!(this.activityTypeConfiguration instanceof HashMap)) {
            this.activityTypeConfiguration = new HashMap<String, Map<String, String>>();
        }
        if (this.activityTypeConfiguration.containsKey(activityType)) {
            this.activityTypeConfiguration.get(activityType).put(name, value);
        } else {
            HashMap<String, String> activityTypeConf = new HashMap<String, String>();
            activityTypeConf.put(name, value);
            this.activityTypeConfiguration.put(activityType, activityTypeConf);
        }
    }

    @Override
    public void removeActivityTypeConfiguration(String activityTypeID) {
        this.activityTypeConfiguration.remove(activityTypeID);
    }

    @Override
    public void removeActivityTypeConfigurationField(String activityType, String name) {
        if (this.activityTypeConfiguration.containsKey(activityType)) {
            this.activityTypeConfiguration.get(activityType).remove(name);
        }
    }

    @Override
    public String getConfigurationNamespace() {
        return this.configurationNamespace;
    }

    @Override
    public void setConfigurationNamespace(String nameSpace) {
        this.checkForIllegalNullArgument(nameSpace, "nameSpace");
        this.configurationNamespace = nameSpace;
    }

    @Override
    public Map<String, Map<String, String>> getTestActivityTypeConfigurations() {
        return Collections.unmodifiableMap(this.testActivityTypeConfiguration);
    }

    @Override
    public void setTestActivityTypeConfigurationField(String activityType, String name, String value) {
        this.checkForIllegalNullArgument(activityType, "activityType");
        this.checkForIllegalNullArgument(name, "name");
        this.checkForIllegalNullArgument(value, "value");
        if (!(this.testActivityTypeConfiguration instanceof HashMap)) {
            this.testActivityTypeConfiguration = new HashMap<String, Map<String, String>>();
        }
        if (this.testActivityTypeConfiguration.containsKey(activityType)) {
            this.testActivityTypeConfiguration.get(activityType).put(name, value);
        } else {
            HashMap<String, String> activityTypeConf = new HashMap<String, String>();
            activityTypeConf.put(name, value);
            this.testActivityTypeConfiguration.put(activityType, activityTypeConf);
        }
    }

    @Override
    public void removeTestActivityTypeConfiguration(String activityTypeID) {
        this.testActivityTypeConfiguration.remove(activityTypeID);
    }

    @Override
    public void removeTestActivityTypeConfigurationField(String activityType, String name) {
        if (this.testActivityTypeConfiguration.containsKey(activityType)) {
            this.testActivityTypeConfiguration.get(activityType).remove(name);
        }
    }

    @Override
    public Map<String, String> getTestApplicationConfiguration() {
        return Collections.unmodifiableMap(this.testApplicationConfiguration);
    }

    @Override
    public void setTestApplicationConfigurationField(String name, String value) {
        this.checkForIllegalNullArgument(name, "name");
        this.checkForIllegalNullArgument(value, "value");
        if (!(this.testApplicationConfiguration instanceof HashMap)) {
            this.testApplicationConfiguration = new HashMap<String, String>();
        }
        this.testApplicationConfiguration.put(name, value);
    }

    @Override
    public void removeTestApplicationConfigurationField(String name) {
        this.testApplicationConfiguration.remove(name);
    }

    private void checkForIllegalNullArgument(Object argument, String parameterName) {
        if (argument == null) {
            throw new NullArgumentException("The parameter '" + parameterName + "' must not be null.");
        }
    }
}

