/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.common;

import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.model.common.Revision;
import de.aristaflow.adept2.model.common.filter.UseInFilter;
import de.aristaflow.adept2.util.ArgChecks;
import java.io.Serializable;

public class Branch
implements Serializable {
    private static final long serialVersionUID = 2819033293457986251L;
    protected final long branch;
    protected final Revision baseRevision;
    protected final long creationTime;
    protected final QualifiedAgent creationAgent;
    protected final long modTime;
    protected final QualifiedAgent modAgent;
    protected final String comment;

    public Branch(long branch, Revision baseRevision, long creationTime, QualifiedAgent creationAgent, long modTime, QualifiedAgent modAgent, String comment) {
        ArgChecks.checkForNegative(branch, "branch");
        ArgChecks.checkForNull(baseRevision, "revision");
        ArgChecks.checkForNull(creationAgent, "creationAgent");
        ArgChecks.checkForNull(modAgent, "modAgent");
        ArgChecks.checkForNull(comment, "comment");
        this.branch = branch;
        this.baseRevision = baseRevision;
        this.creationTime = creationTime;
        this.creationAgent = creationAgent;
        this.modTime = modTime;
        this.modAgent = modAgent;
        this.comment = comment;
    }

    @UseInFilter
    public long getBranch() {
        return this.branch;
    }

    @UseInFilter
    public Revision getBaseRevision() {
        return this.baseRevision;
    }

    @UseInFilter
    public long getCreationTime() {
        return this.creationTime;
    }

    @UseInFilter
    public QualifiedAgent getCreationAgent() {
        return this.creationAgent;
    }

    @UseInFilter
    public long getModificationTime() {
        return this.modTime;
    }

    @UseInFilter
    public QualifiedAgent getModificationAgent() {
        return this.modAgent;
    }

    @UseInFilter
    public String getComment() {
        return this.comment;
    }
}

