/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.common;

import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.model.common.State;
import de.aristaflow.adept2.model.common.UserAttributeContainer;
import de.aristaflow.adept2.model.common.filter.UseInFilter;
import de.aristaflow.adept2.model.common.i18n.Localised;
import de.aristaflow.adept2.util.ArgChecks;
import java.io.Serializable;
import java.util.UUID;

public interface IconDescriptor
extends UserAttributeContainer,
PluginDataContainer {
    public UUID getID();

    @UseInFilter
    @Localised(value="Name")
    public String getName();

    @UseInFilter
    @Localised(value="Description")
    public String getDescription();

    public Dimension[] getDimensions();

    @UseInFilter
    public long getRevision();

    @UseInFilter
    public State getState();

    public static class Dimension
    implements Serializable {
        private static final long serialVersionUID = 2136165944759718695L;
        public final int width;
        public final int height;

        public Dimension(int width, int height) {
            ArgChecks.checkForNonpositive(width, "width");
            ArgChecks.checkForNonpositive(height, "height");
            this.width = width;
            this.height = height;
        }

        public boolean equals(Object other) {
            boolean ret = false;
            if (other instanceof Dimension) {
                Dimension otherDim = (Dimension)other;
                ret = this.width == otherDim.width && this.height == otherDim.height;
            }
            return ret;
        }

        public int hashCode() {
            return this.width ^ this.height;
        }

        public String toString() {
            return String.format("%s*%s", this.width, this.height);
        }
    }
}

