/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.common;

import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.model.common.ActivityConfiguration;
import de.aristaflow.adept2.model.common.Configuration;
import de.aristaflow.adept2.model.common.ConfigurationDescription;
import de.aristaflow.adept2.model.common.ExecutionControlProperties;
import de.aristaflow.adept2.model.common.PluginData;
import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLExportTools {
    public static Element createConfigurationElement(Document doc, String ns, Configuration conf, String type, String ecd, String operation) {
        Element confElement = doc.createElementNS(ns, type);
        if (ecd != null) {
            confElement.setAttributeNS(null, "ecd", ecd);
        }
        if (operation != null) {
            confElement.setAttributeNS(null, "operation", operation);
        }
        for (String entry : conf.getAllEntries()) {
            Element confEntry = doc.createElementNS(ns, "configurationEntry");
            confEntry.setAttributeNS(null, "name", entry);
            confEntry.setAttributeNS(null, "fixed", Boolean.toString(conf.isFixed(entry)));
            if (conf instanceof ActivityConfiguration && ((ActivityConfiguration)conf).fromInputParameter(entry) != null) {
                confEntry.setAttributeNS(null, "fromParameter", ((ActivityConfiguration)conf).fromInputParameter(entry));
            } else if (conf instanceof ActivityConfiguration && ((ActivityConfiguration)conf).fromProcessConfiguration(entry) != null) {
                confEntry.setAttributeNS(null, "fromConfiguration", ((ActivityConfiguration)conf).fromProcessConfiguration(entry));
            } else {
                String value = conf.getString(entry);
                if (value == null) {
                    confEntry.setAttributeNS(null, "isNull", Boolean.TRUE.toString());
                } else {
                    confEntry.setTextContent(value);
                }
            }
            confElement.appendChild(confEntry);
        }
        return confElement;
    }

    public static Element createConfigurationDescriptionElement(Document doc, String ns, ConfigurationDescription confDesc, String ecd, String operation) {
        Element confDescElement = doc.createElementNS(ns, "configurationDescription");
        if (ecd != null) {
            confDescElement.setAttributeNS(null, "ecd", ecd);
        }
        if (operation != null) {
            confDescElement.setAttributeNS(null, "operation", operation);
        }
        for (Map.Entry<String, ConfigurationDescription.ConfigurationEntry> entry : confDesc.getEntries().entrySet()) {
            confDescElement.appendChild(XMLExportTools.createConfigurationEntryElement(doc, ns, entry.getKey(), entry.getValue()));
        }
        return confDescElement;
    }

    public static Element createConfigurationEntryElement(Document doc, String ns, String name, ConfigurationDescription.ConfigurationEntry confEntry) {
        Element confEntryElement = doc.createElementNS(ns, "configurationEntry");
        confEntryElement.setAttributeNS(null, "name", name);
        if (confEntry != null) {
            XMLExportTools.addElement(doc, ns, confEntryElement, "description", confEntry.getDescription());
            XMLExportTools.addElement(doc, ns, confEntryElement, "dataType", confEntry.getDataType().name());
            XMLExportTools.addElement(doc, ns, confEntryElement, "isOptional", Boolean.toString(confEntry.isOptional()));
            String[] stringArray = confEntry.getRestrictions();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String restriction = stringArray[n2];
                XMLExportTools.addElement(doc, ns, confEntryElement, "restriction", restriction);
                ++n2;
            }
            if (confEntry.getSupportedPlugins().size() > 0) {
                confEntryElement.appendChild(XMLExportTools.createPluginDataContainerElement(doc, ns, confEntry));
            }
            if (confEntry.getUserAttributes().size() > 0) {
                confEntryElement.appendChild(XMLExportTools.createUserAttributesElement(doc, ns, confEntry.getUserAttributes()));
            }
        }
        return confEntryElement;
    }

    public static Element createClassPathElement(Document doc, String ns, String parent, List<String> classPaths) {
        Element classPathsElement = doc.createElementNS(ns, parent);
        for (String classPath : classPaths) {
            XMLExportTools.addElement(doc, ns, classPathsElement, "classPath", classPath);
        }
        return classPathsElement;
    }

    public static Element createSeparatedClassPathElement(Document doc, String ns, String parent, Map<ActivityConstants.ActivityModelEntityType, List<String>> map) {
        Element classPathsElement = doc.createElementNS(ns, parent);
        for (String classPath : map.get((Object)ActivityConstants.ActivityModelEntityType.ATD)) {
            XMLExportTools.addElement(doc, ns, classPathsElement, "classPath", classPath, ActivityConstants.ActivityModelEntityType.ATD);
        }
        for (String classPath : map.get((Object)ActivityConstants.ActivityModelEntityType.OPERATION)) {
            XMLExportTools.addElement(doc, ns, classPathsElement, "classPath", classPath, ActivityConstants.ActivityModelEntityType.OPERATION);
        }
        for (String classPath : map.get((Object)ActivityConstants.ActivityModelEntityType.ECD)) {
            XMLExportTools.addElement(doc, ns, classPathsElement, "classPath", classPath, ActivityConstants.ActivityModelEntityType.ECD);
        }
        return classPathsElement;
    }

    public static Element createExecutionControlPropertiesElement(Document document, String ns, ExecutionControlProperties executionControlProperties) {
        Element ecpElement = document.createElementNS(ns, "executionControlProperties");
        Element isSuspensibleElement = document.createElementNS(ns, "isSuspensible");
        isSuspensibleElement.setTextContent(Boolean.toString(executionControlProperties.isSuspensible()));
        ecpElement.appendChild(isSuspensibleElement);
        Element isResetableElement = document.createElementNS(ns, "isResettable");
        isResetableElement.setTextContent(Boolean.toString(executionControlProperties.isResettable()));
        ecpElement.appendChild(isResetableElement);
        Element isClosableElement = document.createElementNS(ns, "isClosable");
        isClosableElement.setTextContent(Boolean.toString(executionControlProperties.isClosable()));
        ecpElement.appendChild(isClosableElement);
        return ecpElement;
    }

    public static Element createECPElement(Document document, String ns, ExecutionControlProperties executionControlProperties, ActivityConstants.ActivityModelEntityType entityType) {
        Element ecpElement = document.createElementNS(ns, "executionControlProperties");
        ecpElement.setAttributeNS(null, "origin", entityType.name());
        Element isSuspensibleElement = document.createElementNS(ns, "isSuspensible");
        isSuspensibleElement.setTextContent(Boolean.toString(executionControlProperties.isSuspensible()));
        ecpElement.appendChild(isSuspensibleElement);
        Element isResetableElement = document.createElementNS(ns, "isResettable");
        isResetableElement.setTextContent(Boolean.toString(executionControlProperties.isResettable()));
        ecpElement.appendChild(isResetableElement);
        Element isClosableElement = document.createElementNS(ns, "isClosable");
        isClosableElement.setTextContent(Boolean.toString(executionControlProperties.isClosable()));
        ecpElement.appendChild(isClosableElement);
        return ecpElement;
    }

    public static Element createUserAttributesElement(Document document, String ns, Map<String, String> userAttributes) {
        Element uasElement = document.createElementNS(ns, "userAttributes");
        XMLExportTools.fillUserAttributesElement(document, ns, userAttributes, uasElement, false);
        return uasElement;
    }

    public static void fillUserAttributesElement(Document document, String ns, Map<String, String> userAttributes, Element uasElement, boolean namespaceAware) {
        for (String name : XMLExportTools.sortedKeySet(userAttributes.keySet())) {
            Element uaElement = namespaceAware ? document.createElementNS("http://www.aristaflow.de/adept2/processmodel", "pm:".concat("userAttribute")) : document.createElementNS(ns, "userAttribute");
            uaElement.setAttributeNS(null, "name", name);
            uaElement.setTextContent(userAttributes.get(name));
            uasElement.appendChild(uaElement);
        }
    }

    public static Element createPluginDataContainerElement(Document doc, String ns, PluginDataContainer pdc) {
        Element pdcElement = doc.createElementNS(ns, "pluginDataContainer");
        for (String extensionPoint : XMLExportTools.sortedKeySet(pdc.getSupportedPlugins().keySet())) {
            for (String pluginID : XMLExportTools.sortedKeySet(pdc.getSupportedPlugins().get(extensionPoint))) {
                Element pdElement = doc.createElementNS(ns, "pluginData");
                pdElement.setAttributeNS(null, "extensionPoint", extensionPoint);
                pdElement.setAttributeNS(null, "pluginID", pluginID);
                PluginData data = pdc.getPluginData(pluginID);
                if (data != null && data.getPluginData().size() > 0) {
                    for (String name : XMLExportTools.sortedKeySet(data.getPluginData().keySet())) {
                        Element pdEntry = doc.createElementNS(ns, "pluginDataEntry");
                        pdEntry.setAttributeNS(null, "name", name);
                        pdEntry.setTextContent(data.getPluginDataEntry(name));
                        pdElement.appendChild(pdEntry);
                    }
                }
                pdcElement.appendChild(pdElement);
            }
        }
        return pdcElement;
    }

    protected static void fillQualifiedAgentElement(Document document, String ns, Element qaElement, QualifiedAgent qa) {
        XMLExportTools.addElement(document, ns, qaElement, "agentID", Long.toString(qa.getAgentID()));
        XMLExportTools.addElement(document, ns, qaElement, "agentName", qa.getAgentUserName());
        XMLExportTools.addElement(document, ns, qaElement, "orgPositionID", Long.toString(qa.getOrgPositionID()));
        XMLExportTools.addElement(document, ns, qaElement, "orgPositionName", qa.getOrgPositionName());
    }

    public static Element createEBPInstanceReferenceElement(Document document, String ns, EBPInstanceReference ebpIR, boolean namespaceAware) {
        Element ebpInstanceReferenceElement = document.createElementNS(ns, "ebpInstanceReference");
        if (namespaceAware) {
            XMLExportTools.addElementNS(document, ebpInstanceReferenceElement, "type", ebpIR.getType().name());
            XMLExportTools.addElementNS(document, ebpInstanceReferenceElement, "parentInstanceID", ebpIR.getInstanceID().toString());
            XMLExportTools.addElementNS(document, ebpInstanceReferenceElement, "baseTemplateID", ebpIR.getBaseTemplateID().toString());
            XMLExportTools.addElementNS(document, ebpInstanceReferenceElement, "parentNodeID", Integer.toString(ebpIR.getNodeID()));
            XMLExportTools.addElementNS(document, ebpInstanceReferenceElement, "parentIteration", Integer.toString(ebpIR.getNodeIteration()));
            XMLExportTools.addElementNS(document, ebpInstanceReferenceElement, "isActivity", Boolean.toString(ebpIR.isActivity()));
            ebpInstanceReferenceElement.appendChild(XMLExportTools.createURIArrayElement(document, ns, ebpIR.getExecutionManagerURIs(), "executionManagerURIs", namespaceAware));
            if (ebpIR.getRuntimeManagerURIs() != null) {
                ebpInstanceReferenceElement.appendChild(XMLExportTools.createURIArrayElement(document, ns, ebpIR.getRuntimeManagerURIs(), "runtimeManagerURIs", namespaceAware));
            }
        } else {
            XMLExportTools.addElement(document, ns, ebpInstanceReferenceElement, "type", ebpIR.getType().name());
            XMLExportTools.addElement(document, ns, ebpInstanceReferenceElement, "parentInstanceID", ebpIR.getInstanceID().toString());
            XMLExportTools.addElement(document, ns, ebpInstanceReferenceElement, "baseTemplateID", ebpIR.getBaseTemplateID().toString());
            XMLExportTools.addElement(document, ns, ebpInstanceReferenceElement, "parentNodeID", Integer.toString(ebpIR.getNodeID()));
            XMLExportTools.addElement(document, ns, ebpInstanceReferenceElement, "parentIteration", Integer.toString(ebpIR.getNodeIteration()));
            XMLExportTools.addElement(document, ns, ebpInstanceReferenceElement, "isActivity", Boolean.toString(ebpIR.isActivity()));
            ebpInstanceReferenceElement.appendChild(XMLExportTools.createURIArrayElement(document, ns, ebpIR.getExecutionManagerURIs(), "executionManagerURIs", namespaceAware));
            if (ebpIR.getRuntimeManagerURIs() != null) {
                ebpInstanceReferenceElement.appendChild(XMLExportTools.createURIArrayElement(document, ns, ebpIR.getRuntimeManagerURIs(), "runtimeManagerURIs", namespaceAware));
            }
        }
        return ebpInstanceReferenceElement;
    }

    protected static Element createURIArrayElement(Document document, String ns, URI[] arrayOfURIs, String parentElementName, boolean namespaceAware) {
        Element urisElement = namespaceAware ? document.createElementNS("http://www.aristaflow.de/adept2/processmodel", parentElementName) : document.createElementNS(ns, parentElementName);
        URI[] uRIArray = arrayOfURIs;
        int n = arrayOfURIs.length;
        int n2 = 0;
        while (n2 < n) {
            URI uri = uRIArray[n2];
            if (namespaceAware) {
                XMLExportTools.addElementNS(document, urisElement, "uri", uri.toString());
            } else {
                XMLExportTools.addElement(document, ns, urisElement, "uri", uri.toString());
            }
            ++n2;
        }
        return urisElement;
    }

    protected static Set<String> sortedKeySet(Set<String> keySet) {
        return new TreeSet<String>(keySet);
    }

    protected static Element addElement(Document document, String ns, Element parent, String type) {
        Element element = document.createElementNS(ns, type);
        parent.appendChild(element);
        return element;
    }

    protected static void addElement(Document document, String ns, Element parent, String type, String textContent) {
        Element element = document.createElementNS(ns, type);
        element.setTextContent(textContent);
        parent.appendChild(element);
    }

    protected static void addElement(Document document, String ns, Element parent, String type, String textContent, ActivityConstants.ActivityModelEntityType entityType) {
        Element element = document.createElementNS(ns, type);
        element.setAttributeNS(null, "origin", entityType.name());
        element.setTextContent(textContent);
        parent.appendChild(element);
    }

    protected static void addElementNS(Document document, Element parent, String type, String textContent) {
        Element element = document.createElementNS("http://www.aristaflow.de/adept2/processmodel", "pm:".concat(type));
        element.setTextContent(textContent);
        parent.appendChild(element);
    }
}

