/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.common;

import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.model.common.ActivityConfiguration;
import de.aristaflow.adept2.model.common.ChangeableActivityConfiguration;
import de.aristaflow.adept2.model.common.CommonModelFactory;
import de.aristaflow.adept2.model.common.Configuration;
import de.aristaflow.adept2.model.common.ConfigurationDescription;
import de.aristaflow.adept2.model.common.ExecutionControlProperties;
import de.aristaflow.adept2.model.common.PluginData;
import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.EBPType;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.model.processmodel.EBPInstanceReference;
import de.aristaflow.adept2.model.processmodel.defaultimplementation.DefaultEBPInstanceReference;
import de.aristaflow.adept2.util.xml.XMLHelperTools;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLImportTools {
    public static Configuration getConfiguration(CommonModelFactory cmf, Element confElement) {
        Element child = XMLImportTools.getElement(confElement.getFirstChild());
        HashMap<String, String> values = new HashMap<String, String>();
        HashSet<String> fixed = new HashSet<String>();
        while (child != null) {
            String name = child.getAttribute("name");
            if (Boolean.parseBoolean(child.getAttribute("fixed"))) {
                fixed.add(name);
            }
            if (Boolean.parseBoolean(child.getAttribute("isNull"))) {
                values.put(name, null);
            } else {
                values.put(name, child.getTextContent());
            }
            child = XMLImportTools.getElement(child.getNextSibling());
        }
        return cmf.createConfiguration(values, fixed);
    }

    public static ActivityConfiguration getActivityConfiguration(CommonModelFactory cmf, Element confElement) {
        Element child = XMLImportTools.getElement(confElement.getFirstChild());
        HashMap<String, String> values = new HashMap<String, String>();
        HashMap<String, String> fromParameter = new HashMap<String, String>();
        HashMap<String, String> fromConfiguration = new HashMap<String, String>();
        HashSet<String> fixed = new HashSet<String>();
        while (child != null) {
            String name = child.getAttribute("name");
            String fromParam = child.getAttribute("fromParameter");
            String fromConf = child.getAttribute("fromConfiguration");
            if (Boolean.parseBoolean(child.getAttribute("fixed"))) {
                fixed.add(name);
            }
            if (fromParam != null && fromParam.length() > 0) {
                fromParameter.put(name, fromParam);
            } else if (fromConf != null && fromConf.length() > 0) {
                fromConfiguration.put(name, fromConf);
            } else if (Boolean.parseBoolean(child.getAttribute("isNull"))) {
                values.put(name, null);
            } else {
                values.put(name, child.getTextContent());
            }
            child = XMLImportTools.getElement(child.getNextSibling());
        }
        return cmf.createActivityConfiguration(values, fromParameter, fromConfiguration, fixed);
    }

    public static ChangeableActivityConfiguration getChangeableActivityConfiguration(CommonModelFactory cmf, Element confElement) {
        Element child = XMLImportTools.getElement(confElement.getFirstChild());
        HashMap<String, String> values = new HashMap<String, String>();
        HashMap<String, String> fromParameter = new HashMap<String, String>();
        HashMap<String, String> fromConfiguration = new HashMap<String, String>();
        HashSet<String> fixed = new HashSet<String>();
        while (child != null) {
            String name = child.getAttribute("name");
            String fromParam = child.getAttribute("fromParameter");
            String fromConf = child.getAttribute("fromConfiguration");
            if (Boolean.parseBoolean(child.getAttribute("fixed"))) {
                fixed.add(name);
            }
            if (fromParam != null && fromParam.length() > 0) {
                fromParameter.put(name, fromParam);
            } else if (fromConf != null && fromConf.length() > 0) {
                fromConfiguration.put(name, fromConf);
            } else if (Boolean.parseBoolean(child.getAttribute("isNull"))) {
                values.put(name, null);
            } else {
                values.put(name, child.getTextContent());
            }
            child = XMLImportTools.getElement(child.getNextSibling());
        }
        return cmf.createChangeableActivityConfiguration(values, fromParameter, fromConfiguration, fixed);
    }

    public static ConfigurationDescription getConfigurationDescription(CommonModelFactory cmf, Element element) {
        Element child = XMLImportTools.getElement(element.getFirstChild());
        HashMap<String, ConfigurationDescription.ConfigurationEntry> entries = new HashMap<String, ConfigurationDescription.ConfigurationEntry>();
        while (child != null) {
            String name = child.getAttribute("name");
            ConfigurationDescription.ConfigurationEntry value = null;
            Element entry = XMLImportTools.getElement(child.getFirstChild());
            if (entry != null) {
                String description = entry.getTextContent();
                entry = XMLImportTools.getElement(entry.getNextSibling());
                ProcessConstants.AdeptDataType dataType = ProcessConstants.AdeptDataType.valueOf(entry.getTextContent());
                entry = XMLImportTools.getElement(entry.getNextSibling());
                boolean isOptional = Boolean.parseBoolean(entry.getTextContent());
                entry = XMLImportTools.getElement(entry.getNextSibling());
                ArrayList<String> restrictions = new ArrayList<String>();
                PluginDataContainer pluginData = null;
                Map<String, String> userAttributes = null;
                while (entry != null) {
                    if (entry.getTagName().equals("restriction")) {
                        restrictions.add(entry.getTextContent());
                    } else if (entry.getTagName().equals("pluginDataContainer")) {
                        pluginData = XMLImportTools.getPluginDataContainer(cmf, entry);
                    } else if (entry.getTagName().equals("userAttributes")) {
                        userAttributes = XMLImportTools.getUserAttributes(entry);
                    }
                    entry = XMLImportTools.getElement(entry.getNextSibling());
                }
                value = cmf.createConfigurationEntry(name, description, dataType, isOptional, restrictions.toArray(new String[restrictions.size()]), pluginData, userAttributes);
            }
            entries.put(name, value);
            child = XMLImportTools.getElement(child.getNextSibling());
        }
        return cmf.createConfigurationDescription(entries);
    }

    public static List<String> getClassPath(Element cpElement) {
        ArrayList<String> classPaths = new ArrayList<String>();
        Element child = XMLImportTools.getElement(cpElement.getFirstChild());
        while (child != null) {
            classPaths.add(child.getTextContent());
            child = XMLImportTools.getElement(child.getNextSibling());
        }
        return classPaths;
    }

    public static Map<ActivityConstants.ActivityModelEntityType, List<String>> getSeparatedClassPath(Element cpElement) {
        HashMap<ActivityConstants.ActivityModelEntityType, List<String>> classPaths = new HashMap<ActivityConstants.ActivityModelEntityType, List<String>>();
        classPaths.put(ActivityConstants.ActivityModelEntityType.ECD, new ArrayList());
        classPaths.put(ActivityConstants.ActivityModelEntityType.OPERATION, new ArrayList());
        classPaths.put(ActivityConstants.ActivityModelEntityType.ATD, new ArrayList());
        Element child = XMLImportTools.getElement(cpElement.getFirstChild());
        while (child != null) {
            String origin = child.getAttribute("origin");
            ActivityConstants.ActivityModelEntityType type = ActivityConstants.ActivityModelEntityType.ECD;
            if (origin.length() > 0) {
                type = ActivityConstants.ActivityModelEntityType.valueOf(origin);
            }
            List list = (List)classPaths.get((Object)type);
            list.add(child.getTextContent());
            classPaths.put(type, list);
            child = XMLImportTools.getElement(child.getNextSibling());
        }
        return classPaths;
    }

    public static ExecutionControlProperties getExecutionControlProperties(Element ecpElement) {
        if (ecpElement != null && ecpElement.getTagName().equals("executionControlProperties")) {
            Element ecpChild = XMLImportTools.getElement(ecpElement.getFirstChild());
            boolean suspensible = Boolean.parseBoolean(ecpChild.getTextContent());
            ecpChild = XMLImportTools.getElement(ecpChild.getNextSibling());
            boolean resettable = Boolean.parseBoolean(ecpChild.getTextContent());
            ecpChild = XMLImportTools.getElement(ecpChild.getNextSibling());
            boolean closable = Boolean.parseBoolean(ecpChild.getTextContent());
            return new ExecutionControlProperties(suspensible, resettable, closable);
        }
        return null;
    }

    public static PluginDataContainer getPluginDataContainer(CommonModelFactory cmf, Element pdcElement) {
        HashMap<String, Set<String>> supportedPlugins = new HashMap<String, Set<String>>();
        HashMap<String, PluginData> pluginDatas = new HashMap<String, PluginData>();
        Element pdElement = XMLImportTools.getElement(pdcElement.getFirstChild());
        while (pdElement != null) {
            String extensionPoint = pdElement.getAttribute("extensionPoint");
            String pluginID = pdElement.getAttribute("pluginID");
            HashMap<String, String> innerMap = new HashMap<String, String>();
            Element pdEntry = XMLImportTools.getElement(pdElement.getFirstChild());
            while (pdEntry != null) {
                innerMap.put(pdEntry.getAttribute("name"), pdEntry.getTextContent());
                pdEntry = XMLImportTools.getElement(pdEntry.getNextSibling());
            }
            Set pluginIDs = supportedPlugins.containsKey(extensionPoint) ? (Set)supportedPlugins.get(extensionPoint) : new HashSet();
            pluginIDs.add(pluginID);
            supportedPlugins.put(extensionPoint, pluginIDs);
            PluginData pluginData = cmf.createPluginData(pluginID, innerMap);
            pluginDatas.put(pluginID, pluginData);
            pdElement = XMLImportTools.getElement(pdElement.getNextSibling());
        }
        return cmf.createPluginDataContainer(supportedPlugins, pluginDatas);
    }

    public static Map<String, String> getUserAttributes(Element uasElement) {
        HashMap<String, String> userAttributes = new HashMap<String, String>();
        Element child = XMLImportTools.getElement(uasElement.getFirstChild());
        while (child != null) {
            String key = child.getAttribute("name");
            String value = child.getTextContent();
            userAttributes.put(key, value);
            child = XMLImportTools.getElement(child.getNextSibling());
        }
        return userAttributes;
    }

    protected static QualifiedAgent getQualifiedAgent(Element qaElement) {
        Element child = XMLImportTools.getElement(qaElement.getFirstChild());
        int agentID = Integer.parseInt(child.getTextContent());
        child = XMLImportTools.getElement(child.getNextSibling());
        String agentName = child.getTextContent();
        child = XMLImportTools.getElement(child.getNextSibling());
        int orgPositionID = Integer.parseInt(child.getTextContent());
        child = XMLImportTools.getElement(child.getNextSibling());
        String orgPositionName = child.getTextContent();
        return new QualifiedAgent(agentID, agentName, orgPositionID, orgPositionName);
    }

    public static EBPInstanceReference getEBPInstanceReference(Element ebpInstanceReferenceElement) {
        URI[] runtimeManagerURIs = null;
        Element child = XMLImportTools.getElement(ebpInstanceReferenceElement.getFirstChild());
        EBPType type = EBPType.valueOf(child.getTextContent());
        child = XMLImportTools.getElement(child.getNextSibling());
        UUID superInstanceID = UUID.fromString(child.getTextContent());
        child = XMLImportTools.getElement(child.getNextSibling());
        UUID baseTemplateID = UUID.fromString(child.getTextContent());
        child = XMLImportTools.getElement(child.getNextSibling());
        int nodeID = Integer.parseInt(child.getTextContent());
        child = XMLImportTools.getElement(child.getNextSibling());
        int nodeIteration = Integer.parseInt(child.getTextContent());
        child = XMLImportTools.getElement(child.getNextSibling());
        boolean isActivity = Boolean.parseBoolean(child.getTextContent());
        child = XMLImportTools.getElement(child.getNextSibling());
        URI[] executionManagerURIs = XMLImportTools.getURIs(child);
        if ((child = XMLImportTools.getElement(child.getNextSibling())) != null) {
            runtimeManagerURIs = XMLImportTools.getURIs(child);
        }
        DefaultEBPInstanceReference ebpIR = runtimeManagerURIs != null ? new DefaultEBPInstanceReference(type, superInstanceID, baseTemplateID, nodeID, nodeIteration, isActivity, executionManagerURIs, runtimeManagerURIs) : new DefaultEBPInstanceReference(type, superInstanceID, baseTemplateID, nodeID, nodeIteration, isActivity, executionManagerURIs);
        return ebpIR;
    }

    protected static URI[] getURIs(Element urisElement) {
        ArrayList<URI> list = new ArrayList<URI>();
        Element child = XMLImportTools.getElement(urisElement.getFirstChild());
        while (child != null) {
            list.add(URI.create(child.getTextContent()));
            child = XMLImportTools.getElement(child.getNextSibling());
        }
        return list.toArray(new URI[list.size()]);
    }

    protected static Element getElement(Node node) {
        return XMLHelperTools.getElement(node);
    }
}

