/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.common.defaultimplementation;

import de.aristaflow.adept2.model.common.ConfigurationDescription;
import de.aristaflow.adept2.model.common.Parameter;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.util.ArgChecks;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public final class CommonImpl {
    public static void checkParameterCollection(Collection<? extends Parameter> parameters) {
        HashSet<String> names = new HashSet<String>();
        for (Parameter parameter : parameters) {
            if (!names.contains(parameter.getName())) {
                names.add(parameter.getName());
                continue;
            }
            String msg = "the collections contains parameters with duplicate names!";
            throw new IllegalArgumentException(msg);
        }
    }

    public static void checkParameterMap(Map<String, ? extends Parameter> parameters) {
        for (Map.Entry<String, ? extends Parameter> entry : parameters.entrySet()) {
            Parameter parameter = entry.getValue();
            if (parameter == null || parameter.getName().equals(entry.getKey())) continue;
            String msg = "keys in the map must match the parameters' names!";
            throw new IllegalArgumentException(msg);
        }
    }

    public static <P extends Parameter & Serializable> void setParameters(Map<ActivityConstants.AccessType, HashMap<String, P>> allParameters, ActivityConstants.AccessType accessType, Collection<P> parameters) {
        HashMap<String, Parameter> paramCol;
        ArgChecks.checkForNulls(allParameters, "allParameters");
        ArgChecks.checkForNull((Object)accessType, "accessType");
        if (parameters == null) {
            paramCol = new HashMap<String, Parameter>(0);
        } else {
            ArgChecks.checkForNulls(parameters, "parameters");
            CommonImpl.checkParameterCollection(parameters);
            paramCol = new HashMap(parameters.size());
            for (Parameter param : parameters) {
                paramCol.put(param.getName(), param);
            }
        }
        allParameters.put(accessType, paramCol);
    }

    public static void checkConfigurationEntryMap(Map<String, ConfigurationDescription.ConfigurationEntry> entries) {
        for (Map.Entry<String, ConfigurationDescription.ConfigurationEntry> entry : entries.entrySet()) {
            ConfigurationDescription.ConfigurationEntry confEntry = entry.getValue();
            if (confEntry == null || confEntry.getName().equals(entry.getKey())) continue;
            String msg = "keys in the map must match the configuration entry's name!";
            throw new IllegalArgumentException(msg);
        }
    }

    private CommonImpl() {
    }
}

