/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.common.defaultimplementation;

import de.aristaflow.adept2.model.common.AbstractActivity;
import de.aristaflow.adept2.model.common.ActivityConfiguration;
import de.aristaflow.adept2.model.common.ExecutionControlProperties;
import de.aristaflow.adept2.model.common.Parameter;
import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.model.common.defaultimplementation.CommonImpl;
import de.aristaflow.adept2.model.common.defaultimplementation.DefaultActivityConfiguration;
import de.aristaflow.adept2.model.common.defaultimplementation.SerialisablePluginDataContainer;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.util.ArgChecks;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public abstract class DefaultAbstractActivity<P extends Parameter & Serializable>
extends SerialisablePluginDataContainer
implements AbstractActivity {
    protected UUID id;
    protected String executableComponentName;
    protected String operationName;
    protected String configurationName;
    protected String activityName;
    protected String description;
    protected String implementationClass;
    protected ArrayList<String> classPath;
    protected HashMap<ActivityConstants.ActivityModelEntityType, ArrayList<String>> separatedClassPaths;
    protected boolean isSingleton;
    protected byte[] systemComponentSignature;
    protected String guiContextID;
    protected ExecutionControlProperties executionControlProperties;
    protected boolean supportsViewOnly;
    protected UUID iconID;
    protected HashMap<ActivityConstants.LocallyOverrideableActivityAttribute, ActivityConstants.ActivityModelEntityType> attributeOrigins;
    protected ActivityConfiguration configuration;
    protected HashMap<ActivityConstants.AccessType, HashMap<String, P>> parameters;

    protected DefaultAbstractActivity(UUID id, String executableComponentName, String operationName, String configurationName, String activityName, String description, String implementationClass, Map<ActivityConstants.ActivityModelEntityType, List<String>> separatedClassPaths, boolean isSingleton, byte[] systemComponentSignature, String guiContextID, ExecutionControlProperties executionControlProperties, boolean supportsViewOnly, UUID iconID, Map<ActivityConstants.LocallyOverrideableActivityAttribute, ActivityConstants.ActivityModelEntityType> attributeOrigins, ActivityConfiguration configuration, Collection<P> inputParameters, Collection<P> outputParameters, PluginDataContainer pluginData, Map<String, String> userAttributes) {
        super(pluginData, userAttributes);
        this.setID(id);
        this.setExecutableComponentName(executableComponentName);
        this.setOperationName(operationName);
        this.setConfigurationName(configurationName);
        this.setActivityName(activityName);
        this.setDescription(description);
        this.setImplementationClass(implementationClass);
        this.setSeparatedClassPaths(separatedClassPaths);
        this.setSingleton(isSingleton);
        this.setSystemComponent(systemComponentSignature);
        this.setGUIContextID(guiContextID);
        this.setExecutionControlProperties(executionControlProperties);
        this.setSupportsViewOnly(supportsViewOnly);
        this.setIconID(iconID);
        this.setAttributeOrigins(attributeOrigins);
        this.configuration = new DefaultActivityConfiguration(configuration);
        this.parameters = new HashMap();
        this.setParameters(ActivityConstants.AccessType.READ, inputParameters);
        this.setParameters(ActivityConstants.AccessType.WRITE, outputParameters);
    }

    @Override
    public UUID getID() {
        return this.id;
    }

    protected void setID(UUID id) {
        ArgChecks.checkForNull(id, "id");
        this.id = id;
    }

    @Override
    public String getExecutableComponentName() {
        return this.executableComponentName;
    }

    protected void setExecutableComponentName(String executableComponentName) {
        ArgChecks.checkForNull(executableComponentName, "executableComponentName");
        this.executableComponentName = executableComponentName;
    }

    @Override
    public String getOperationName() {
        return this.operationName;
    }

    protected void setOperationName(String operationName) {
        ArgChecks.checkForNull(operationName, "operationName");
        this.operationName = operationName;
    }

    @Override
    public String getConfigurationName() {
        return this.configurationName;
    }

    protected void setConfigurationName(String configurationName) {
        if (configurationName != null) {
            ArgChecks.checkForEmpty(configurationName, "configurationName");
        }
        this.configurationName = configurationName;
    }

    @Override
    public String getActivityName() {
        return this.activityName;
    }

    protected void setActivityName(String activityName) {
        ArgChecks.checkForEmpty(activityName, "activityName");
        this.activityName = activityName;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    protected void setDescription(String description) {
        ArgChecks.checkForNull(description, "description");
        this.description = description;
    }

    @Override
    public String getImplementationClass() {
        return this.implementationClass;
    }

    protected void setImplementationClass(String implementationClass) {
        ArgChecks.checkForNull(implementationClass, "implementationClass");
        this.implementationClass = implementationClass;
    }

    @Override
    public List<String> getClassPath() {
        return new ArrayList<String>(this.classPath);
    }

    @Override
    public Map<ActivityConstants.ActivityModelEntityType, List<String>> getSeparatedClassPaths() {
        HashMap<ActivityConstants.ActivityModelEntityType, List<String>> result = new HashMap<ActivityConstants.ActivityModelEntityType, List<String>>(this.separatedClassPaths.size());
        ActivityConstants.ActivityModelEntityType[] activityModelEntityTypeArray = ActivityConstants.ActivityModelEntityType.values();
        int n = activityModelEntityTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActivityConstants.ActivityModelEntityType type = activityModelEntityTypeArray[n2];
            result.put(type, new ArrayList(this.separatedClassPaths.get((Object)type)));
            ++n2;
        }
        return result;
    }

    protected void setSeparatedClassPaths(Map<ActivityConstants.ActivityModelEntityType, List<String>> separatedClassPaths) {
        if (separatedClassPaths == null) {
            this.classPath = new ArrayList(0);
            this.separatedClassPaths = new HashMap();
            ActivityConstants.ActivityModelEntityType[] activityModelEntityTypeArray = ActivityConstants.ActivityModelEntityType.values();
            int n = activityModelEntityTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ActivityConstants.ActivityModelEntityType type = activityModelEntityTypeArray[n2];
                ArrayList emptyList = new ArrayList(0);
                this.separatedClassPaths.put(type, emptyList);
                ++n2;
            }
        } else {
            ArgChecks.checkForNulls(separatedClassPaths, "separatedClassPaths");
            this.classPath = new ArrayList();
            this.separatedClassPaths = new HashMap(separatedClassPaths.size());
            ActivityConstants.ActivityModelEntityType[] activityModelEntityTypeArray = ActivityConstants.ActivityModelEntityType.values();
            int n = activityModelEntityTypeArray.length;
            int n3 = 0;
            while (n3 < n) {
                ActivityConstants.ActivityModelEntityType type = activityModelEntityTypeArray[n3];
                List<String> list = separatedClassPaths.get((Object)type);
                if (list == null) {
                    throw new IllegalArgumentException("'separatedClassPaths' must contain a list for every ActivityModelEntityType!");
                }
                if (list.contains(null)) {
                    throw new IllegalArgumentException("'separatedClassPaths' must not contain null values!");
                }
                this.classPath.addAll(0, list);
                this.separatedClassPaths.put(type, new ArrayList<String>(list));
                ++n3;
            }
        }
    }

    @Override
    public boolean isSingleton() {
        return this.isSingleton;
    }

    protected void setSingleton(boolean isSingleton) {
        this.isSingleton = isSingleton;
    }

    @Override
    public byte[] getSystemComponent() {
        if (this.systemComponentSignature == null) {
            return null;
        }
        return (byte[])this.systemComponentSignature.clone();
    }

    protected void setSystemComponent(byte[] signature) {
        if (signature == null) {
            this.systemComponentSignature = null;
        } else {
            ArgChecks.checkForEmpty(signature, "signature");
            this.systemComponentSignature = (byte[])signature.clone();
        }
    }

    @Override
    public String getGUIContextID() {
        return this.guiContextID;
    }

    protected void setGUIContextID(String guiContextID) {
        ArgChecks.checkForEmpty(guiContextID, "guiContextID");
        this.guiContextID = guiContextID;
    }

    @Override
    public ExecutionControlProperties getExecutionControlProperties() {
        return this.executionControlProperties;
    }

    protected void setExecutionControlProperties(ExecutionControlProperties executionControlProperties) {
        ArgChecks.checkForNull(executionControlProperties, "executionControlProperties");
        this.executionControlProperties = executionControlProperties;
    }

    @Override
    public boolean supportsViewOnly() {
        return this.supportsViewOnly;
    }

    protected void setSupportsViewOnly(boolean supportsViewOnly) {
        this.supportsViewOnly = supportsViewOnly;
    }

    @Override
    public UUID getIconID() {
        return this.iconID;
    }

    protected void setIconID(UUID iconID) {
        this.iconID = iconID;
    }

    @Override
    public ActivityConfiguration getConfiguration() {
        return this.configuration;
    }

    public Set<P> getParameters(ActivityConstants.AccessType accessType) {
        ArgChecks.checkEnum((Object)accessType, "accessType", new Object[]{ActivityConstants.AccessType.READ, ActivityConstants.AccessType.WRITE});
        return new HashSet<P>(this.parameters.get((Object)accessType).values());
    }

    public P getParameter(String name, ActivityConstants.AccessType accessType) {
        ArgChecks.checkForNull(name, "name");
        ArgChecks.checkEnum((Object)accessType, "accessType", (Object[])ActivityConstants.AccessType.activityRelatedValues());
        return (P)((Parameter)this.parameters.get((Object)accessType).get(name));
    }

    protected void setParameters(ActivityConstants.AccessType accessType, Collection<P> parameters) {
        ArgChecks.checkEnum((Object)accessType, "accessType", new Object[]{ActivityConstants.AccessType.READ, ActivityConstants.AccessType.WRITE});
        CommonImpl.setParameters(this.parameters, accessType, parameters);
    }

    @Override
    public Map<ActivityConstants.LocallyOverrideableActivityAttribute, ActivityConstants.ActivityModelEntityType> getAttributeOrigins() {
        return new HashMap<ActivityConstants.LocallyOverrideableActivityAttribute, ActivityConstants.ActivityModelEntityType>(this.attributeOrigins);
    }

    protected void setAttributeOrigins(Map<ActivityConstants.LocallyOverrideableActivityAttribute, ActivityConstants.ActivityModelEntityType> attributeOrigins) {
        if (attributeOrigins == null) {
            this.attributeOrigins = new HashMap();
            ActivityConstants.LocallyOverrideableActivityAttribute[] locallyOverrideableActivityAttributeArray = ActivityConstants.LocallyOverrideableActivityAttribute.values();
            int n = locallyOverrideableActivityAttributeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ActivityConstants.LocallyOverrideableActivityAttribute attr = locallyOverrideableActivityAttributeArray[n2];
                this.attributeOrigins.put(attr, ActivityConstants.ActivityModelEntityType.ATD);
                ++n2;
            }
        } else {
            ArgChecks.checkForNulls(attributeOrigins, "attributeOrigins");
            ActivityConstants.LocallyOverrideableActivityAttribute[] locallyOverrideableActivityAttributeArray = ActivityConstants.LocallyOverrideableActivityAttribute.values();
            int n = locallyOverrideableActivityAttributeArray.length;
            int n3 = 0;
            while (n3 < n) {
                ActivityConstants.LocallyOverrideableActivityAttribute attr = locallyOverrideableActivityAttributeArray[n3];
                if (attributeOrigins.get((Object)attr) == null) {
                    String msg = "origin missing for attribute '%s'";
                    msg = String.format(msg, new Object[]{attr});
                    throw new IllegalArgumentException(msg);
                }
                ++n3;
            }
            this.attributeOrigins = new HashMap<ActivityConstants.LocallyOverrideableActivityAttribute, ActivityConstants.ActivityModelEntityType>(attributeOrigins);
        }
    }
}

