/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.common.defaultimplementation;

import de.aristaflow.adept2.model.common.ActivityConfiguration;
import de.aristaflow.adept2.model.common.Configuration;
import de.aristaflow.adept2.model.common.defaultimplementation.DefaultConfiguration;
import de.aristaflow.adept2.util.ArgChecks;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class DefaultActivityConfiguration
extends DefaultConfiguration
implements ActivityConfiguration {
    private static final long serialVersionUID = 4902390492887650109L;
    protected HashMap<String, String> fromParameters;
    protected HashMap<String, String> fromConfigurations;

    public DefaultActivityConfiguration() {
        this(null);
    }

    public DefaultActivityConfiguration(Map<String, String> values, Map<String, String> fromParameters, Map<String, String> fromConfigurations, Set<String> fixed) {
        HashSet<String> entryNames = new HashSet<String>();
        if (values != null) {
            entryNames.addAll(values.keySet());
        }
        if (fromParameters != null) {
            for (String entryName : fromParameters.keySet()) {
                if (entryNames.contains(entryName)) {
                    String msg = "duplicate entry name: " + entryName;
                    throw new IllegalArgumentException(msg);
                }
                entryNames.add(entryName);
            }
        }
        if (fromConfigurations != null) {
            for (String entryName : fromConfigurations.keySet()) {
                if (entryNames.contains(entryName)) {
                    String msg = "duplicate entry name: " + entryName;
                    throw new IllegalArgumentException(msg);
                }
                entryNames.add(entryName);
            }
        }
        this.setValues(values);
        this.setFromInputParameters(fromParameters);
        this.setFromProcessConfiguration(fromConfigurations);
        this.setFixed(fixed);
    }

    public DefaultActivityConfiguration(Map<String, String> values, Map<String, String> fromParameters, Map<String, String> fromConfigurations, Set<String> fixed, Map<String, String> configurationIDs) {
        this(values, fromParameters, fromConfigurations, fixed);
        this.setConfigurationIDs(configurationIDs);
    }

    public DefaultActivityConfiguration(Configuration template) {
        super(template);
        this.setFromInputParameters(null);
        this.setFromProcessConfiguration(null);
    }

    public DefaultActivityConfiguration(ActivityConfiguration template) {
        if (template == null) {
            this.setValues(null);
            this.setFromInputParameters(null);
            this.setFromProcessConfiguration(null);
            this.setFixed(null);
        } else {
            HashMap<String, String> values = new HashMap<String, String>();
            HashSet<String> fixed = new HashSet<String>();
            HashMap<String, String> fromParameters = new HashMap<String, String>();
            HashMap<String, String> fromConfigurations = new HashMap<String, String>();
            for (String entryName : template.getAllEntries()) {
                String value = template.getString(entryName);
                String fromParameter = template.fromInputParameter(entryName);
                String fromConfiguration = template.fromProcessConfiguration(entryName);
                if (fromConfiguration != null) {
                    fromConfigurations.put(entryName, fromConfiguration);
                } else if (fromParameter != null) {
                    fromParameters.put(entryName, fromParameter);
                } else if (value != null) {
                    values.put(entryName, value);
                }
                if (!template.isFixed(entryName)) continue;
                fixed.add(entryName);
            }
            this.setValues(values);
            this.setFromInputParameters(fromParameters);
            this.setFromProcessConfiguration(fromConfigurations);
            this.setFixed(fixed);
        }
    }

    @Override
    public Set<String> getAllEntries() {
        TreeSet<String> entryNames = new TreeSet<String>();
        entryNames.addAll(this.values.keySet());
        entryNames.addAll(this.fromParameters.keySet());
        entryNames.addAll(this.fromConfigurations.keySet());
        return entryNames;
    }

    @Override
    public String fromInputParameter(String entryName) {
        ArgChecks.checkForNull(entryName, "entryName");
        return this.fromParameters.get(entryName);
    }

    private void setFromInputParameters(Map<String, String> fromParameters) {
        this.fromParameters = fromParameters == null ? new HashMap() : new HashMap<String, String>(fromParameters);
    }

    @Override
    public String fromProcessConfiguration(String entryName) {
        ArgChecks.checkForNull(entryName, "entryName");
        return this.fromConfigurations.get(entryName);
    }

    private void setFromProcessConfiguration(Map<String, String> fromConfigurations) {
        this.fromConfigurations = fromConfigurations == null ? new HashMap() : new HashMap<String, String>(fromConfigurations);
    }
}

