/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.common.defaultimplementation;

import de.aristaflow.adept2.model.common.ActivityConfiguration;
import de.aristaflow.adept2.model.common.ChangeableActivityConfiguration;
import de.aristaflow.adept2.model.common.Configuration;
import de.aristaflow.adept2.model.common.defaultimplementation.DefaultChangeableConfiguration;
import de.aristaflow.adept2.util.ArgChecks;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class DefaultChangeableActivityConfiguration
extends DefaultChangeableConfiguration
implements ChangeableActivityConfiguration {
    private static final long serialVersionUID = -8935845869954816242L;
    protected HashMap<String, String> fromParameters;
    protected HashMap<String, String> fromConfigurations;

    public DefaultChangeableActivityConfiguration() {
        this(null);
    }

    public DefaultChangeableActivityConfiguration(Map<String, String> values, Map<String, String> fromParameters, Map<String, String> fromConfigurations, Set<String> fixed) {
        HashSet<String> entryNames = new HashSet<String>();
        if (values != null) {
            entryNames.addAll(values.keySet());
        }
        if (fromParameters != null) {
            for (String entryName : fromParameters.keySet()) {
                if (entryNames.contains(entryName)) {
                    String msg = "duplicate entry name: " + entryName;
                    throw new IllegalArgumentException(msg);
                }
                entryNames.add(entryName);
            }
        }
        if (fromConfigurations != null) {
            for (String entryName : fromConfigurations.keySet()) {
                if (entryNames.contains(entryName)) {
                    String msg = "duplicate entry name: " + entryName;
                    throw new IllegalArgumentException(msg);
                }
                entryNames.add(entryName);
            }
        }
        this.setValues(values);
        this.setFromInputParameters(fromParameters);
        this.setFromProcessConfiguration(fromConfigurations);
        this.setFixed(fixed);
    }

    public DefaultChangeableActivityConfiguration(ActivityConfiguration template) {
        if (template == null) {
            this.setValues(null);
            this.setFromInputParameters(null);
            this.setFromProcessConfiguration(null);
            this.setFixed(null);
        } else {
            HashMap<String, String> values = new HashMap<String, String>();
            HashSet<String> fixed = new HashSet<String>();
            HashMap<String, String> fromParameters = new HashMap<String, String>();
            HashMap<String, String> fromConfigurations = new HashMap<String, String>();
            for (String entryName : template.getAllEntries()) {
                String value = template.getString(entryName);
                String fromParameter = template.fromInputParameter(entryName);
                String fromConfiguration = template.fromProcessConfiguration(entryName);
                if (fromConfiguration != null) {
                    fromConfigurations.put(entryName, fromConfiguration);
                } else if (fromParameter != null) {
                    fromParameters.put(entryName, fromParameter);
                } else if (value != null) {
                    values.put(entryName, value);
                }
                if (!template.isFixed(entryName)) continue;
                fixed.add(entryName);
            }
            this.setValues(values);
            this.setFromInputParameters(fromParameters);
            this.setFromProcessConfiguration(fromConfigurations);
            this.setFixed(fixed);
        }
    }

    public DefaultChangeableActivityConfiguration(Configuration template) {
        super(template);
        this.setFromInputParameters(null);
        this.setFromProcessConfiguration(null);
    }

    @Override
    public Set<String> getAllEntries() {
        TreeSet<String> entryNames = new TreeSet<String>();
        entryNames.addAll(this.values.keySet());
        entryNames.addAll(this.fromParameters.keySet());
        entryNames.addAll(this.fromConfigurations.keySet());
        return entryNames;
    }

    @Override
    public void setString(String entryName, String value) {
        super.setString(entryName, value);
        this.fromParameters.remove(entryName);
        this.fromConfigurations.remove(entryName);
    }

    @Override
    public String fromInputParameter(String entryName) {
        ArgChecks.checkForNull(entryName, "entryName");
        return this.fromParameters.get(entryName);
    }

    @Override
    public void setFromInputParameter(String entryName, String inputParameterName) {
        ArgChecks.checkForNull(entryName, "entryName");
        ArgChecks.checkForEmpty(inputParameterName, "inputParameterName");
        if (this.isFixed(entryName)) {
            String msg = "The configuration entry '%s' is fixed!";
            msg = String.format(msg, entryName);
            throw new IllegalStateException(msg);
        }
        this.fromParameters.put(entryName, inputParameterName);
        this.values.remove(entryName);
        this.fromConfigurations.remove(entryName);
    }

    private void setFromInputParameters(Map<String, String> fromParameters) {
        this.fromParameters = fromParameters == null ? new HashMap() : new HashMap<String, String>(fromParameters);
    }

    @Override
    public String fromProcessConfiguration(String entryName) {
        ArgChecks.checkForNull(entryName, "entryName");
        return this.fromConfigurations.get(entryName);
    }

    @Override
    public void setFromProcessConfiguration(String entryName, String configurationEntry) {
        ArgChecks.checkForNull(entryName, "entryName");
        ArgChecks.checkForEmpty(configurationEntry, "configurationEntry");
        if (this.isFixed(entryName)) {
            String msg = "The configuration entry '%s' is fixed!";
            msg = String.format(msg, entryName);
            throw new IllegalStateException(msg);
        }
        this.fromConfigurations.put(entryName, configurationEntry);
        this.values.remove(entryName);
        this.fromParameters.remove(entryName);
    }

    private void setFromProcessConfiguration(Map<String, String> fromConfigurations) {
        this.fromConfigurations = fromConfigurations == null ? new HashMap() : new HashMap<String, String>(fromConfigurations);
    }

    @Override
    public void remove(String entryName) {
        super.remove(entryName);
        this.fromParameters.remove(entryName);
        this.fromConfigurations.remove(entryName);
    }
}

