/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.common.defaultimplementation;

import de.aristaflow.adept2.model.common.ChangeableConfiguration;
import de.aristaflow.adept2.model.common.Configuration;
import de.aristaflow.adept2.model.common.defaultimplementation.DefaultConfiguration;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.ConfigurationTools;
import java.net.URI;
import java.util.Date;
import java.util.Map;
import java.util.Set;

public class DefaultChangeableConfiguration
extends DefaultConfiguration
implements ChangeableConfiguration {
    private static final long serialVersionUID = 5616926902751634261L;

    public DefaultChangeableConfiguration() {
        this(null);
    }

    public DefaultChangeableConfiguration(Map<String, String> values, Set<String> fixed) {
        super(values, fixed);
    }

    public DefaultChangeableConfiguration(Configuration template) {
        super(template);
    }

    @Override
    public void setBoolean(String entryName, boolean value) {
        ArgChecks.checkForNull(entryName, "entryName");
        this.setString(entryName, ConfigurationTools.toString(value));
    }

    @Override
    public void setInteger(String entryName, long value) {
        ArgChecks.checkForNull(entryName, "entryName");
        this.setString(entryName, ConfigurationTools.toString(value));
    }

    @Override
    public void setFloat(String entryName, double value) {
        ArgChecks.checkForNull(entryName, "entryName");
        this.setString(entryName, ConfigurationTools.toString(value));
    }

    @Override
    public void setString(String entryName, String value) {
        ArgChecks.checkForNull(entryName, "entryName");
        ArgChecks.checkForNull(value, "value");
        if (this.isFixed(entryName)) {
            String msg = "The configuration entry '%s' is fixed!";
            msg = String.format(msg, entryName);
            throw new IllegalStateException(msg);
        }
        this.values.put(entryName, value);
    }

    @Override
    public void setURI(String entryName, URI value) {
        ArgChecks.checkForNull(entryName, "entryName");
        ArgChecks.checkForNull(value, "value");
        this.setString(entryName, ConfigurationTools.toString(value));
    }

    @Override
    public void setDate(String entryName, Date value) {
        ArgChecks.checkForNull(entryName, "entryName");
        ArgChecks.checkForNull(value, "value");
        this.setString(entryName, ConfigurationTools.toString(value));
    }

    @Override
    public void setUDT(String entryName, byte[] value) {
        ArgChecks.checkForNull(entryName, "entryName");
        ArgChecks.checkForNull(value, "value");
        this.setString(entryName, ConfigurationTools.toString(value));
    }

    @Override
    public void remove(String entryName) {
        ArgChecks.checkForNull(entryName, "entryName");
        this.values.remove(entryName);
    }
}

