/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.common.defaultimplementation;

import de.aristaflow.adept2.model.common.Configuration;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.ConfigurationTools;
import java.net.URI;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class DefaultConfiguration
implements Configuration {
    private static final long serialVersionUID = -4997105620885902440L;
    protected HashMap<String, String> values;
    protected HashSet<String> fixed;
    protected HashMap<String, String> sourceOriginIDs;

    public DefaultConfiguration() {
        this(null);
    }

    public DefaultConfiguration(Map<String, String> values, Set<String> fixed) {
        this.setValues(values);
        this.setFixed(fixed);
        this.setConfigurationIDs(null);
    }

    public DefaultConfiguration(Map<String, String> values, Set<String> fixed, Map<String, String> originIDs) {
        this.setValues(values);
        this.setFixed(fixed);
        this.setConfigurationIDs(originIDs);
    }

    public DefaultConfiguration(Configuration template) {
        HashMap<String, String> values = null;
        HashSet<String> fixed = null;
        HashMap<String, String> originIDs = null;
        if (template != null) {
            values = new HashMap<String, String>();
            for (String entryName : template.getAllEntries()) {
                String value = template.getString(entryName);
                if (value == null) continue;
                values.put(entryName, value);
            }
            fixed = new HashSet<String>();
            for (String entryName : values.keySet()) {
                if (!template.isFixed(entryName)) continue;
                fixed.add(entryName);
            }
            originIDs = new HashMap<String, String>();
            for (String entryName : values.keySet()) {
                originIDs.put(entryName, template.getConfigurationID(entryName));
            }
        }
        this.setValues(values);
        this.setFixed(fixed);
        this.setConfigurationIDs(originIDs);
    }

    @Override
    public String getConfigurationID(String entryName) {
        ArgChecks.checkForNull(entryName, "entryName");
        return this.sourceOriginIDs.get(entryName);
    }

    @Override
    public Boolean getBoolean(String entryName) {
        ArgChecks.checkForNull(entryName, "entryName");
        String valueString = this.values.get(entryName);
        return ConfigurationTools.parseBoolean(valueString);
    }

    @Override
    public Long getInteger(String entryName) {
        ArgChecks.checkForNull(entryName, "entryName");
        String valueString = this.values.get(entryName);
        return ConfigurationTools.parseInteger(valueString);
    }

    @Override
    public Double getFloat(String entryName) {
        ArgChecks.checkForNull(entryName, "entryName");
        String valueString = this.values.get(entryName);
        return ConfigurationTools.parseFloat(valueString);
    }

    @Override
    public String getString(String entryName) {
        ArgChecks.checkForNull(entryName, "entryName");
        return this.values.get(entryName);
    }

    @Override
    public URI getURI(String entryName) {
        ArgChecks.checkForNull(entryName, "entryName");
        String valueString = this.values.get(entryName);
        return ConfigurationTools.parseURI(valueString);
    }

    @Override
    public Date getDate(String entryName) {
        ArgChecks.checkForNull(entryName, "entryName");
        String valueString = this.values.get(entryName);
        return ConfigurationTools.parseDate(valueString);
    }

    @Override
    public byte[] getUDT(String entryName) {
        ArgChecks.checkForNull(entryName, "entryName");
        String valueString = this.values.get(entryName);
        return ConfigurationTools.parseUDT(valueString);
    }

    @Override
    public Set<String> getAllEntries() {
        return new TreeSet<String>(this.values.keySet());
    }

    protected void setValues(Map<String, String> values) {
        if (values == null) {
            this.values = new HashMap();
        } else {
            ArgChecks.checkForNullKey(values, "values");
            this.values = new HashMap<String, String>(values);
        }
    }

    @Override
    public boolean isFixed(String entryName) {
        ArgChecks.checkForNull(entryName, "entryName");
        return this.fixed.contains(entryName);
    }

    protected void setFixed(Set<String> fixed) {
        if (fixed == null) {
            this.fixed = new HashSet();
        } else {
            ArgChecks.checkForNulls(fixed, "fixed");
            this.fixed = new HashSet<String>(fixed);
        }
    }

    protected void setConfigurationIDs(Map<String, String> configurationIDs) {
        if (configurationIDs == null) {
            this.sourceOriginIDs = new HashMap();
        } else {
            ArgChecks.checkForNullKey(configurationIDs, "configurationIDs");
            this.sourceOriginIDs = new HashMap<String, String>(configurationIDs);
        }
    }
}

