/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.common.defaultimplementation;

import de.aristaflow.adept2.model.common.ConfigurationDescription;
import de.aristaflow.adept2.model.common.defaultimplementation.CommonImpl;
import de.aristaflow.adept2.util.ArgChecks;
import java.util.HashMap;
import java.util.Map;

public class DefaultConfigurationDescription
implements ConfigurationDescription {
    private static final long serialVersionUID = 5332965010481605824L;
    protected HashMap<String, ConfigurationDescription.ConfigurationEntry> entries;

    public DefaultConfigurationDescription() {
        this((ConfigurationDescription)null);
    }

    public DefaultConfigurationDescription(Map<String, ConfigurationDescription.ConfigurationEntry> entries) {
        this.setEntries(entries);
    }

    public DefaultConfigurationDescription(ConfigurationDescription template) {
        if (template == null) {
            this.setEntries(null);
        } else {
            this.setEntries(template.getEntries());
        }
    }

    @Override
    public ConfigurationDescription.ConfigurationEntry getEntry(String entryName) {
        ArgChecks.checkForEmpty(entryName, "entryName");
        return this.entries.get(entryName);
    }

    @Override
    public Map<String, ConfigurationDescription.ConfigurationEntry> getEntries() {
        return new HashMap<String, ConfigurationDescription.ConfigurationEntry>(this.entries);
    }

    protected void setEntries(Map<String, ConfigurationDescription.ConfigurationEntry> entries) {
        if (entries == null) {
            this.entries = new HashMap();
        } else {
            ArgChecks.checkForNullKey(entries, "entries");
            CommonImpl.checkConfigurationEntryMap(entries);
            this.entries = new HashMap<String, ConfigurationDescription.ConfigurationEntry>(entries);
        }
    }
}

