/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.common.defaultimplementation;

import de.aristaflow.adept2.model.common.ConfigurationDescription;
import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.model.common.defaultimplementation.SerialisablePluginDataContainer;
import de.aristaflow.adept2.model.globals.ActivityConstants;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.util.ArgChecks;
import java.util.Map;

public class DefaultConfigurationEntry
extends SerialisablePluginDataContainer
implements ConfigurationDescription.ConfigurationEntry {
    private static final long serialVersionUID = -7501095258011821068L;
    private String name;
    private String description;
    private ProcessConstants.AdeptDataType dataType;
    private boolean isOptional;
    private String[] restrictions;

    public DefaultConfigurationEntry(String name, String description, ProcessConstants.AdeptDataType dataType, boolean isOptional, String[] restrictions, PluginDataContainer pluginData, Map<String, String> userAttributes) {
        super(pluginData, userAttributes);
        ArgChecks.checkForEmpty(name, "name");
        char[] cArray = ActivityConstants.DISALLOWED_NAME_CHARACTERS;
        int n = ActivityConstants.DISALLOWED_NAME_CHARACTERS.length;
        int n2 = 0;
        while (n2 < n) {
            char illegal = cArray[n2];
            if (name.indexOf(illegal) > -1) {
                String msg = "The name must not contain '%s' characters!";
                msg = String.format(msg, Character.valueOf(illegal));
                throw new IllegalArgumentException(msg);
            }
            ++n2;
        }
        ArgChecks.checkForNull(description, "description");
        ArgChecks.checkForNull((Object)dataType, "dataType");
        if (restrictions != null) {
            ArgChecks.checkForNulls(restrictions, "restrictions");
        }
        this.name = name;
        this.description = description;
        this.dataType = dataType;
        this.isOptional = isOptional;
        this.restrictions = restrictions == null ? new String[0] : restrictions;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public ProcessConstants.AdeptDataType getDataType() {
        return this.dataType;
    }

    @Override
    public boolean isOptional() {
        return this.isOptional;
    }

    @Override
    public String[] getRestrictions() {
        return (String[])this.restrictions.clone();
    }
}

