/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.common.defaultimplementation;

import de.aristaflow.adept2.model.common.Configuration;
import de.aristaflow.adept2.util.ConfigurationTools;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.configuration.BaseConfiguration;

public class DefaultConfigurationWrapper
implements Configuration {
    private static final long serialVersionUID = -5796570989299830609L;
    protected transient org.apache.commons.configuration.Configuration configuration;
    protected String id;

    public DefaultConfigurationWrapper(org.apache.commons.configuration.Configuration configuration, String id) {
        this.configuration = configuration;
        this.id = id;
    }

    @Override
    public Boolean getBoolean(String entryName) {
        return this.configuration.getBoolean(entryName, null);
    }

    @Override
    public Long getInteger(String entryName) {
        return this.configuration.getLong(entryName, null);
    }

    @Override
    public Double getFloat(String entryName) {
        return this.configuration.getDouble(entryName, null);
    }

    @Override
    public String getString(String entryName) {
        return this.configuration.getString(entryName);
    }

    @Override
    public URI getURI(String entryName) {
        return ConfigurationTools.parseURI(this.configuration.getString(entryName));
    }

    @Override
    public Date getDate(String entryName) {
        return ConfigurationTools.parseDate(this.configuration.getString(entryName));
    }

    @Override
    public byte[] getUDT(String entryName) {
        return ConfigurationTools.parseUDT(this.configuration.getString(entryName));
    }

    @Override
    public boolean isFixed(String entryName) {
        return false;
    }

    @Override
    public Set<String> getAllEntries() {
        TreeSet<String> ret = new TreeSet<String>();
        Iterator keys = this.configuration.getKeys();
        while (keys.hasNext()) {
            ret.add(keys.next().toString());
        }
        return ret;
    }

    @Override
    public String getConfigurationID(String entryName) {
        return this.id;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeUTF(this.id);
        int keyCount = 0;
        Iterator keys = this.configuration.getKeys();
        while (keys.hasNext()) {
            ++keyCount;
            keys.next();
        }
        out.writeInt(keyCount);
        while (keys.hasNext()) {
            String key = (String)keys.next();
            out.writeUTF(key);
            Object value = this.configuration.getProperty(key);
            out.writeObject(value);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.id = in.readUTF();
        this.configuration = new BaseConfiguration();
        int keyCount = in.readInt();
        int i = 0;
        while (i < keyCount) {
            String key = in.readUTF();
            Object value = in.readObject();
            this.configuration.setProperty(key, value);
            ++i;
        }
    }
}

