/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.common.defaultimplementation;

import de.aristaflow.adept2.model.common.IconDescriptor;
import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.model.common.State;
import de.aristaflow.adept2.model.common.defaultimplementation.SerialisablePluginDataContainer;
import de.aristaflow.adept2.util.ArgChecks;
import java.util.Map;
import java.util.UUID;

public class DefaultIconDescriptor
extends SerialisablePluginDataContainer
implements IconDescriptor {
    private static final long serialVersionUID = 979448770755957410L;
    protected UUID id;
    protected String name;
    protected String description;
    protected IconDescriptor.Dimension[] dimensions;
    protected long revision;
    protected State state;

    public DefaultIconDescriptor(UUID id, String name, String description, IconDescriptor.Dimension[] dimensions, long revision, State state, PluginDataContainer pluginData, Map<String, String> userAttributes) {
        super(pluginData, userAttributes);
        ArgChecks.checkForNull(id, "id");
        ArgChecks.checkForNulls(dimensions, "dimensions");
        ArgChecks.checkForNegative(revision, "revision");
        ArgChecks.checkForNull((Object)state, "state");
        this.id = id;
        this.setName(name);
        this.setDescription(description);
        this.dimensions = (IconDescriptor.Dimension[])dimensions.clone();
        this.revision = revision;
        this.state = state;
    }

    @Override
    public UUID getID() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        ArgChecks.checkForNull(name, "name");
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    protected void setDescription(String description) {
        ArgChecks.checkForNull(description, "description");
        this.description = description;
    }

    @Override
    public IconDescriptor.Dimension[] getDimensions() {
        return (IconDescriptor.Dimension[])this.dimensions.clone();
    }

    @Override
    public long getRevision() {
        return this.revision;
    }

    @Override
    public State getState() {
        return this.state;
    }
}

