/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.common.defaultimplementation;

import de.aristaflow.adept2.model.common.LicenceInformation;
import de.aristaflow.adept2.util.HashCalc;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultLicenceInformation
implements LicenceInformation,
Serializable {
    private static final long serialVersionUID = 7721837169216173061L;
    private final int licenceID;
    private final String customerID;
    private final String distributorID;
    private final String licenceType;
    private final String licensee;
    private final String[] mailAddresses;
    private final String version;
    private final LicenceInformation.Activation activation;
    private final Date timeLimitStart;
    private final Date timeLimitEnd;
    private final int transactionLimit;
    private final int userLimit;
    private final int ipAddress;
    private final byte ipMask;
    private final String[] typeLimit;
    private final boolean isWebClientEnabled;
    private final boolean isEscalationEnabled;
    private final HashMap<String, Boolean> products;
    private final boolean isProcessFlexibilityEnabled;
    private final String[] processFlexibilityTypes;
    private final boolean isRuntimeFlexibilityEnabled;
    private final String[] runtimeFlexibilityTypes;
    private final HashMap<String, String> additions;
    private final String licenceDigest;
    private final String licenceSignature;
    private final String document;

    public DefaultLicenceInformation(int licenceID, String customerID, String distributorID, String licenceType, String licensee, String[] mailAddress, String version, LicenceInformation.Activation activation, Date timeLimitStart, Date timeLimitEnd, int transactionLimit, int userLimit, int ipAddress, byte ipMask, String[] typeLimit, boolean isWebClientEnabled, boolean isEscalationEnabled, Map<String, Boolean> products, boolean isProcessFlexibilityEnabled, String[] processFlexibilityTypes, boolean isRuntimeFlexibilityEnabled, String[] runtimeFlexibilityTypes, Map<String, String> additions, String licenceDigest, String licenceSignature, String document) {
        this.licenceID = licenceID;
        this.customerID = customerID;
        this.distributorID = distributorID;
        this.licenceType = licenceType;
        this.licensee = licensee;
        this.mailAddresses = mailAddress == null ? new String[0] : (String[])mailAddress.clone();
        this.version = version;
        this.activation = activation;
        this.timeLimitStart = timeLimitStart != null ? (Date)timeLimitStart.clone() : null;
        this.timeLimitEnd = timeLimitEnd != null ? (Date)timeLimitEnd.clone() : null;
        this.transactionLimit = transactionLimit;
        this.userLimit = userLimit;
        this.ipAddress = ipAddress;
        this.ipMask = ipMask;
        this.typeLimit = typeLimit != null ? (String[])typeLimit.clone() : null;
        this.isWebClientEnabled = isWebClientEnabled;
        this.isEscalationEnabled = isEscalationEnabled;
        this.products = products == null ? new HashMap() : new HashMap<String, Boolean>(products);
        this.isProcessFlexibilityEnabled = isProcessFlexibilityEnabled;
        this.processFlexibilityTypes = processFlexibilityTypes != null ? (String[])processFlexibilityTypes.clone() : null;
        this.isRuntimeFlexibilityEnabled = isRuntimeFlexibilityEnabled;
        this.runtimeFlexibilityTypes = runtimeFlexibilityTypes != null ? (String[])runtimeFlexibilityTypes.clone() : null;
        this.additions = additions == null ? new HashMap() : new HashMap<String, String>(additions);
        this.licenceDigest = licenceDigest;
        this.licenceSignature = licenceSignature;
        this.document = document;
    }

    @Override
    public int getLicenceID() {
        return this.licenceID;
    }

    @Override
    public String getCustomerID() {
        return this.customerID;
    }

    @Override
    public String getDistributorID() {
        return this.distributorID;
    }

    @Override
    public String getLicenceType() {
        return this.licenceType;
    }

    @Override
    public String getLicensee() {
        return this.licensee;
    }

    @Override
    public List<String> getMailAddresses() {
        return Collections.unmodifiableList(Arrays.asList(this.mailAddresses));
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public LicenceInformation.Activation getActivation() {
        return this.activation;
    }

    @Override
    public Date getTimeLimitEnd() {
        return this.timeLimitEnd;
    }

    @Override
    public Date getTimeLimitStart() {
        return this.timeLimitStart;
    }

    @Override
    public int getTransactionLimit() {
        return this.transactionLimit;
    }

    @Override
    public int getUserLimit() {
        return this.userLimit;
    }

    @Override
    public int getIPAddressLimit() {
        return this.ipAddress;
    }

    @Override
    public byte getIPAddressMask() {
        return this.ipMask;
    }

    @Override
    public String[] getProcessTypeLimit() {
        String[] res = null;
        if (this.typeLimit != null) {
            res = new String[this.typeLimit.length];
            System.arraycopy(this.typeLimit, 0, res, 0, this.typeLimit.length);
        }
        return res;
    }

    @Override
    public boolean isWebClientEnabled() {
        return this.isWebClientEnabled;
    }

    @Override
    public boolean isEscalationEnabled() {
        return this.isEscalationEnabled;
    }

    @Override
    public Map<String, Boolean> getProducts() {
        return Collections.unmodifiableMap(this.products);
    }

    @Override
    public boolean isProcessFlexibilityEnabled() {
        return this.isProcessFlexibilityEnabled;
    }

    @Override
    public String[] getProcessFlexibiltyEnabledTemplates() {
        String[] res = null;
        if (this.processFlexibilityTypes != null) {
            res = new String[this.processFlexibilityTypes.length];
            System.arraycopy(this.processFlexibilityTypes, 0, res, 0, this.processFlexibilityTypes.length);
        }
        return res;
    }

    @Override
    public boolean isRuntimeFlexibilityEnabled() {
        return this.isRuntimeFlexibilityEnabled;
    }

    @Override
    public String[] getRuntimeFlexibiltyEnabledTemplates() {
        String[] res = null;
        if (this.runtimeFlexibilityTypes != null) {
            res = new String[this.runtimeFlexibilityTypes.length];
            System.arraycopy(this.runtimeFlexibilityTypes, 0, res, 0, this.runtimeFlexibilityTypes.length);
        }
        return res;
    }

    @Override
    public Map<String, String> getAdditions() {
        return Collections.unmodifiableMap(this.additions);
    }

    @Override
    public String getLicenceDigest() {
        return this.licenceDigest;
    }

    @Override
    public String getLicenceSignature() {
        return this.licenceSignature;
    }

    @Override
    public String getXMLDocument() {
        return this.document;
    }

    public String toString() {
        String dist = "";
        if (this.getDistributorID() != null) {
            dist = " for " + this.getDistributorID();
        }
        StringBuilder mails = new StringBuilder("");
        for (String address : this.getMailAddresses()) {
            mails.append(";");
            mails.append(address);
        }
        if (mails.length() > 0) {
            mails.deleteCharAt(0);
        }
        String mailAddrs = String.format(" (%s)", mails.toString());
        String version = "\n  The licence is valid for version(s) (X = any): " + this.getVersion();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String time = this.getTimeLimitStart() != null ? String.format("\n  The licence is valid from %s until %s", sdf.format(this.getTimeLimitStart()), sdf.format(this.getTimeLimitEnd())) : "\n  The licence does not expire.";
        String users = "\n  The licence has no user limit.";
        if (this.getUserLimit() != 0) {
            users = String.format("\n  The licence is provided for a maximum of %d users.", this.getUserLimit());
        }
        String transactions = "\n  There is no transaction limit.";
        if (this.getTransactionLimit() != 0) {
            transactions = String.format("\n  The licence is provided for a maximum of %d transactions per day.", this.getTransactionLimit());
        }
        String types = "\n  Any process type may be executed.";
        if (this.getProcessTypeLimit() != null) {
            types = String.format("\n  The following process types may be executed: %s.", Arrays.toString(this.getProcessTypeLimit()));
        }
        String webclient = String.format("\n  The Web Client feature is %slicenced.", this.isWebClientEnabled() ? "" : "not ");
        String escalation = String.format("\n  The Escalation Feature is %slicenced.", this.isEscalationEnabled() ? "" : "not ");
        StringBuilder prods = new StringBuilder();
        for (Map.Entry<String, Boolean> entry : this.getProducts().entrySet()) {
            prods.append(String.format("\n  The %s is %slicenced.", entry.getKey(), entry.getValue() != false ? "" : "not "));
        }
        String procFlex = "\n  Process Flexibility is not licenced.";
        if (this.isProcessFlexibilityEnabled()) {
            String pfTypes = this.getProcessFlexibiltyEnabledTemplates() != null ? "the following types: " + Arrays.toString(this.getProcessFlexibiltyEnabledTemplates()) : "all process types";
            procFlex = String.format("\n  Process Flexibilty is licenced for %s.", pfTypes);
        }
        String runFlex = "\n  Runtime Flexibility is not licenced.";
        if (this.isProcessFlexibilityEnabled()) {
            String rfTypes = this.getRuntimeFlexibiltyEnabledTemplates() != null ? "the following types: " + Arrays.toString(this.getRuntimeFlexibiltyEnabledTemplates()) : "all process types";
            runFlex = String.format("\n  Runtime Flexibilty is licenced for %s.", rfTypes);
        }
        String addressString = "\n  The licence is not bound to an IP address.";
        if (this.getIPAddressLimit() != 0) {
            byte[] addr = new byte[4];
            addr[3] = Integer.valueOf(this.getIPAddressLimit()).byteValue();
            addr[2] = Integer.valueOf(this.getIPAddressLimit() >>> 8).byteValue();
            addr[1] = Integer.valueOf(this.getIPAddressLimit() >>> 16).byteValue();
            addr[0] = Integer.valueOf(this.getIPAddressLimit() >>> 24).byteValue();
            try {
                InetAddress address = InetAddress.getByAddress(addr);
                addressString = String.format("\n  The licence is bound to IP address %s/%s.", address.toString().substring(1), this.getIPAddressMask());
            }
            catch (UnknownHostException unknownHostException) {
                addressString = "\n  The licence is bound to an IP address.";
            }
        }
        return String.format("AristaFlow licence #%d issued to %s%s%s.%s%s%s%s%s%s%s%s%s%s%s", this.getLicenceID(), this.getLicensee(), mailAddrs, dist, version, time, users, transactions, addressString, types, webclient, escalation, prods.toString(), procFlex, runFlex);
    }

    public int hashCode() {
        HashCalc hash = new HashCalc(LicenceInformation.class);
        hash.feed(this.licenceID);
        hash.feed(this.customerID);
        hash.feed(this.distributorID);
        hash.feed(this.licenceType);
        hash.feed(this.licensee);
        String[] stringArray = this.mailAddresses;
        int n = this.mailAddresses.length;
        int n2 = 0;
        while (n2 < n) {
            String mailAddress = stringArray[n2];
            hash.feed(mailAddress);
            ++n2;
        }
        hash.feed(this.version);
        hash.feed((Object)this.activation);
        hash.feed(this.timeLimitStart);
        hash.feed(this.timeLimitEnd);
        hash.feed(this.transactionLimit);
        hash.feed(this.userLimit);
        hash.feed(this.ipAddress);
        hash.feed(this.ipMask);
        hash.feed(this.typeLimit);
        hash.feed(this.isWebClientEnabled);
        hash.feed(this.isEscalationEnabled);
        hash.feed(this.products);
        hash.feed(this.isProcessFlexibilityEnabled);
        hash.feed(this.processFlexibilityTypes);
        hash.feed(this.isRuntimeFlexibilityEnabled);
        hash.feed(this.runtimeFlexibilityTypes);
        hash.feed(this.additions);
        return hash.hashCode();
    }

    public boolean equals(Object other) {
        boolean ret = other instanceof LicenceInformation;
        if (ret) {
            LicenceInformation licence = (LicenceInformation)other;
            ret &= this.getLicenceID() == licence.getLicenceID();
            ret &= this.getCustomerID() == null ? licence.getCustomerID() == null : this.getCustomerID().equals(licence.getCustomerID());
            ret &= this.getDistributorID() == null ? licence.getDistributorID() == null : this.getDistributorID().equals(licence.getDistributorID());
            ret &= this.getLicenceType() == null ? licence.getLicenceType() == null : this.getLicenceType().equals(licence.getLicenceType());
            ret &= this.getLicensee() == null ? licence.getLicensee() == null : this.getLicensee().equals(licence.getLicensee());
            ret &= this.getMailAddresses().equals(licence.getMailAddresses());
            ret &= this.getVersion() == null ? licence.getVersion() == null : this.getVersion().equals(licence.getVersion());
            ret &= this.getActivation() == licence.getActivation();
            ret &= this.getTimeLimitStart() == null ? licence.getTimeLimitStart() == null : this.getTimeLimitStart().equals(licence.getTimeLimitStart());
            ret &= this.getTimeLimitEnd() == null ? licence.getTimeLimitEnd() == null : this.getTimeLimitEnd().equals(licence.getTimeLimitEnd());
            ret &= this.getTransactionLimit() == licence.getTransactionLimit();
            ret &= this.getUserLimit() == licence.getUserLimit();
            ret &= this.getIPAddressLimit() == licence.getIPAddressLimit();
            ret &= this.getIPAddressMask() == licence.getIPAddressMask();
            ret &= this.getProcessTypeLimit() == null ? licence.getProcessTypeLimit() == null : Arrays.equals(this.getProcessTypeLimit(), licence.getProcessTypeLimit());
            ret &= this.isWebClientEnabled() == licence.isWebClientEnabled();
            ret &= this.isEscalationEnabled() == licence.isEscalationEnabled();
            ret &= this.getProducts() == null ? licence.getProducts() == null : this.getProducts().equals(licence.getProducts());
            ret &= this.isProcessFlexibilityEnabled() == licence.isProcessFlexibilityEnabled();
            ret &= this.getProcessFlexibiltyEnabledTemplates() == null ? licence.getProcessFlexibiltyEnabledTemplates() == null : Arrays.equals(this.getProcessFlexibiltyEnabledTemplates(), licence.getProcessFlexibiltyEnabledTemplates());
            ret &= this.isRuntimeFlexibilityEnabled() == licence.isRuntimeFlexibilityEnabled();
            ret &= this.getRuntimeFlexibiltyEnabledTemplates() == null ? licence.getRuntimeFlexibiltyEnabledTemplates() == null : Arrays.equals(this.getRuntimeFlexibiltyEnabledTemplates(), licence.getRuntimeFlexibiltyEnabledTemplates());
            ret &= this.getAdditions() == null ? licence.getAdditions() == null : this.getAdditions().equals(licence.getAdditions());
        }
        return ret;
    }
}

