/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.common.defaultimplementation;

import de.aristaflow.adept2.model.common.ActivityConfiguration;
import de.aristaflow.adept2.model.common.Configuration;
import de.aristaflow.adept2.model.common.MergingActivityConfiguration;
import de.aristaflow.adept2.model.common.defaultimplementation.DefaultActivityConfiguration;
import de.aristaflow.adept2.model.common.defaultimplementation.DefaultMergingConfiguration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class DefaultMergingActivityConfiguration
extends DefaultMergingConfiguration
implements MergingActivityConfiguration {
    private static final long serialVersionUID = -5435769652332459882L;

    public DefaultMergingActivityConfiguration(ActivityConfiguration initialConfiguration) {
        super(initialConfiguration);
    }

    protected DefaultMergingActivityConfiguration(ActivityConfiguration initialConfiguration, int initialCapacity) {
        super(initialConfiguration, initialCapacity);
    }

    @Override
    public List<ActivityConfiguration> getConfigurations() {
        this.updateLock.readLock().lock();
        try {
            ArrayList<ActivityConfiguration> ret = new ArrayList<ActivityConfiguration>(this.configurations.size());
            for (Configuration configuration : this.configurations) {
                ret.add((ActivityConfiguration)configuration);
            }
            ArrayList<ActivityConfiguration> arrayList = ret;
            return arrayList;
        }
        finally {
            this.updateLock.readLock().unlock();
        }
    }

    @Override
    public void addFirst(ActivityConfiguration configuration) {
        super.addFirst(configuration);
    }

    @Override
    public void addLast(ActivityConfiguration configuration) {
        super.addLast(configuration);
    }

    @Override
    public String fromInputParameter(String entryName) {
        this.updateLock.readLock().lock();
        try {
            String ret = null;
            int fixed = this.getFixedConfiguration(entryName);
            if (fixed > -1) {
                ret = ((ActivityConfiguration)this.configurations.get(fixed)).fromInputParameter(entryName);
            } else {
                for (Configuration configuration : this.configurations) {
                    ret = ((ActivityConfiguration)configuration).fromInputParameter(entryName);
                    if (ret != null) break;
                }
            }
            String string = ret;
            return string;
        }
        finally {
            this.updateLock.readLock().unlock();
        }
    }

    @Override
    public String fromProcessConfiguration(String entryName) {
        this.updateLock.readLock().lock();
        try {
            String ret = null;
            int fixed = this.getFixedConfiguration(entryName);
            if (fixed > -1) {
                ret = ((ActivityConfiguration)this.configurations.get(fixed)).fromProcessConfiguration(entryName);
            } else {
                for (Configuration configuration : this.configurations) {
                    ret = ((ActivityConfiguration)configuration).fromProcessConfiguration(entryName);
                    if (ret != null) break;
                }
            }
            String string = ret;
            return string;
        }
        finally {
            this.updateLock.readLock().unlock();
        }
    }

    @Override
    public ActivityConfiguration getMergedConfiguration() {
        HashMap<String, String> values = new HashMap<String, String>();
        HashMap<String, String> fromParameters = new HashMap<String, String>();
        HashMap<String, String> fromConfigurations = new HashMap<String, String>();
        HashSet<String> fixed = new HashSet<String>();
        HashMap<String, String> configurationIDs = new HashMap<String, String>();
        this.updateLock.readLock().lock();
        try {
            String configurationID = null;
            ActivityConfiguration configuration = null;
            for (String entryName : this.getAllEntries()) {
                int index = this.getFixedConfiguration(entryName);
                if (index > -1) {
                    configuration = (ActivityConfiguration)this.configurations.get(index);
                    configurationID = ((Configuration)this.configurations.get(index)).getConfigurationID(entryName);
                    fixed.add(entryName);
                } else {
                    for (Configuration conf : this.configurations) {
                        if (conf.getString(entryName) == null && ((ActivityConfiguration)conf).fromInputParameter(entryName) == null && ((ActivityConfiguration)conf).fromProcessConfiguration(entryName) == null) continue;
                        configuration = (ActivityConfiguration)conf;
                        break;
                    }
                }
                if (configuration == null) continue;
                String value = configuration.fromInputParameter(entryName);
                if (value != null) {
                    fromParameters.put(entryName, value);
                }
                if ((value = configuration.fromProcessConfiguration(entryName)) != null) {
                    fromConfigurations.put(entryName, value);
                }
                if ((value = configuration.getString(entryName)) != null) {
                    values.put(entryName, value);
                }
                configurationIDs.put(entryName, configurationID);
            }
            DefaultActivityConfiguration defaultActivityConfiguration = new DefaultActivityConfiguration(values, fromParameters, fromConfigurations, fixed, configurationIDs);
            return defaultActivityConfiguration;
        }
        finally {
            this.updateLock.readLock().unlock();
        }
    }
}

