/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.common.defaultimplementation;

import de.aristaflow.adept2.model.common.Configuration;
import de.aristaflow.adept2.model.common.MergingConfiguration;
import de.aristaflow.adept2.model.common.defaultimplementation.DefaultConfiguration;
import de.aristaflow.adept2.util.ArgChecks;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.configuration.interpol.ConfigurationInterpolator;
import org.apache.commons.lang.text.StrLookup;
import org.apache.commons.lang.text.StrSubstitutor;

public class DefaultMergingConfiguration
implements MergingConfiguration {
    private static final long serialVersionUID = -4483557205806736214L;
    protected transient List<Configuration> configurations;
    protected transient ReadWriteLock updateLock;
    protected transient StrSubstitutor substitutor;

    public DefaultMergingConfiguration(Configuration initialConfiguration) {
        ArgChecks.checkForNull(initialConfiguration, "initialConfiguration");
        this.configurations = new ArrayList<Configuration>();
        this.configurations.add(initialConfiguration);
        this.updateLock = new ReentrantReadWriteLock();
        this.substitutor = new StrSubstitutor((StrLookup)new ConfigurationInterpolator());
    }

    protected DefaultMergingConfiguration(Configuration initialConfiguration, int initialCapacity) {
        ArgChecks.checkForNull(initialConfiguration, "initialConfiguration");
        this.configurations = new ArrayList<Configuration>(initialCapacity);
        this.configurations.add(initialConfiguration);
        this.updateLock = new ReentrantReadWriteLock();
        this.substitutor = new StrSubstitutor((StrLookup)new ConfigurationInterpolator());
    }

    @Override
    public List<? extends Configuration> getConfigurations() {
        this.updateLock.readLock().lock();
        try {
            ArrayList ret = new ArrayList(this.configurations.size());
            Collections.copy(ret, this.configurations);
            ArrayList arrayList = ret;
            return arrayList;
        }
        finally {
            this.updateLock.readLock().unlock();
        }
    }

    @Override
    public void addFirst(Configuration configuration) {
        ArgChecks.checkForNull(configuration, "configuration");
        this.updateLock.writeLock().lock();
        try {
            this.configurations.add(0, configuration);
        }
        finally {
            this.updateLock.writeLock().unlock();
        }
    }

    @Override
    public void addLast(Configuration configuration) {
        ArgChecks.checkForNull(configuration, "configuration");
        this.updateLock.writeLock().lock();
        try {
            this.configurations.add(configuration);
        }
        finally {
            this.updateLock.writeLock().unlock();
        }
    }

    @Override
    public Boolean getBoolean(String entryName) {
        this.updateLock.readLock().lock();
        try {
            Boolean ret = null;
            int fixed = this.getFixedConfiguration(entryName);
            if (fixed > -1) {
                ret = this.configurations.get(fixed).getBoolean(entryName);
            } else {
                for (Configuration configuration : this.configurations) {
                    ret = configuration.getBoolean(entryName);
                    if (ret != null) break;
                }
            }
            Boolean bl = ret;
            return bl;
        }
        finally {
            this.updateLock.readLock().unlock();
        }
    }

    @Override
    public Long getInteger(String entryName) {
        this.updateLock.readLock().lock();
        try {
            Long ret = null;
            int fixed = this.getFixedConfiguration(entryName);
            if (fixed > -1) {
                ret = this.configurations.get(fixed).getInteger(entryName);
            } else {
                for (Configuration configuration : this.configurations) {
                    ret = configuration.getInteger(entryName);
                    if (ret != null) break;
                }
            }
            Long l = ret;
            return l;
        }
        finally {
            this.updateLock.readLock().unlock();
        }
    }

    @Override
    public Double getFloat(String entryName) {
        this.updateLock.readLock().lock();
        try {
            Double ret = null;
            int fixed = this.getFixedConfiguration(entryName);
            if (fixed > -1) {
                ret = this.configurations.get(fixed).getFloat(entryName);
            } else {
                for (Configuration configuration : this.configurations) {
                    ret = configuration.getFloat(entryName);
                    if (ret != null) break;
                }
            }
            Double d = ret;
            return d;
        }
        finally {
            this.updateLock.readLock().unlock();
        }
    }

    @Override
    public String getString(String entryName) {
        this.updateLock.readLock().lock();
        try {
            String ret = null;
            int fixed = this.getFixedConfiguration(entryName);
            if (fixed > -1) {
                ret = this.configurations.get(fixed).getString(entryName);
            } else {
                for (Configuration configuration : this.configurations) {
                    ret = configuration.getString(entryName);
                    if (ret != null) break;
                }
            }
            String string = this.replaceVariables(ret);
            return string;
        }
        finally {
            this.updateLock.readLock().unlock();
        }
    }

    @Override
    public URI getURI(String entryName) {
        this.updateLock.readLock().lock();
        try {
            URI ret = null;
            int fixed = this.getFixedConfiguration(entryName);
            if (fixed > -1) {
                ret = this.configurations.get(fixed).getURI(entryName);
            } else {
                for (Configuration configuration : this.configurations) {
                    ret = configuration.getURI(entryName);
                    if (ret != null) break;
                }
            }
            URI uRI = ret;
            return uRI;
        }
        finally {
            this.updateLock.readLock().unlock();
        }
    }

    @Override
    public Date getDate(String entryName) {
        this.updateLock.readLock().lock();
        try {
            Date ret = null;
            int fixed = this.getFixedConfiguration(entryName);
            if (fixed > -1) {
                ret = this.configurations.get(fixed).getDate(entryName);
            } else {
                for (Configuration configuration : this.configurations) {
                    ret = configuration.getDate(entryName);
                    if (ret != null) break;
                }
            }
            Date date = ret;
            return date;
        }
        finally {
            this.updateLock.readLock().unlock();
        }
    }

    @Override
    public byte[] getUDT(String entryName) {
        this.updateLock.readLock().lock();
        try {
            byte[] ret = null;
            int fixed = this.getFixedConfiguration(entryName);
            if (fixed > -1) {
                ret = this.configurations.get(fixed).getUDT(entryName);
            } else {
                for (Configuration configuration : this.configurations) {
                    ret = configuration.getUDT(entryName);
                    if (ret != null) break;
                }
            }
            byte[] byArray = ret;
            return byArray;
        }
        finally {
            this.updateLock.readLock().unlock();
        }
    }

    @Override
    public boolean isFixed(String entryName) {
        this.updateLock.readLock().lock();
        try {
            int i = this.configurations.size();
            while (i > 0) {
                if (!this.configurations.get(--i).isFixed(entryName)) continue;
                return true;
            }
            return false;
        }
        finally {
            this.updateLock.readLock().unlock();
        }
    }

    @Override
    public Set<String> getAllEntries() {
        this.updateLock.readLock().lock();
        try {
            TreeSet<String> ret = new TreeSet<String>(this.configurations.get(0).getAllEntries());
            int i = 1;
            while (i < this.configurations.size()) {
                ret.addAll(this.configurations.get(i).getAllEntries());
                ++i;
            }
            TreeSet<String> treeSet = ret;
            return treeSet;
        }
        finally {
            this.updateLock.readLock().unlock();
        }
    }

    @Override
    public Configuration getMergedConfiguration() {
        HashMap<String, String> values = new HashMap<String, String>();
        HashSet<String> fixed = new HashSet<String>();
        HashMap<String, String> configurationIDs = new HashMap<String, String>();
        this.updateLock.readLock().lock();
        try {
            String value = null;
            String configurationID = null;
            for (String entryName : this.getAllEntries()) {
                int index = this.getFixedConfiguration(entryName);
                if (index > -1) {
                    value = this.configurations.get(index).getString(entryName);
                    configurationID = this.configurations.get(index).getConfigurationID(entryName);
                    fixed.add(entryName);
                } else {
                    for (Configuration configuration : this.configurations) {
                        value = configuration.getString(entryName);
                        if (value == null) continue;
                        configurationID = configuration.getConfigurationID(entryName);
                        break;
                    }
                }
                values.put(entryName, this.replaceVariables(value));
                configurationIDs.put(entryName, configurationID);
            }
            DefaultConfiguration defaultConfiguration = new DefaultConfiguration(values, fixed, configurationIDs);
            return defaultConfiguration;
        }
        finally {
            this.updateLock.readLock().unlock();
        }
    }

    @Override
    public String getConfigurationID(String entryName) {
        this.updateLock.readLock().lock();
        try {
            String ret = null;
            int fixed = this.getFixedConfiguration(entryName);
            if (fixed > -1) {
                ret = this.configurations.get(fixed).getConfigurationID(entryName);
            } else {
                for (Configuration configuration : this.configurations) {
                    ret = configuration.getConfigurationID(entryName);
                    if (ret != null) break;
                }
            }
            String string = ret;
            return string;
        }
        finally {
            this.updateLock.readLock().unlock();
        }
    }

    protected int getFixedConfiguration(String entryName) {
        int ret = this.configurations.size();
        while (ret > 0) {
            if (!this.configurations.get(--ret).isFixed(entryName)) continue;
            return ret;
        }
        return -1;
    }

    protected String replaceVariables(String unreplaced) {
        String ret = this.substitutor != null ? this.substitutor.replace(unreplaced) : unreplaced;
        return ret;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.getMergedConfiguration());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.configurations = new ArrayList<Configuration>();
        this.configurations.add((Configuration)in.readObject());
        this.updateLock = new ReentrantReadWriteLock();
        this.substitutor = null;
    }
}

