/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.common.defaultimplementation;

import de.aristaflow.adept2.model.common.ActivityConfiguration;
import de.aristaflow.adept2.model.common.Parameter;
import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.model.common.defaultimplementation.DefaultActivityConfiguration;
import de.aristaflow.adept2.model.common.defaultimplementation.SerialisablePluginDataContainer;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.util.ArgChecks;
import java.util.Map;
import java.util.UUID;

public abstract class DefaultParameter
extends SerialisablePluginDataContainer
implements Parameter {
    protected String name;
    protected String description;
    protected ProcessConstants.AdeptDataType dataType;
    protected String udtName;
    protected UUID identifierID;
    protected boolean isOptional;
    protected boolean isVirtual;
    protected boolean isFailure;
    protected String defaultValue;
    protected ActivityConfiguration configuration;

    protected DefaultParameter(PluginDataContainer pluginData, Map<String, String> userAttributes) {
        super(pluginData, userAttributes);
    }

    protected DefaultParameter(String name, String description, ProcessConstants.AdeptDataType dataType, String udtName, UUID identifierID, boolean isOptional, boolean isVirtual, boolean isFailure, String defaultValue, ActivityConfiguration configuration, PluginDataContainer pluginData, Map<String, String> userAttributes) {
        super(pluginData, userAttributes);
        ArgChecks.checkForNull(identifierID, "identifierID");
        this.setName(name);
        this.setDescription(description);
        if (dataType != ProcessConstants.AdeptDataType.USERDEFINED && "".equals(udtName)) {
            udtName = null;
        }
        this.setDataType(dataType, udtName);
        this.identifierID = identifierID;
        this.isOptional = isOptional;
        this.isVirtual = isVirtual;
        this.isFailure = isFailure;
        this.setDefaultValue(defaultValue);
        this.setConfiguration(configuration);
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        ArgChecks.checkForEmpty(name, "name");
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    protected void setDescription(String description) {
        ArgChecks.checkForNull(description, "description");
        this.description = description;
    }

    @Override
    public ProcessConstants.AdeptDataType getDataType() {
        return this.dataType;
    }

    @Override
    public String getUDTName() {
        if (this.dataType == ProcessConstants.AdeptDataType.USERDEFINED) {
            return this.udtName;
        }
        return null;
    }

    protected void setDataType(ProcessConstants.AdeptDataType dataType, String udtName) {
        if (dataType == ProcessConstants.AdeptDataType.USERDEFINED) {
            if (udtName == null) {
                throw new IllegalArgumentException("UDT name must not be null for USERDEFINED");
            }
            this.dataType = dataType;
            this.udtName = udtName;
        } else if (dataType != null) {
            if (udtName != null) {
                throw new IllegalArgumentException("UDT name must be null for anything else than USERDEFINED");
            }
            this.dataType = dataType;
            this.udtName = null;
        } else {
            this.dataType = null;
            this.udtName = null;
        }
    }

    @Override
    public UUID getIdentifierID() {
        return this.identifierID;
    }

    @Override
    public boolean isOptional() {
        return this.isOptional;
    }

    @Override
    public boolean isVirtual() {
        return this.isVirtual;
    }

    @Override
    public boolean isFailure() {
        return this.isFailure;
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    protected void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public ActivityConfiguration getConfiguration() {
        return new DefaultActivityConfiguration(this.configuration);
    }

    protected void setConfiguration(ActivityConfiguration configuration) {
        this.configuration = new DefaultActivityConfiguration(configuration);
    }
}

