/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.common.defaultimplementation;

import de.aristaflow.adept2.model.common.PluginData;
import de.aristaflow.adept2.util.ArgChecks;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DefaultPluginData
implements PluginData,
Serializable {
    private static final long serialVersionUID = -7392723595606758318L;
    protected final String pluginID;
    protected final HashMap<String, String> pluginData;

    public DefaultPluginData(String pluginID) {
        this(pluginID, null);
    }

    public DefaultPluginData(String pluginID, Map<String, String> pluginData) {
        ArgChecks.checkForNull(pluginID, "pluginID");
        this.pluginID = pluginID;
        if (pluginData == null) {
            this.pluginData = new HashMap();
        } else {
            ArgChecks.checkForNullKey(pluginData, "pluginData");
            this.pluginData = new HashMap<String, String>(pluginData);
        }
    }

    @Override
    public String getPluginID() {
        return this.pluginID;
    }

    @Override
    public Map<String, String> getPluginData() {
        return Collections.unmodifiableMap(this.pluginData);
    }

    @Override
    public String getPluginDataEntry(String key) {
        return this.pluginData.get(key);
    }
}

