/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.common.defaultimplementation;

import de.aristaflow.adept2.model.common.PluginData;
import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.model.common.defaultimplementation.DefaultPluginData;
import de.aristaflow.adept2.model.common.defaultimplementation.DefaultUserAttributeContainer;
import de.aristaflow.adept2.util.LoggerTools;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DefaultPluginDataContainer
extends DefaultUserAttributeContainer
implements PluginDataContainer {
    protected HashMap<String, Set<String>> supportedPlugins = new HashMap();
    protected HashMap<String, PluginData> pluginData = new HashMap();

    public DefaultPluginDataContainer() {
        this(null, null, null);
    }

    public DefaultPluginDataContainer(PluginDataContainer pluginData) {
        this(pluginData, null);
    }

    public DefaultPluginDataContainer(PluginDataContainer pluginData, Map<String, String> userAttributes) {
        super(userAttributes);
        if (pluginData != null) {
            for (Map.Entry<String, Set<String>> pdcEntry : pluginData.getSupportedPlugins().entrySet()) {
                for (String pluginID : pdcEntry.getValue()) {
                    PluginData pluginDataElement = pluginData.getPluginDatas().get(pluginID);
                    if (pluginDataElement == null) continue;
                    this.addSupportedPlugin(pdcEntry.getKey(), pluginID, pluginDataElement);
                }
            }
        }
    }

    public DefaultPluginDataContainer(Map<String, Set<String>> supportedPlugins, Map<String, PluginData> pluginData, Map<String, String> userAttributes) {
        super(userAttributes);
        if (supportedPlugins != null && pluginData != null) {
            for (Map.Entry<String, Set<String>> pdcEntry : supportedPlugins.entrySet()) {
                for (String pluginID : pdcEntry.getValue()) {
                    if (!pluginData.containsKey(pluginID)) continue;
                    this.addSupportedPlugin(pdcEntry.getKey(), pluginID, pluginData.get(pluginID));
                }
            }
        }
    }

    @Override
    public PluginData getPluginData(String pluginID) {
        return this.pluginData.get(pluginID);
    }

    @Override
    public Map<String, Set<String>> getSupportedPlugins() {
        HashMap<String, Set<String>> ret = new HashMap<String, Set<String>>();
        for (Map.Entry<String, Set<String>> entry : this.supportedPlugins.entrySet()) {
            ret.put(entry.getKey(), Collections.unmodifiableSet(entry.getValue()));
        }
        return Collections.unmodifiableMap(ret);
    }

    @Override
    public Map<String, PluginData> getPluginDatas() {
        return Collections.unmodifiableMap(this.pluginData);
    }

    public void addSupportedPlugin(String extensionPointID, String pluginID, PluginData data) {
        Set<Object> plugins;
        if (data != null && !pluginID.equals(data.getPluginID())) {
            String msg = "The given pluginID '%s' does not match the pluginID '%s' of the given PluginData-object!";
            msg = String.format(msg, pluginID, data.getPluginID());
            LoggerTools.getLogger(this.getClass()).severe(msg);
        }
        if (this.supportedPlugins.containsKey(extensionPointID)) {
            plugins = this.supportedPlugins.get(extensionPointID);
        } else {
            plugins = new HashSet();
            this.supportedPlugins.put(extensionPointID, plugins);
        }
        plugins.add(pluginID);
        if (data == null) {
            data = new DefaultPluginData(pluginID);
        }
        this.pluginData.put(pluginID, data);
    }

    public void removeSupportedPlugin(String pluginID) {
        Iterator<Set<String>> it = this.supportedPlugins.values().iterator();
        while (it.hasNext()) {
            Set<String> pluginSets = it.next();
            pluginSets.remove(pluginID);
            if (pluginSets.size() != 0) continue;
            it.remove();
        }
        this.pluginData.remove(pluginID);
    }
}

