/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.common.defaultimplementation;

import de.aristaflow.adept2.model.common.UserAttributeContainer;
import de.aristaflow.adept2.util.ArgChecks;
import java.util.HashMap;
import java.util.Map;

public class DefaultUserAttributeContainer
implements UserAttributeContainer {
    protected HashMap<String, String> userAttributes;

    public DefaultUserAttributeContainer() {
        this(null);
    }

    public DefaultUserAttributeContainer(Map<String, String> userAttributes) {
        if (userAttributes == null) {
            this.userAttributes = new HashMap();
        } else {
            ArgChecks.checkForNullKey(userAttributes, "userAttributes");
            this.userAttributes = new HashMap<String, String>(userAttributes);
        }
    }

    @Override
    public String getUserAttributeValue(String attributeName) {
        ArgChecks.checkForNull(attributeName, "attributeName");
        return this.userAttributes.get(attributeName);
    }

    @Override
    public void setUserAttributeValue(String attributeName, String attributeValue) {
        ArgChecks.checkForNull(attributeName, "attributeName");
        this.userAttributes.put(attributeName, attributeValue);
    }

    @Override
    public void removeUserAttributeValue(String attributeName) {
        ArgChecks.checkForNull(attributeName, "attributeName");
        this.userAttributes.remove(attributeName);
    }

    @Override
    public Map<String, String> getUserAttributes() {
        return new HashMap<String, String>(this.userAttributes);
    }

    public void setUserAttributes(Map<String, String> userAttributes) {
        if (userAttributes == null) {
            this.userAttributes.clear();
        } else {
            ArgChecks.checkForNullKey(userAttributes, "userAttributes");
            this.userAttributes.clear();
            this.userAttributes.putAll(userAttributes);
        }
    }
}

