/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.common.i18n;

import de.aristaflow.adept2.model.common.PluginDataContainer;
import de.aristaflow.adept2.model.common.i18n.Localised;
import de.aristaflow.adept2.util.i18n.AristaFlowBundle;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class LocalisationResolver
implements InvocationHandler,
Serializable {
    private static final long serialVersionUID = 3741905956762582444L;
    public static final String PLUGIN_LOCALISED = "ProcessLocalisation";
    private transient PluginDataContainer target;
    private final Serializable serialisableTarget;
    private final Locale locale;
    private transient Map<String, String> translations;

    protected LocalisationResolver(Object target, Locale locale) {
        this.target = (PluginDataContainer)target;
        this.serialisableTarget = target instanceof Serializable ? (Serializable)target : null;
        this.locale = locale;
    }

    private PluginDataContainer getTarget() {
        if (this.target == null) {
            this.target = (PluginDataContainer)((Object)this.serialisableTarget);
        }
        return this.target;
    }

    private Map<String, String> getTranslations() {
        if (this.translations == null) {
            this.translations = this.getTarget().getPluginData(PLUGIN_LOCALISED).getPluginData();
        }
        return this.translations;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String key;
        String translation;
        if (method.isAnnotationPresent(Localised.class) && (translation = this.getTranslation(key = method.getAnnotation(Localised.class).value())) != null) {
            return translation;
        }
        return method.invoke((Object)this.getTarget(), args);
    }

    private String getTranslation(String key) {
        List<String> keys = AristaFlowBundle.getBundleKeyNames(this.locale);
        int i = keys.size() - 1;
        while (i >= 0) {
            String translation = this.getTranslations().get(String.valueOf(key) + "." + keys.get(i));
            if (translation != null) {
                return translation;
            }
            --i;
        }
        return null;
    }

    public static <T extends PluginDataContainer> T createLocalisedView(Class<T> clazz, T target, Locale locale) {
        Object ret;
        if (!clazz.isInterface()) {
            String msg = "The given class object %s is not an interface.";
            throw new IllegalArgumentException(String.format(msg, clazz));
        }
        if (!clazz.isAssignableFrom(target.getClass())) {
            String msg = "The target object type (%s) does not implement the requested interface (%s).";
            msg = String.format(msg, target.getClass(), clazz);
            throw new IllegalArgumentException(msg);
        }
        if (locale == null || target.getPluginData(PLUGIN_LOCALISED) == null) {
            ret = target;
        } else {
            List<Class<?>> ifacesList = LocalisationResolver.getAllInterfaces(target.getClass());
            Class[] ifaces = ifacesList.toArray(new Class[ifacesList.size()]);
            ret = (PluginDataContainer)Proxy.newProxyInstance(LocalisationResolver.class.getClassLoader(), ifaces, (InvocationHandler)new LocalisationResolver(target, locale));
        }
        return ret;
    }

    static List<Class<?>> getAllInterfaces(Class<?> cls) {
        ArrayList ret = new ArrayList();
        ArrayList clss = new ArrayList();
        clss.add(cls);
        int index = 0;
        do {
            Class current;
            Class sup;
            if ((sup = (current = (Class)clss.get(index)).getSuperclass()) != null) {
                clss.add(sup);
            }
            Class<?>[] classArray = current.getInterfaces();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> iface = classArray[n2];
                ret.add(iface);
                ++n2;
            }
        } while (++index < clss.size());
        return ret;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.serialisableTarget == null) {
            throw new NotSerializableException("The target " + this.target.getClass() + " is not serialisable!");
        }
        out.defaultWriteObject();
    }
}

