/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.common.paramref;

import de.aristaflow.adept2.model.common.paramref.ParameterRef;
import de.aristaflow.adept2.model.common.paramref.ParameterRefTools;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.util.ArgChecks;

public class IOParameterRef
extends ParameterRef {
    private static final long serialVersionUID = -2532655968372683061L;
    private String outputName;

    public IOParameterRef(ProcessConstants.AdeptDataType dataType, String inputName, String outputName) {
        super(dataType, inputName);
        if (outputName != null) {
            ArgChecks.checkForEmpty(outputName, "outputName");
        }
        this.outputName = outputName;
    }

    @Override
    public String getName() {
        return super.getName();
    }

    public String getOutputName() {
        return this.outputName;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("%").append(ParameterRefTools.toTypeKey(this.getDataType())).append(":");
        if (this.getName() != null) {
            sb.append(this.getName());
        }
        if (this.outputName != null) {
            sb.append(":").append(this.outputName);
        }
        return sb.toString();
    }
}

