/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.common.paramref;

import de.aristaflow.adept2.model.common.paramref.IOParameterRef;
import de.aristaflow.adept2.model.common.paramref.ParameterRefTools;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.util.ArgChecks;
import java.util.EnumSet;
import java.util.regex.Matcher;

public class IOParameterRefParser {
    Matcher matcher;
    IOParameterRef paramRef;
    EnumSet<ProcessConstants.AdeptDataType> consideredDataTypes;

    IOParameterRefParser(String parameterisedString, EnumSet<ProcessConstants.AdeptDataType> consideredDataTypes) {
        ArgChecks.checkForNull(parameterisedString, "parameterisedString");
        ArgChecks.checkForNull(consideredDataTypes, "consideredDataTypes");
        this.consideredDataTypes = consideredDataTypes;
        this.matcher = ParameterRefTools.IO_PARAMETER_REF_PATTERN.matcher(parameterisedString);
    }

    public boolean findNext() {
        while (this.matcher.find()) {
            this.paramRef = ParameterRefTools.parseIOParameterReference(this.matcher.group(), this.consideredDataTypes);
            if (this.paramRef == null) continue;
            return true;
        }
        return false;
    }

    public IOParameterRef getParameterRef() {
        if (this.paramRef == null) {
            throw new IllegalStateException("no matched parameter ref");
        }
        return this.paramRef;
    }

    public ProcessConstants.AdeptDataType getDataType() {
        if (this.paramRef == null) {
            throw new IllegalStateException("no matched parameter ref");
        }
        return this.paramRef.getDataType();
    }

    public String getInputName() {
        if (this.paramRef == null) {
            throw new IllegalStateException("no matched parameter ref");
        }
        return this.paramRef.getName();
    }

    public String getOutputName() {
        if (this.paramRef == null) {
            throw new IllegalStateException("no matched parameter ref");
        }
        return this.paramRef.getOutputName();
    }

    public int getStart() {
        if (this.paramRef == null) {
            throw new IllegalStateException("no matched parameter ref");
        }
        return this.matcher.start();
    }

    public int getEnd() {
        if (this.paramRef == null) {
            throw new IllegalStateException("no matched parameter ref");
        }
        return this.matcher.end();
    }
}

