/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.common.paramref;

import de.aristaflow.adept2.model.common.paramref.IOParameterRefParser;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.util.ArgChecks;
import java.util.EnumSet;
import java.util.regex.Matcher;

public class IOParameterRefReplacer
extends IOParameterRefParser {
    private StringBuffer processedString = new StringBuffer();
    private boolean finished = false;

    IOParameterRefReplacer(String parameterisedString, EnumSet<ProcessConstants.AdeptDataType> consideredDataTypes) {
        super(parameterisedString, consideredDataTypes);
    }

    @Override
    public boolean findNext() {
        boolean found = super.findNext();
        if (!found && !this.finished) {
            this.finished = true;
            this.matcher.appendTail(this.processedString);
        }
        return found;
    }

    public void replaceWith(String string) {
        ArgChecks.checkForNull(string, "string");
        if (this.paramRef == null) {
            throw new IllegalStateException("no matched parameter ref");
        }
        string = Matcher.quoteReplacement(string);
        this.matcher.appendReplacement(this.processedString, string);
    }

    public String getProcessedString() {
        return this.processedString.toString();
    }
}

