/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.common.paramref;

import de.aristaflow.adept2.model.common.paramref.ParameterRef;
import de.aristaflow.adept2.model.common.paramref.ParameterRefTools;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.util.ArgChecks;
import java.util.EnumSet;
import java.util.regex.Matcher;

public class ParameterRefParser {
    String parameterisedString;
    Matcher matcher;
    ParameterRef paramRef;
    EnumSet<ProcessConstants.AdeptDataType> consideredDataTypes;

    ParameterRefParser(String parameterisedString, EnumSet<ProcessConstants.AdeptDataType> consideredDataTypes) {
        ArgChecks.checkForNull(parameterisedString, "parameterisedString");
        ArgChecks.checkForNull(consideredDataTypes, "consideredDataTypes");
        this.parameterisedString = parameterisedString;
        this.matcher = ParameterRefTools.PARAMETER_REF_PATTERN.matcher(parameterisedString);
        this.consideredDataTypes = consideredDataTypes;
    }

    public String getParameterisedString() {
        return this.parameterisedString;
    }

    public boolean findNext() {
        while (this.matcher.find()) {
            this.paramRef = ParameterRefTools.parseParameterReference(this.matcher.group(), this.consideredDataTypes);
            if (this.paramRef == null) continue;
            return true;
        }
        return false;
    }

    public ParameterRef getParameterRef() {
        if (this.paramRef == null) {
            throw new IllegalStateException("no matched parameter ref");
        }
        return this.paramRef;
    }

    public ProcessConstants.AdeptDataType getDataType() {
        if (this.paramRef == null) {
            throw new IllegalStateException("no matched parameter ref");
        }
        return this.paramRef.getDataType();
    }

    public String getName() {
        if (this.paramRef == null) {
            throw new IllegalStateException("no matched parameter ref");
        }
        return this.paramRef.getName();
    }

    public int getStart() {
        if (this.paramRef == null) {
            throw new IllegalStateException("no matched parameter ref");
        }
        return this.matcher.start();
    }

    public int getEnd() {
        if (this.paramRef == null) {
            throw new IllegalStateException("no matched parameter ref");
        }
        return this.matcher.end();
    }
}

