/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.common.paramref;

import de.aristaflow.adept2.model.common.paramref.IOParameterRef;
import de.aristaflow.adept2.model.common.paramref.IOParameterRefParser;
import de.aristaflow.adept2.model.common.paramref.IOParameterRefReplacer;
import de.aristaflow.adept2.model.common.paramref.ParameterRef;
import de.aristaflow.adept2.model.common.paramref.ParameterRefParser;
import de.aristaflow.adept2.model.common.paramref.ParameterRefReplacer;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.util.ArgChecks;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ParameterRefTools {
    public static final Pattern PARAMETER_REF_PATTERN = Pattern.compile("%([a-z]):([^%]*(?:%%[^%]*)*)%", 2);
    public static final Pattern IO_PARAMETER_REF_PATTERN = Pattern.compile("%([a-z]):([^%]*?(?:%%[^%]*)*)(?::([^%]*(?:%%[^%]*)*))?%", 2);
    private static final EnumSet<ProcessConstants.AdeptDataType> ALL_DATA_TYPES = EnumSet.allOf(ProcessConstants.AdeptDataType.class);

    public static ParameterRef[] findParameterReferences(String parameterisedString, EnumSet<ProcessConstants.AdeptDataType> consideredDataTypes) {
        ArgChecks.checkForNull(parameterisedString, "parameterisedString");
        if (consideredDataTypes == null) {
            consideredDataTypes = ALL_DATA_TYPES;
        }
        ArrayList<ParameterRef> paramRefs = new ArrayList<ParameterRef>();
        Matcher matcher = PARAMETER_REF_PATTERN.matcher(parameterisedString);
        block0: while (matcher.find()) {
            ParameterRef parsedRef = ParameterRefTools.parseParameterReference(matcher.group(0), consideredDataTypes);
            if (parsedRef == null) continue;
            for (ParameterRef paramRef : paramRefs) {
                if (paramRef.getName().equals(parsedRef.getName()) && paramRef.getDataType() == parsedRef.getDataType()) continue block0;
            }
            paramRefs.add(parsedRef);
        }
        return paramRefs.toArray(new ParameterRef[paramRefs.size()]);
    }

    public static IOParameterRef[] findIOParameterReferences(String parameterisedString, EnumSet<ProcessConstants.AdeptDataType> consideredDataTypes) {
        ArgChecks.checkForNull(parameterisedString, "parameterisedString");
        if (consideredDataTypes == null) {
            consideredDataTypes = ALL_DATA_TYPES;
        }
        ArrayList<IOParameterRef> paramRefs = new ArrayList<IOParameterRef>();
        Matcher matcher = IO_PARAMETER_REF_PATTERN.matcher(parameterisedString);
        block0: while (matcher.find()) {
            IOParameterRef parsedRef = ParameterRefTools.parseIOParameterReference(matcher.group(0), consideredDataTypes);
            if (parsedRef == null) continue;
            for (IOParameterRef paramRef : paramRefs) {
                boolean sameInputName = paramRef.getName() == null ? parsedRef.getName() == null : paramRef.getName().equals(parsedRef.getName());
                boolean sameOutputName = paramRef.getOutputName() == null ? parsedRef.getOutputName() == null : paramRef.getOutputName().equals(parsedRef.getOutputName());
                if (paramRef.getDataType() == parsedRef.getDataType() && sameInputName && sameOutputName) continue block0;
            }
            paramRefs.add(parsedRef);
        }
        return paramRefs.toArray(new IOParameterRef[paramRefs.size()]);
    }

    public static ParameterRef[] listParameterReferences(String parameterisedString, EnumSet<ProcessConstants.AdeptDataType> consideredDataTypes) {
        ArgChecks.checkForNull(parameterisedString, "parameterisedString");
        if (consideredDataTypes == null) {
            consideredDataTypes = ALL_DATA_TYPES;
        }
        ArrayList<ParameterRef> paramRefs = new ArrayList<ParameterRef>();
        Matcher matcher = PARAMETER_REF_PATTERN.matcher(parameterisedString);
        while (matcher.find()) {
            ParameterRef parsedRef = ParameterRefTools.parseParameterReference(matcher.group(0), consideredDataTypes);
            if (parsedRef == null) continue;
            paramRefs.add(parsedRef);
        }
        return paramRefs.toArray(new ParameterRef[paramRefs.size()]);
    }

    public static IOParameterRef[] listIOParameterReferences(String parameterisedString, EnumSet<ProcessConstants.AdeptDataType> consideredDataTypes) {
        ArgChecks.checkForNull(parameterisedString, "parameterisedString");
        if (consideredDataTypes == null) {
            consideredDataTypes = ALL_DATA_TYPES;
        }
        ArrayList<IOParameterRef> paramRefs = new ArrayList<IOParameterRef>();
        Matcher matcher = IO_PARAMETER_REF_PATTERN.matcher(parameterisedString);
        while (matcher.find()) {
            IOParameterRef parsedRef = ParameterRefTools.parseIOParameterReference(matcher.group(0), consideredDataTypes);
            if (parsedRef == null) continue;
            paramRefs.add(parsedRef);
        }
        return paramRefs.toArray(new IOParameterRef[paramRefs.size()]);
    }

    public static ParameterRef parseParameterReference(String parameterReference, EnumSet<ProcessConstants.AdeptDataType> consideredDataTypes) {
        Matcher matcher;
        ArgChecks.checkForNull(parameterReference, "parameterReference");
        if (consideredDataTypes == null) {
            consideredDataTypes = ALL_DATA_TYPES;
        }
        if ((matcher = PARAMETER_REF_PATTERN.matcher(parameterReference)).matches()) {
            String type = matcher.group(1);
            String name = matcher.group(2);
            if (name.equals("")) {
                return null;
            }
            name = name.replace("%%", "%");
            ProcessConstants.AdeptDataType dataType = ParameterRefTools.fromTypeKey(type);
            if (dataType == null) {
                return null;
            }
            if (!consideredDataTypes.contains((Object)dataType)) {
                return null;
            }
            return new ParameterRef(dataType, name);
        }
        return null;
    }

    public static IOParameterRef parseIOParameterReference(String parameterReference, EnumSet<ProcessConstants.AdeptDataType> consideredDataTypes) {
        Matcher matcher;
        ArgChecks.checkForNull(parameterReference, "parameterReference");
        if (consideredDataTypes == null) {
            consideredDataTypes = ALL_DATA_TYPES;
        }
        if ((matcher = IO_PARAMETER_REF_PATTERN.matcher(parameterReference)).matches()) {
            ProcessConstants.AdeptDataType dataType;
            String type = matcher.group(1);
            String inputName = matcher.group(2);
            String outputName = matcher.group(3);
            if (inputName.equals("")) {
                inputName = null;
            }
            if (outputName != null && outputName.equals("")) {
                outputName = null;
            }
            if (inputName != null) {
                inputName = inputName.replace("%%", "%");
            }
            if (outputName != null) {
                outputName = outputName.replace("%%", "%");
            }
            if ((dataType = ParameterRefTools.fromTypeKey(type)) == null) {
                return null;
            }
            if (!consideredDataTypes.contains((Object)dataType)) {
                return null;
            }
            return new IOParameterRef(dataType, inputName, outputName);
        }
        return null;
    }

    public static ParameterRefParser getParser(String parameterisedString, EnumSet<ProcessConstants.AdeptDataType> consideredDataTypes) {
        if (consideredDataTypes == null) {
            consideredDataTypes = ALL_DATA_TYPES;
        }
        return new ParameterRefParser(parameterisedString, consideredDataTypes);
    }

    public static ParameterRefReplacer getReplacer(String parameterisedString, EnumSet<ProcessConstants.AdeptDataType> consideredDataTypes) {
        if (consideredDataTypes == null) {
            consideredDataTypes = ALL_DATA_TYPES;
        }
        return new ParameterRefReplacer(parameterisedString, consideredDataTypes);
    }

    public static IOParameterRefParser getIOParser(String parameterisedString, EnumSet<ProcessConstants.AdeptDataType> consideredDataTypes) {
        if (consideredDataTypes == null) {
            consideredDataTypes = ALL_DATA_TYPES;
        }
        return new IOParameterRefParser(parameterisedString, consideredDataTypes);
    }

    public static IOParameterRefReplacer getIOReplacer(String parameterisedString, EnumSet<ProcessConstants.AdeptDataType> consideredDataTypes) {
        if (consideredDataTypes == null) {
            consideredDataTypes = ALL_DATA_TYPES;
        }
        return new IOParameterRefReplacer(parameterisedString, consideredDataTypes);
    }

    public static String toTypeKey(ProcessConstants.AdeptDataType dataType) {
        ArgChecks.checkForNull((Object)dataType, "dataType");
        switch (dataType) {
            case BOOLEAN: {
                return "b";
            }
            case INTEGER: {
                return "i";
            }
            case FLOAT: {
                return "f";
            }
            case STRING: {
                return "s";
            }
            case URI: {
                return "r";
            }
            case DATE: {
                return "d";
            }
            case USERDEFINED: {
                return "u";
            }
        }
        throw new AssertionError((Object)((Object)((Object)dataType) + " not supported/implemented"));
    }

    public static ProcessConstants.AdeptDataType fromTypeKey(String typeKey) {
        ArgChecks.checkForNull(typeKey, "typeId");
        if (typeKey.equalsIgnoreCase("b")) {
            return ProcessConstants.AdeptDataType.BOOLEAN;
        }
        if (typeKey.equalsIgnoreCase("i")) {
            return ProcessConstants.AdeptDataType.INTEGER;
        }
        if (typeKey.equalsIgnoreCase("f")) {
            return ProcessConstants.AdeptDataType.FLOAT;
        }
        if (typeKey.equalsIgnoreCase("s")) {
            return ProcessConstants.AdeptDataType.STRING;
        }
        if (typeKey.equalsIgnoreCase("d")) {
            return ProcessConstants.AdeptDataType.DATE;
        }
        if (typeKey.equalsIgnoreCase("r")) {
            return ProcessConstants.AdeptDataType.URI;
        }
        if (typeKey.equalsIgnoreCase("u")) {
            return ProcessConstants.AdeptDataType.USERDEFINED;
        }
        return null;
    }

    private ParameterRefTools() {
    }
}

