/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.common.systemdata;

import de.aristaflow.adept2.model.common.systemdata.SystemDataFormatter;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import java.net.URI;
import java.util.Date;
import java.util.Map;

public abstract class AbstractSystemDataFormatter
implements SystemDataFormatter {
    protected void ensureValuePresent(String parameterName, Map<String, Object> parameterValues) {
        if (!parameterValues.containsKey(parameterName)) {
            String msg = "value for parameter '%s' is missing";
            msg = String.format(msg, parameterName);
            throw new IllegalArgumentException(msg);
        }
    }

    protected void ensureCorrectType(ProcessConstants.AdeptDataType expectedType, Object value) {
        if (value == null) {
            return;
        }
        Class expectedObjectType = null;
        switch (expectedType) {
            case INTEGER: {
                if (value.getClass() == Long.class) break;
                expectedObjectType = Long.class;
                break;
            }
            case FLOAT: {
                if (value.getClass() == Double.class) break;
                expectedObjectType = Double.class;
                break;
            }
            case STRING: {
                if (value.getClass() == String.class) break;
                expectedObjectType = String.class;
                break;
            }
            case DATE: {
                if (value.getClass() == Date.class) break;
                expectedObjectType = Date.class;
                break;
            }
            case BOOLEAN: {
                if (value.getClass() == Boolean.class) break;
                expectedObjectType = Boolean.class;
                break;
            }
            case URI: {
                if (value.getClass() == URI.class) break;
                expectedObjectType = URI.class;
                break;
            }
            default: {
                throw new AssertionError((Object)("unhandled data type: " + (Object)((Object)expectedType)));
            }
        }
        if (expectedObjectType != null) {
            String msg = "encountered object type: %s, expected object type: %s";
            msg = String.format(msg, value.getClass(), expectedObjectType);
            throw new IllegalArgumentException(msg);
        }
    }
}

