/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.common.systemdata;

import de.aristaflow.adept2.model.common.paramref.ParameterRefReplacer;
import de.aristaflow.adept2.model.common.systemdata.AbstractSystemDataFormatter;
import de.aristaflow.adept2.model.common.systemdata.SystemDataTools;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.util.ArgChecks;
import java.text.SimpleDateFormat;
import java.util.Map;

public class BasicSystemDataFormatter
extends AbstractSystemDataFormatter {
    @Override
    public String format(String parameterisedString, Map<String, Object> parameterValues) {
        ArgChecks.checkForNull(parameterisedString, "parameterisedString");
        ArgChecks.checkForNull(parameterValues, "parameterValues");
        ParameterRefReplacer formatter = SystemDataTools.getReplacer(parameterisedString);
        while (formatter.findNext()) {
            String replacement;
            this.ensureValuePresent(formatter.getName(), parameterValues);
            Object value = parameterValues.get(formatter.getName());
            this.ensureCorrectType(formatter.getDataType(), value);
            if (value == null) {
                formatter.replaceWith("<not set>");
                continue;
            }
            if (formatter.getDataType() == ProcessConstants.AdeptDataType.DATE) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                replacement = dateFormat.format(value);
            } else {
                replacement = value.toString();
            }
            formatter.replaceWith(replacement);
        }
        return formatter.getProcessedString();
    }
}

