/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.common.systemdata;

import de.aristaflow.adept2.model.common.Parameter;
import de.aristaflow.adept2.model.common.paramref.ParameterRef;
import de.aristaflow.adept2.model.common.paramref.ParameterRefParser;
import de.aristaflow.adept2.model.common.paramref.ParameterRefReplacer;
import de.aristaflow.adept2.model.common.paramref.ParameterRefTools;
import de.aristaflow.adept2.model.common.systemdata.BasicSystemDataFormatter;
import de.aristaflow.adept2.model.common.systemdata.SystemDataFormatter;
import de.aristaflow.adept2.model.globals.ProcessConstants;
import de.aristaflow.adept2.util.ArgChecks;
import de.aristaflow.adept2.util.LoggerTools;
import java.util.EnumSet;
import java.util.Map;
import java.util.logging.Level;

public final class SystemDataTools {
    private static final EnumSet<ProcessConstants.AdeptDataType> SUPPORTED_DATA_TYPES = EnumSet.of(ProcessConstants.AdeptDataType.INTEGER, new ProcessConstants.AdeptDataType[]{ProcessConstants.AdeptDataType.FLOAT, ProcessConstants.AdeptDataType.STRING, ProcessConstants.AdeptDataType.DATE, ProcessConstants.AdeptDataType.BOOLEAN, ProcessConstants.AdeptDataType.URI});

    public static ParameterRef[] findParameterReferences(String parameterisedString) {
        return ParameterRefTools.findParameterReferences(parameterisedString, SUPPORTED_DATA_TYPES);
    }

    public static ParameterRef parseParameterReference(String parameterReference) {
        return ParameterRefTools.parseParameterReference(parameterReference, SUPPORTED_DATA_TYPES);
    }

    public static ParameterRefParser getParser(String parameterisedString) {
        return ParameterRefTools.getParser(parameterisedString, SUPPORTED_DATA_TYPES);
    }

    public static ParameterRefReplacer getReplacer(String parameterisedString) {
        return ParameterRefTools.getReplacer(parameterisedString, SUPPORTED_DATA_TYPES);
    }

    public static String format(Class<? extends SystemDataFormatter> formatterClass, String parameterisedString, Map<String, Object> parameterValues) {
        SystemDataFormatter formatter;
        ArgChecks.checkForNull(formatterClass, "formatterClass");
        ArgChecks.checkForNull(parameterisedString, "parameterisedString");
        try {
            formatter = formatterClass.newInstance();
        }
        catch (Exception ex) {
            String msg = "The SystemDataFormatter %s could not be instantiated! Using BasicSystemDataFormatter as fallback.";
            msg = String.format(msg, formatterClass);
            LoggerTools.getLogger(SystemDataTools.class).log(Level.SEVERE, msg, ex);
            formatter = new BasicSystemDataFormatter();
        }
        return formatter.format(parameterisedString, parameterValues);
    }

    public static boolean isCompatibleParameter(ParameterRef paramRef, Parameter parameter) {
        boolean compatible = true;
        if (paramRef.getDataType() != parameter.getDataType() || !paramRef.getName().equals(parameter.getName())) {
            compatible = false;
        }
        return compatible;
    }

    private SystemDataTools() {
    }
}

