/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.common.viewer;

import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.model.common.PluginData;
import de.aristaflow.adept2.model.common.defaultimplementation.DefaultPluginData;
import de.aristaflow.adept2.model.common.paramref.ParameterRef;
import de.aristaflow.adept2.model.common.paramref.ParameterRefTools;
import de.aristaflow.adept2.model.common.viewer.Attribute;
import de.aristaflow.adept2.model.common.viewer.AttributeSetter;
import de.aristaflow.adept2.model.common.viewer.ModelViewer;
import de.aristaflow.adept2.model.common.viewer.ModelViewerTools;
import de.aristaflow.adept2.model.common.viewer.UnresolvedParameterReferenceException;
import de.aristaflow.adept2.model.common.viewer.ViewCheck;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.i18n.AristaFlowBundle;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class Handler<V>
implements InvocationHandler {
    protected final DummyObject object = new DummyObject();
    protected final Map<String, String> attributes;
    protected final Map<Method, String> attributeNames = new HashMap<Method, String>();
    protected final Set<Method> setters = new HashSet<Method>();
    protected final Class<V> view;
    protected final V proxy;
    protected final String prefix;
    protected final Map<String, Attribute> annotations = new HashMap<String, Attribute>();
    private final Locale locale;

    protected Handler(Map<String, String> attributes, Class<V> view, String prefix) {
        this(attributes, view, prefix, null);
    }

    public Handler(Map<String, String> attributes, Class<V> view, String prefix, Locale locale) {
        this.prefix = prefix;
        this.attributes = attributes;
        this.view = view;
        this.locale = locale;
        CheckReport report = new CheckReport(URI.create("class:/"));
        boolean check = ViewCheck.checkClass(report, view);
        if (!check) {
            throw new IllegalArgumentException("Viewer class is invalid:\n" + report.getReportSummary());
        }
        if (!ModelViewer.allowedTypes.contains(view)) {
            Method[] methodArray = view.getMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                String attributeName;
                Method method = methodArray[n2];
                Attribute attribute = method.getAnnotation(Attribute.class);
                AttributeSetter setter = method.getAnnotation(AttributeSetter.class);
                String string = attributeName = attribute != null ? attribute.name() : setter.value();
                if (attribute != null) {
                    this.annotations.put(attributeName, attribute);
                }
                if (setter != null) {
                    this.setters.add(method);
                }
                this.attributeNames.put(method, attributeName);
                ++n2;
            }
        }
        this.proxy = Proxy.newProxyInstance(view.getClassLoader(), new Class[]{view}, (InvocationHandler)this);
    }

    protected V getProxy() {
        return this.proxy;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass() != this.view) {
            Method[] methodArray = Object.class.getMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method m = methodArray[n2];
                if (m.equals(method)) {
                    return m.invoke((Object)this.object, args);
                }
                ++n2;
            }
        }
        String attributeName = this.attributeNames.get(method);
        if (!this.setters.contains(method)) {
            String value = this.attributes.get(Handler.concat(this.prefix, attributeName));
            Attribute attribute = this.annotations.get(attributeName);
            if (value == null && !attribute.defaultValue().equals("ATTRIBUTE_NO_DEFAULT_VALUE")) {
                value = attribute.defaultValue();
            }
            return this.fromString(this.prefix, attributeName, method.getReturnType(), Attribute.Type.DEFAULT, value);
        }
        this.toString(this.prefix, attributeName, method.getParameterTypes()[0], Attribute.Type.DEFAULT, args[0]);
        return null;
    }

    private static String concat(String prefix, String suffix) {
        if (prefix == null || prefix.equals("")) {
            return suffix;
        }
        if (prefix.endsWith(".")) {
            return String.valueOf(prefix) + suffix;
        }
        return String.valueOf(prefix) + "." + suffix;
    }

    private Object fromString(String prefix, String name, Class<?> type, Attribute.Type specialisation, String value) {
        if (type.isArray()) {
            int length;
            String lengthS = this.attributes.get(Handler.concat(Handler.concat(prefix, name), "length"));
            try {
                length = Integer.parseInt(lengthS);
            }
            catch (NumberFormatException numberFormatException) {
                length = 0;
            }
            Object array = Array.newInstance(type.getComponentType(), length);
            int i = 0;
            while (i < length) {
                String nameI = String.valueOf(name) + "[" + i + "]";
                String atomicValueS = this.attributes.get(String.valueOf(prefix) + nameI);
                Object atomicValue = this.fromString(prefix, nameI, type.getComponentType(), specialisation, atomicValueS);
                Array.set(array, i, atomicValue);
                ++i;
            }
            return array;
        }
        if (PluginData.class.isAssignableFrom(type)) {
            String pluginID = this.attributes.get(Handler.concat(Handler.concat(prefix, name), "ID"));
            if (pluginID == null || pluginID.equals("")) {
                return null;
            }
            HashMap<String, String> subAttributes = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
                String key = entry.getKey();
                if (!key.startsWith(String.valueOf(Handler.concat(prefix, name)) + ".") || key.equals(Handler.concat(Handler.concat(prefix, name), "ID"))) continue;
                String subKey = key.substring(Handler.concat(prefix, name).length() + 1, key.length());
                String subValue = this.attributes.get(key);
                subAttributes.put(subKey, subValue);
            }
            DefaultPluginData pluginData = new DefaultPluginData(pluginID, subAttributes);
            return pluginData;
        }
        if (QualifiedAgent.class.isAssignableFrom(type)) {
            if (value == null) {
                return null;
            }
            Pattern p = Pattern.compile("Agent\\[id='(.*?)', userName='(.*?)', orgPositionID='(.*?)', orgPositionName='(.*?)'\\]");
            Matcher m = p.matcher(value);
            if (m.find()) {
                long agentID = Long.valueOf(m.group(1));
                String agentUserName = m.group(2);
                long orgPositionID = Long.valueOf(m.group(3));
                String orgPositionName = m.group(4);
                return new QualifiedAgent(agentID, agentUserName, orgPositionID, orgPositionName);
            }
            return null;
        }
        if (URL.class.isAssignableFrom(type)) {
            if (value == null) {
                return null;
            }
            try {
                return new URL(value);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        if (!type.isEnum() && !ModelViewer.allowedTypes.contains(type)) {
            String newPrefix = Handler.concat(prefix, name);
            if (this.attributes.containsKey(newPrefix) || this.hasPrefix(this.attributes, newPrefix)) {
                return ModelViewer.createView(this.attributes, type, newPrefix, this.locale);
            }
            return null;
        }
        if (type == String.class && this.locale != null) {
            List<String> keys = AristaFlowBundle.getBundleKeyNames(this.locale);
            for (String key : keys) {
                if (!this.attributes.containsKey(Handler.concat(Handler.concat(prefix, name), key))) continue;
                value = this.attributes.get(Handler.concat(Handler.concat(prefix, name), key));
                break;
            }
            return value;
        }
        return this.atomicValueFromString(type, specialisation, value, prefix, name);
    }

    private boolean hasPrefix(Map<String, String> attributes, String prefix) {
        for (String keys : attributes.keySet()) {
            if (!keys.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    protected Object atomicValueFromString(Class<?> type, Attribute.Type specialisation, String value, String prefix, String name) {
        if (type == String.class) {
            return value;
        }
        if (value == null && (type == Integer.TYPE || type == Long.TYPE || type == Short.TYPE || type == Double.TYPE || type == Byte.TYPE || type == Character.TYPE)) {
            String message = String.format("The value for attribute %s%s is null, but null can't be returned", prefix, name);
            throw new RuntimeException(message);
        }
        if (value == null) {
            return null;
        }
        ParameterRef[] paramRefs = ParameterRefTools.findParameterReferences(value, null);
        try {
            if (type == Integer.TYPE || type == Integer.class) {
                if (paramRefs.length > 0) {
                    throw new UnresolvedParameterReferenceException(paramRefs, value);
                }
                return Integer.valueOf(value);
            }
            if (type == Long.TYPE || type == Long.class) {
                if (paramRefs.length > 0) {
                    throw new UnresolvedParameterReferenceException(paramRefs, value);
                }
                Long l = Long.valueOf(value);
                if ((specialisation == Attribute.Type.DATE || specialisation == Attribute.Type.TIME) && l < 0L) {
                    String message = "Invalid time stamp.";
                    throw new RuntimeException(message);
                }
                return l;
            }
            if (type == Short.TYPE || type == Short.class) {
                return Short.valueOf(value);
            }
            if (type == Double.TYPE || type == Double.class) {
                return Double.valueOf(value);
            }
            if (type == Byte.TYPE || type == Byte.class) {
                return Byte.valueOf(value);
            }
        }
        catch (NumberFormatException e) {
            String message = String.format("The content for attribute '%s'.'%s' does not match the type %s.", prefix, name, type.getSimpleName());
            throw new RuntimeException(message, e);
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return Boolean.valueOf(value);
        }
        if (type == Character.TYPE || type == Character.class) {
            return Character.valueOf(value.toCharArray()[0]);
        }
        if (type == UUID.class) {
            if (value.equals("")) {
                return null;
            }
            return UUID.fromString(value);
        }
        if (type.isEnum()) {
            if (value.equals("")) {
                return null;
            }
            try {
                return Enum.valueOf(type, value);
            }
            catch (IllegalArgumentException e) {
                String message = String.format("Only the values %s are allowed, but was %s.", Arrays.toString(type.getEnumConstants()), value);
                throw new RuntimeException(message, e);
            }
        }
        throw new RuntimeException("Error - can't handle return type " + type.getCanonicalName());
    }

    protected void toString(String prefix, String name, Class<?> type, Attribute.Type specialisation, Object object) {
        if (type.isArray()) {
            int length = Array.getLength(object);
            this.attributes.put(Handler.concat(Handler.concat(prefix, name), "length"), "" + length);
            Map<String, String> cloneAttr = this.attributes;
            int i = 0;
            while (i < length) {
                String nameI = String.valueOf(name) + "[" + i + "]";
                Object objectI = Array.get(object, i);
                Handler.cloneViewerObject(this.view, type.getComponentType(), prefix, nameI, objectI, cloneAttr);
                ++i;
            }
        } else if (PluginData.class.isAssignableFrom(type)) {
            if (object != null) {
                PluginData pluginData = (PluginData)object;
                this.attributes.put(Handler.concat(Handler.concat(prefix, name), "ID"), pluginData.getPluginID());
                for (Map.Entry<String, String> entry : pluginData.getPluginData().entrySet()) {
                    this.attributes.put(Handler.concat(Handler.concat(prefix, name), entry.getKey()), entry.getValue());
                }
            } else {
                Iterator<Map.Entry<String, String>> iterator = this.attributes.entrySet().iterator();
                String newPrefix = Handler.concat(prefix, name);
                while (iterator.hasNext()) {
                    Map.Entry<String, String> entry = iterator.next();
                    if (!entry.getKey().startsWith(newPrefix)) continue;
                    iterator.remove();
                }
            }
        } else if (QualifiedAgent.class.isAssignableFrom(type)) {
            if (object != null) {
                String s = object.toString();
                this.attributes.put(Handler.concat(prefix, name), s);
            }
        } else if (URL.class.isAssignableFrom(type)) {
            if (object != null) {
                String s = ((URL)object).toExternalForm();
                this.attributes.put(Handler.concat(prefix, name), s);
            }
        } else if (UUID.class.isAssignableFrom(type)) {
            UUID uuid = (UUID)object;
            if (uuid != null) {
                this.attributes.put(Handler.concat(prefix, name), uuid.toString());
            } else {
                this.attributes.put(Handler.concat(prefix, name), null);
            }
        } else if (!type.isEnum() && !ModelViewer.allowedTypes.contains(type)) {
            String newPrefix = Handler.concat(prefix, name);
            if (object != null) {
                Object innerView = object;
                this.attributes.put(newPrefix, "");
                Method[] methodArray = type.getMethods();
                int n = methodArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Method method = methodArray[n2];
                    if (method.getReturnType() != Void.TYPE) {
                        Object res;
                        Attribute attribute = method.getAnnotation(Attribute.class);
                        try {
                            res = method.invoke(innerView, new Object[0]);
                        }
                        catch (IllegalArgumentException e) {
                            throw new RuntimeException(e);
                        }
                        catch (IllegalAccessException e) {
                            throw new RuntimeException(e);
                        }
                        catch (InvocationTargetException e) {
                            if (e.getCause() instanceof UnresolvedParameterReferenceException) {
                                UnresolvedParameterReferenceException pre = (UnresolvedParameterReferenceException)e.getCause();
                                res = pre.getValue();
                            }
                            throw new RuntimeException(e);
                        }
                        this.toString(newPrefix, attribute.name(), method.getReturnType(), attribute.type(), res);
                    }
                    ++n2;
                }
            } else {
                Iterator<Map.Entry<String, String>> iterator = this.attributes.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, String> entry = iterator.next();
                    if (!entry.getKey().startsWith(newPrefix)) continue;
                    iterator.remove();
                }
            }
        } else {
            this.attributes.put(Handler.concat(prefix, name), this.atomicToString(type, specialisation, object));
        }
    }

    protected String atomicToString(Class<?> type, Attribute.Type specialisation, Object object) {
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    private static void cloneViewerObject(Class<?> parentViewer, Class<?> clazz, String prefix, String name, Object object, Map<String, String> targetAttributes) {
        if (!ModelViewerTools.isComplexAttribute(clazz)) {
            Handler handler = new Handler(targetAttributes, parentViewer, prefix, null);
            handler.toString(prefix, name, clazz, null, object);
        } else {
            Handler handler = new Handler(targetAttributes, clazz, prefix, null);
            String newPrefix = Handler.concat(prefix, name);
            Method[] methodArray = clazz.getMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (method.getReturnType() != Void.TYPE) {
                    Object res;
                    Attribute attribute = method.getAnnotation(Attribute.class);
                    try {
                        res = method.invoke(object, new Object[0]);
                    }
                    catch (IllegalArgumentException e) {
                        throw new RuntimeException(e);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                    catch (InvocationTargetException e) {
                        if (e.getCause() instanceof UnresolvedParameterReferenceException) {
                            UnresolvedParameterReferenceException pre = (UnresolvedParameterReferenceException)e.getCause();
                            res = pre.getValue();
                        }
                        throw new RuntimeException(e);
                    }
                    handler.toString(newPrefix, attribute.name(), method.getReturnType(), attribute.type(), res);
                }
                ++n2;
            }
        }
    }

    protected class DummyObject {
        protected DummyObject() {
        }

        public boolean equals(Object obj) {
            return obj == Handler.this.proxy;
        }

        public int hashCode() {
            return super.hashCode();
        }
    }
}

