/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.common.viewer;

import de.aristaflow.adept2.base.sessionmanagement.QualifiedAgent;
import de.aristaflow.adept2.model.common.PluginData;
import de.aristaflow.adept2.model.common.viewer.Handler;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class ModelViewer {
    public static final Class<?>[] allowedTypesArray = new Class[]{Integer.TYPE, Integer.class, Long.TYPE, Long.class, Short.TYPE, Short.class, Double.TYPE, Double.class, Float.TYPE, Float.class, Byte.TYPE, Byte.class, Character.TYPE, Character.class, Boolean.TYPE, Boolean.class, String.class, Enum.class, PluginData.class, UUID.class, URL.class, QualifiedAgent.class};
    protected static final Set<Class<?>> allowedTypes;
    protected static final Set<Class<?>> allowedConsumerTypes;

    static {
        HashSet temp = new HashSet();
        temp.addAll(Arrays.asList(allowedTypesArray));
        allowedTypes = Collections.unmodifiableSet(temp);
        HashSet<Class> consumerTypes = new HashSet<Class>();
        consumerTypes.add(Integer.TYPE);
        consumerTypes.add(Integer.class);
        consumerTypes.add(Long.TYPE);
        consumerTypes.add(Long.class);
        consumerTypes.add(String.class);
        allowedConsumerTypes = Collections.unmodifiableSet(consumerTypes);
    }

    public static <V> V createView(Map<String, String> attributes, Class<V> view) {
        return ModelViewer.createView(attributes, view, "", null);
    }

    public static <V> V createView(Map<String, String> attributes, Class<V> view, Locale locale) {
        return ModelViewer.createView(attributes, view, "", locale);
    }

    public static <V> V createNew(Class<V> view) {
        return ModelViewer.createView(new HashMap<String, String>(), view, "", null);
    }

    protected static <V> V createView(Map<String, String> attributes, Class<V> view, String prefix, Locale locale) {
        Handler<V> handler = new Handler<V>(attributes, view, prefix, locale);
        return handler.getProxy();
    }
}

