/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.common.viewer;

import de.aristaflow.adept2.model.common.systemdata.SystemDataConsumer;
import de.aristaflow.adept2.model.common.viewer.Attribute;
import de.aristaflow.adept2.model.common.viewer.ModelViewer;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ModelViewerTools<V> {
    private final Map<String, String> attributes;
    private final Class<V> viewer;
    private final String prefix;
    private final Map<String, SystemDataConsumer> systemDataConsumers = new HashMap<String, SystemDataConsumer>();
    private final Map<String, Method> systemDataConsumerMethods = new HashMap<String, Method>();
    private final Map<String, Attribute> localisedAttributes = new HashMap<String, Attribute>();
    private final Map<String, Method> localisedAttributeMethods = new HashMap<String, Method>();
    private Map<String, Attribute> annotations = new HashMap<String, Attribute>();
    private Map<String, Method> complexAttributeGetters = new HashMap<String, Method>();
    private Map<String, Method> attributeGetters = new HashMap<String, Method>();

    public ModelViewerTools(Class<V> viewer, Map<String, String> attributes) {
        this(viewer, "", attributes);
    }

    protected ModelViewerTools(Class<V> viewer, String prefix, Map<String, String> attributes) {
        Method method;
        this.viewer = viewer;
        this.prefix = prefix;
        this.attributes = attributes;
        if (!prefix.equals("") || prefix.endsWith(".")) {
            throw new IllegalArgumentException(String.format("Illegal prefix '%s'", prefix));
        }
        ModelViewer.createNew(viewer);
        Method[] methodArray = viewer.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            method = methodArray[n2];
            Class<?> returnType = method.getReturnType();
            if (returnType != Void.TYPE) {
                Attribute attribute = method.getAnnotation(Attribute.class);
                if (method.isAnnotationPresent(SystemDataConsumer.class)) {
                    this.systemDataConsumers.put(attribute.name(), method.getAnnotation(SystemDataConsumer.class));
                    this.systemDataConsumerMethods.put(attribute.name(), method);
                }
                this.attributeGetters.put(attribute.name(), method);
                if (ModelViewerTools.isComplexAttribute(returnType)) {
                    this.complexAttributeGetters.put(attribute.name(), method);
                }
            }
            ++n2;
        }
        methodArray = viewer.getMethods();
        n = methodArray.length;
        n2 = 0;
        while (n2 < n) {
            method = methodArray[n2];
            Attribute attribute = method.getAnnotation(Attribute.class);
            if (attribute != null) {
                this.annotations.put(attribute.name(), attribute);
                if (attribute.localised()) {
                    this.localisedAttributes.put(attribute.name(), attribute);
                    this.localisedAttributeMethods.put(attribute.name(), method);
                }
            }
            ++n2;
        }
    }

    public Set<String> getLocalisedAttributes() {
        return Collections.unmodifiableSet(this.localisedAttributes.keySet());
    }

    public void setTranslation(String attribute, Map<String, String> translations) {
        if (!this.localisedAttributes.containsKey(attribute)) {
            throw new IllegalArgumentException(String.format("Attribute '%s' is not localised.", attribute));
        }
        for (Map.Entry<String, String> entry : translations.entrySet()) {
            this.attributes.put(String.valueOf(this.prefix) + attribute + "." + entry.getKey(), entry.getValue());
        }
    }

    public Map<String, SystemDataConsumer> getSystemDataConsumerAttributes() {
        return Collections.unmodifiableMap(this.systemDataConsumers);
    }

    public Map<String, Attribute> getAttributes() {
        return Collections.unmodifiableMap(this.annotations);
    }

    public Map<String, Method> getAttributeGetters() {
        return Collections.unmodifiableMap(this.attributeGetters);
    }

    public Map<String, Method> getComplexMethods() {
        return Collections.unmodifiableMap(this.complexAttributeGetters);
    }

    public static boolean isComplexAttribute(Class<?> clazz) {
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        return !clazz.isEnum() && !ModelViewer.allowedTypes.contains(clazz);
    }
}

