/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.common.viewer;

import de.aristaflow.adept2.model.common.systemdata.SystemDataConsumer;
import de.aristaflow.adept2.model.common.viewer.Attribute;
import de.aristaflow.adept2.model.common.viewer.AttributeSetter;
import de.aristaflow.adept2.model.common.viewer.ModelViewer;
import de.aristaflow.adept2.model.common.viewer.UnresolvedParameterReferenceException;
import de.aristaflow.adept2.util.CheckReport;
import de.aristaflow.adept2.util.LoggerTools;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class ViewCheck {
    private static final Logger logger = LoggerTools.getLogger(ViewCheck.class);
    public static final String ID = "VIEW_CHECK";

    public static boolean checkClass(CheckReport report, Class<?> view) {
        boolean allOK = true;
        URI affectedElement = URI.create("class:/" + view.getCanonicalName());
        if (!view.isInterface()) {
            String message = String.format("Only interfaces can be used as model viewer targets, %s is a class.'", view);
            ViewCheck.addReportEntry(report, message, affectedElement);
            return false;
        }
        if (ModelViewer.allowedTypes.contains(view)) {
            return true;
        }
        HashMap<String, Attribute> attributes = new HashMap<String, Attribute>();
        HashMap<String, Method> getters = new HashMap<String, Method>();
        HashMap<String, Method> setters = new HashMap<String, Method>();
        Method[] methodArray = view.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            String message;
            Method method = methodArray[n2];
            Attribute attribute = method.getAnnotation(Attribute.class);
            SystemDataConsumer consumer = method.getAnnotation(SystemDataConsumer.class);
            AttributeSetter setter = method.getAnnotation(AttributeSetter.class);
            if (attribute != null && setter != null) {
                allOK = false;
                message = String.format("Method '%s' must have either Attribute or AttributeSetter as annotation, but not both'", method);
                ViewCheck.addReportEntry(report, message, affectedElement);
            } else if (attribute != null) {
                if (consumer != null) {
                    if (!ModelViewer.allowedConsumerTypes.contains(method.getReturnType())) {
                        allOK = false;
                        message = String.format("The method '%s' is a SystemDataConsumer but the type '%s' is not allowed as consumer.", method, method.getReturnType());
                        ViewCheck.addReportEntry(report, message, affectedElement);
                    }
                    boolean found = false;
                    Class<?>[] classArray = method.getExceptionTypes();
                    int n3 = classArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Class<?> e = classArray[n4];
                        if (UnresolvedParameterReferenceException.class.isAssignableFrom(e)) {
                            found = true;
                            break;
                        }
                        ++n4;
                    }
                    if (!found) {
                        allOK = false;
                        String message2 = String.format("The method '%s' is a SystemDataConsumer but does 'not declare the %s.", method, UnresolvedParameterReferenceException.class.getSimpleName());
                        ViewCheck.addReportEntry(report, message2, affectedElement);
                    }
                }
                if (attributes.containsKey(attribute.name())) {
                    allOK = false;
                    String message3 = String.format("The attribute '%s' is used more than once (by method '%s' and method '%s').", attribute.name(), getters.get(attribute.name()), method);
                    ViewCheck.addReportEntry(report, message3, affectedElement);
                }
                attributes.put(attribute.name(), attribute);
                getters.put(attribute.name(), method);
                if (method.getParameterTypes().length > 0) {
                    allOK = false;
                    String message4 = String.format("The getter '%s' must not have any parameters.", method);
                    ViewCheck.addReportEntry(report, message4, affectedElement);
                }
                if (method.getReturnType() == Void.TYPE) {
                    allOK = false;
                    String message5 = String.format("The getter '%s' must not be void.", method);
                    ViewCheck.addReportEntry(report, message5, affectedElement);
                }
                allOK &= ViewCheck.checkType(method.getReturnType(), report);
                if (attribute.localised() && method.getReturnType() != String.class) {
                    allOK = false;
                    String message6 = String.format("Only String attributes may be localised, '%s' is of type '%s'", attribute.name(), method.getReturnType());
                    ViewCheck.addReportEntry(report, message6, affectedElement);
                }
            } else if (setter != null) {
                if (method.isAnnotationPresent(SystemDataConsumer.class)) {
                    allOK = false;
                    message = String.format("The method '%s' is a setter but has a SystemDataConsumer annotation.", method);
                    ViewCheck.addReportEntry(report, message, affectedElement);
                }
                if (setters.containsKey(setter.value())) {
                    allOK = false;
                    message = String.format("The attribute '%s' is used more than once (by method '%s' and method '%s').", setter.value(), setters.get(setter.value()), method);
                    ViewCheck.addReportEntry(report, message, affectedElement);
                }
                setters.put(setter.value(), method);
                if (method.getParameterTypes().length != 1) {
                    allOK = false;
                    message = String.format("The setter '%s' must have a single parameter.", method);
                    ViewCheck.addReportEntry(report, message, affectedElement);
                }
                if (method.getReturnType() != Void.TYPE) {
                    allOK = false;
                    message = String.format("The getter '%s' must not be void.", method);
                    ViewCheck.addReportEntry(report, message, affectedElement);
                }
            } else {
                allOK = false;
                message = String.format("Method '%s' has no annotation.", method.getName());
                ViewCheck.addReportEntry(report, message, affectedElement);
            }
            ++n2;
        }
        for (String string : setters.keySet()) {
            if (getters.containsKey(string)) continue;
            allOK = false;
            String message = String.format("Attribute '%s' has a setter, but no getter.", string);
            ViewCheck.addReportEntry(report, message, affectedElement);
        }
        for (Map.Entry entry : getters.entrySet()) {
            Method setter = (Method)setters.get(entry.getKey());
            if (setter == null || setter.getParameterTypes().length != 1 || ((Method)entry.getValue()).getReturnType() == setter.getParameterTypes()[0]) continue;
            allOK = false;
            String message = String.format("The type of the setter '%s' does not match set type of the getter '%s'.", setter, entry.getValue());
            ViewCheck.addReportEntry(report, message, affectedElement);
        }
        for (String string : getters.keySet()) {
            if (string.indexOf(91) == -1 && string.indexOf(93) == -1 && string.indexOf(46) == -1) continue;
            allOK = false;
            String message = String.format("The attribute name '%s' has illegal characters.", string);
            ViewCheck.addReportEntry(report, message, affectedElement);
        }
        return allOK;
    }

    public boolean checkData(Map<String, String> data, CheckReport report, Class<?> view) {
        boolean allOK = true;
        Method[] methodArray = view.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            Attribute attribute = method.getAnnotation(Attribute.class);
            if (attribute == null) {
                String message = String.format("The view class is not valid, the annotation is missing.", new Object[0]);
                throw new IllegalArgumentException(message);
            }
            String name = attribute.name();
            String defaultValue = attribute.defaultValue();
            String value = data.get(name);
            allOK &= this.checkEntry(name, value, defaultValue, report, data, view);
            ++n2;
        }
        return allOK;
    }

    public boolean checkEntry(String name, String value, String defaultValue, CheckReport report, Map<String, String> data, Class<?> viewer) {
        boolean allOK = true;
        URI affectedElement = null;
        if (report != null) {
            affectedElement = URI.create(report.getBase() + "/" + name);
        }
        if (value == null) {
            if (defaultValue.equals("ATTRIBUTE_NO_DEFAULT_VALUE")) {
                allOK = false;
                String message = String.format("The mandatory value is missing.", new Object[0]);
                if (report != null) {
                    report.addReportEntry(ID, CheckReport.ResultType.FAILURE, message, affectedElement);
                }
                logger.info(message);
                return allOK;
            }
            value = defaultValue;
        }
        return allOK;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean checkType(Class<?> clazz, CheckReport report) {
        if (!clazz.isEnum()) ** GOTO lbl4
        return true;
lbl-1000:
        // 1 sources

        {
            clazz = clazz.getComponentType();
lbl4:
            // 2 sources

            ** while (clazz.isArray())
        }
lbl5:
        // 1 sources

        if (!ModelViewer.allowedTypes.contains(clazz) && !ViewCheck.checkClass(report, clazz)) {
            message = String.format("The type '%s' is not a valid attribute type, since it is neither a simple type nor a valid view.", new Object[]{clazz});
            ViewCheck.addReportEntry(report, message, report.getBase());
            return false;
        }
        return true;
    }

    protected static void addReportEntry(CheckReport report, String message, URI affectedElement) {
        logger.info(message);
        if (report != null) {
            report.addReportEntry(ID, CheckReport.ResultType.FAILURE, message, affectedElement);
        }
    }
}

