/*
 * Decompiled with CFR 0.152.
 */
package de.aristaflow.adept2.model.datamanagement;

import de.aristaflow.adept2.model.datamanagement.UDTValue;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;

public class ADEPT2UDTValue
implements UDTValue {
    private static final long serialVersionUID = 4835159103100283148L;
    protected String userDefinedTypeName;
    protected byte[] value;

    public ADEPT2UDTValue(String userDefinedType, byte[] value) {
        this.userDefinedTypeName = userDefinedType;
        this.value = (byte[])value.clone();
    }

    public ADEPT2UDTValue(String userDefinedType, InputStream stream) {
        this.userDefinedTypeName = userDefinedType;
        try {
            try {
                int length = stream.available();
                if (length > 0) {
                    this.value = new byte[length];
                    stream.read(this.value);
                } else {
                    this.value = new byte[0];
                }
            }
            finally {
                stream.close();
            }
        }
        catch (IOException ioe) {
            String msg = String.format("Exception while trying to read the value (input stream) of the UDT '%1$s'.", userDefinedType);
            throw new RuntimeException(msg, ioe);
        }
    }

    @Override
    public String getUserDefinedType() {
        return this.userDefinedTypeName;
    }

    @Override
    public InputStream getValueAsStream() {
        return new ByteArrayInputStream(this.value);
    }

    @Override
    public byte[] getValueAsArray() {
        return (byte[])this.value.clone();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        ObjectOutputStream.PutField fields = out.putFields();
        fields.put("userDefinedTypeName", this.userDefinedTypeName);
        fields.put("value", this.value);
        out.writeFields();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = in.readFields();
        this.userDefinedTypeName = (String)fields.get("userDefinedTypeName", "");
        this.value = (byte[])fields.get("value", new byte[0]);
    }

    public String toString() {
        StringBuilder ret = new StringBuilder("");
        int size = this.getValueAsArray().length;
        if (size < 2048) {
            ret.append(" Bytes of Data");
        } else if ((size /= 1024) < 2048) {
            ret.append(" KB of Data");
        } else {
            size /= 1024;
            ret.append(" MB of Data");
        }
        ret.insert(0, size);
        return ret.toString();
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof UDTValue) {
            UDTValue udt = (UDTValue)obj;
            result = Arrays.equals(this.getValueAsArray(), udt.getValueAsArray());
        }
        return result;
    }

    public int hashCode() {
        return this.userDefinedTypeName.hashCode() ^ this.value.length ^ Arrays.hashCode(this.value);
    }
}

